/**
 * This file is part of Totara Enterprise Extensions.
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * Totara Enterprise Extensions is provided only to Totara
 * Learning Solutions LTD's customers and partners, pursuant to
 * the terms and conditions of a separate agreement with Totara
 * Learning Solutions LTD or its affiliate.
 *
 * If you do not have an agreement with Totara Learning Solutions
 * LTD, you may not access, use, modify, or distribute this software.
 * Please contact [licensing@totaralearning.com] for more information.
 *
 * @author Simon Chester <simon.chester@totaralearning.com>
 * @module totara_core
 */

const path = require('path');
const { resolveRequest } = require('../lib/resolution');

module.exports = (request, options) => {
  let match;
  if (request === 'tui_test_utils') {
    return options.defaultResolver(
      path.join(__dirname, 'tui_test_utils'),
      options
    );
  }
  match = /^tui_test_utils\/(.*)$/.exec(request);
  if (match) {
    return options.defaultResolver(
      path.join(__dirname, 'tui_test_utils', match[1]),
      options
    );
  }

  // handle frankenstyle imports
  if (request[0] != '.') {
    const req = resolveRequest(request);
    if (req) {
      return options.defaultResolver(req, options);
    }
  }
  return options.defaultResolver(request, options);
};
