/**
 * This file is part of Totara Enterprise Extensions.
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * Totara Enterprise Extensions is provided only to Totara
 * Learning Solutions LTD's customers and partners, pursuant to
 * the terms and conditions of a separate agreement with Totara
 * Learning Solutions LTD or its affiliate.
 *
 * If you do not have an agreement with Totara Learning Solutions
 * LTD, you may not access, use, modify, or distribute this software.
 * Please contact [licensing@totaralearning.com] for more information.
 *
 * @author Simon Chester <simon.chester@totaralearning.com>
 * @module tui
 */

const { rimraf } = require('rimraf');
const path = require('path');
const { readdir } = require('fs/promises');
const { clientDir } = require('../lib/common');

async function clean(opts = {}) {
  const componentDir = path.join(clientDir, 'component');
  const components = (await readdir(componentDir, { withFileTypes: true }))
    .filter(
      x => x.isDirectory() && (!opts.components || opts.components.includes(x))
    )
    .map(x => x.name);
  await Promise.all(
    components.map(async component => {
      const buildDir = path.join(componentDir, component, 'build');
      await rimraf(buildDir);
    })
  );
}

module.exports = {
  clean,
};
