<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2019 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Johannes Cilliers <johannes.cilliers@totaralearning.com>
 * @package tool_sitepolicy
 */

if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

$observers = array(
    array(
        'eventname' => '\auth_approved\event\request_added',
        'callback'  => 'tool_sitepolicy\observer\request_added_observer::reset_site_policy',
    ),
    array(
        'eventname' => '\auth_approved\event\request_approved',
        'callback'  => 'tool_sitepolicy\observer\request_approved_observer::update_user_consent',
    ),
    array(
        'eventname' => '\core\event\user_confirmed',
        'callback'  => 'tool_sitepolicy\observer\user_confirmed_observer::update_user_consent',
    ),
);
