<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Matthias Bonk <matthias.bonk@totara.com>
 * @package core_badges
 */

namespace core_badges\entity;

use core\orm\entity\entity;

/**
 * Badge email verify entity
 *
 * Properties:
 *
 * @property-read int $id
 * @property int $user_id
 * @property string $secret
 * @property string $address email address
 * @property string $backpackid
 * @property string $password encrypted password
 */
class badge_email_verify extends entity {
    /**
     * @var string
     */
    public const TABLE = 'badge_email_verify';
}