<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @author Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package container_workspace
 */

$string['accept_member_request'] = 'Request approved. {$a} was added as a member.';
$string['actions'] = 'Actions';
$string['actions_label'] = '{$a} actions';
$string['active'] = 'Active';
$string['add_audiences'] = 'Add audiences';
$string['add_audiences_background_notice'] = 'Members from selected audiences will be continuously updated with this workspace. The initial update may take a while with a large audience.';
$string['add_audiences_started_message'] = 'Audiences added. The members list will update shortly.';
$string['add_members'] = 'Add members';
$string['add_members_to_space'] = 'Add members to workspace';
$string['all'] = 'All';
$string['alphabet'] = 'A-Z';
$string['approve'] = 'Approve';
$string['approve_member'] = 'Approve member request {$a}';
$string['approved'] = 'Approved';
$string['approved_request_message'] = 'You are now a member of the {$a} workspace';
$string['approved_request_title'] = 'Approved request to join workspace';
$string['audience_id'] = 'Audience ID';
$string['audience_members'] = 'Members';
$string['audience_name'] = 'Audience name';
$string['audience_removed'] = 'Audience removed';
$string['audiences_for_member_x'] = 'Audiences for member "{$a}"';
$string['audiences_tab_label'] = 'Audiences ({$a})';
$string['back_button'] = '{$a}';
$string['back_to_discussions'] = "Back to discussions";
$string['bracket_number'] = '({$a})';
$string['browse_files'] = 'Browse files';
$string['cachedef_draft_id'] = 'Draft IDs';
$string['cachedef_workspace'] = 'Workspace';
$string['cancel_request'] = 'Cancel request';
$string['category_name'] = 'Space category';
$string['collaborate'] = 'Collaborate';
$string['collapse_nav'] = 'Collapse navigation selection';
$string['comment'] = 'Comment';
$string['comment_on_discussion'] = 'Comment on discussion';
$string['comment_on_discussion_message'] = '{$a->author} has commented on your discussion post in the {$a->workspace_name} workspace';
$string['comment_on_discussion_title'] = '{$a} has commented on your discussion post';
$string['contribute_adder_text'] = "Add existing <AddResourcesLink>resources</AddResourcesLink> or <AddCoursesLink>courses</AddCoursesLink> to this workspace";
$string['copied_to_clipboard'] = 'Copied to clipboard';
$string['copy_discussion_link_text'] = 'Copy link';
$string['create_new_discussion_message'] = '{$a->author} posted in {$a->workspace}: "{$a->discussion}"';
$string['create_new_discussion_title'] = 'New discussion by {$a->name} in {$a->workspace}';
$string['create_space'] = 'Create a workspace';
$string['current_owner'] = "Current owner";
$string['current_owner_suspended'] = '{$a} (suspended)';
$string['date_posted'] = 'Date posted';
$string['decline'] = 'Decline';
$string['decline_member'] = 'Decline member request {$a}';
$string['decline_member_request'] = 'Request declined.';
$string['decline_request'] = 'Decline this request';
$string['decline_request_message'] = 'Your request to join the private workspace {$a->workspace_name} has been declined. {$a->content}';
$string['decline_request_subject'] = 'Your request to join {$a} has been declined';
$string['decline_request_text'] = 'Write to the requesting user (optional)';
$string['declined'] = 'Declined';
$string['delete_discussion_title'] = "Delete discussion";
$string['delete_discussion_warning_msg_1'] = 'Are you sure you want to delete this discussion?';
$string['delete_discussion_warning_msg_2'] = 'All comments, replies and likes will also be deleted.';
$string['delete_warning_title'] = 'Delete workspace?';
$string['delete_workspace'] = 'Delete workspace';
$string['delete_workspace_warning_msg_1'] = 'Are you sure you want to delete this workspace?';
$string['delete_workspace_warning_msg_2'] = 'This will permanently delete all discussions and attachments in this workspace. Resources and playlists in the workspace library will continue to exist in other areas of this site.';
$string['description_label'] = 'Description';
$string['discuss_tab_label'] = 'Discussions';
$string['discussion'] = 'Discussion';
$string['discussion_actions'] = 'Discussion\'s actions';
$string['discussion_created'] = 'Discussion created';
$string['discussion_deleted'] = 'Discussion deleted';
$string['discussion_soft_deleted'] = 'Discussion soft-deleted';
$string['discussion_updated'] = 'Discussion updated';
$string['discussions'] = 'Discussions';
$string['discussions_list'] = "Discussion list";
$string['done'] = 'Done';
$string['edit_image'] = 'Edit image';
$string['edit_space'] = 'Edit workspace';
$string['edited'] = 'Edited';
$string['enable_workspaces'] = 'Workspaces';
$string['enable_workspaces_description'] = 'When enabled this will allow users to create, discover, and collaborate within workspaces. If disabled, workspaces will be hidden from all site menus and API services will not be accessible.';
$string['event_bulk_audience_added'] = 'Added audience members in bulk to workspace';
$string['event_member_left'] = 'Member left workspace';
$string['event_member_removed'] = 'Removed member from workspace';
$string['event_member_role_changed'] = 'Workspace member role changed';
$string['expand_nav'] = 'Expand for navigation selection';
$string['field:timecreated'] = 'Time created';
$string['field:name'] = 'Name';
$string['field:summary'] = 'Summary';
$string['file_audio'] = 'AUDIO';
$string['file_date'] = 'Date';
$string['file_format'] = 'File format';
$string['file_image'] = 'IMAGE';
$string['file_name'] = 'File name';
$string['file_others'] = 'OTHERS';
$string['file_preview_empty'] = 'Sorry, there is no preview for this file.';
$string['file_video'] = 'VIDEO';
$string['files'] = 'Files';
$string['filter_audiences'] = 'Search audiences';
$string['find_contents'] = 'Find contents';
$string['find_spaces'] = 'Find workspaces';
$string['format'] = 'Format';
$string['hidden'] = 'Hidden';
$string['hidden_workspace'] = 'Hidden workspace';
$string['hidden_workspace_text'] = 'Hide this workspace from non-members';
$string['invalid_access'] = 'Invalid access';
$string['invalid_workspace'] = 'Invalid workspace';
$string['join_discussion'] = 'Join the discussion';
$string['join_me'] = 'Join';
$string['join_space'] = 'Join workspace {$a}';
$string['join_workspace'] = 'Join workspace';
$string['joined'] = 'Joined';
$string['last_updated'] = 'Last updated';
$string['leave'] = 'Leave';
$string['leave_prevented_due_to_group_membership_message'] = 'Since you were added as part of a group, you won\'t be able to leave this workspace. You can mute notifications if you don\'t want to follow this workspace.';
$string['leave_workspace'] = 'Leave workspace';
$string['leave_workspace_message'] = 'Are you sure you want to leave this workspace?';
$string['leave_workspace_message_not_public'] = "Are you sure you want to leave this workspace? You may lose access to content with limited visibility, including any you've saved to your library.";
$string['library_tab_label'] = 'Library';
$string['like_discussion'] = 'Like discussion';
$string['loadmore'] = 'Load more';
$string['member'] = 'Member';
$string['member_added_through_audiences_label'] = 'This member was added through the following audiences:';
$string['member_and_owned'] = 'Member (including owner)';
$string['member_list'] = 'Members List';
$string['member_request_message'] = '{$a->user} has requested to join your {$a->workspace_name} workspace';
$string['member_request_title'] = 'Request to join your workspace';
$string['member_removal_condition_failed:can_be_removed'] = 'The user with id {$a} can not be removed from the owner users.';
$string['member_tab_label'] = 'Members ({$a})';
$string['membership'] = 'Membership';
$string['mentionbody:discussion'] = '<strong>{$a->fullname}</strong> has mentioned you in a discussion post in the {$a->title} workspace.';
$string['mentiontitle:discussion'] = '{$a} has mentioned you in a discussion post';
$string['mentionview:discussion'] = 'View post';
$string['message_content_added'] = '<p>{$a->fullname} has shared \'{$a->item_name}\' to the {$a->workspace_name} library.</p><p>View content: {$a->url}</p>';
$string['message_content_added_subject'] = 'New {$a} has been shared to your workspace';
$string['missing_permission_to_add_owners'] = 'No permission to add owners to this workspace';
$string['more_action_for_member'] = 'More actions for member {$a}';
$string['mute_notifications'] = 'Mute notifications';
$string['mute_workspace'] = 'Mute workspace';
$string['no_audiences_added'] = 'No audiences added';
$string['no_discussion_result'] = "No results found.";
$string['no_file_found'] = 'No files have been uploaded in this workspace\'s discussions.';
$string['no_member_found'] = 'No members match your search. Please try again.';
$string['no_spaces'] = "You don't currently belong to any workspaces";
$string['non_member'] = "Non-member";
$string['notification_deleted'] = 'The workspace "{$a}" was deleted successfully';
$string['one_member'] = '1 member';
$string['or'] = 'Or';
$string['owner'] = 'Owner';
$string['owner_addition_condition_failed:empty_list'] = "Cannot run add owners if the list of owner ids is empty";
$string['owner_addition_condition_failed:user_cannot_access_workspace'] = 'New owner does not have ability to access the workspace';
$string['owner_addition_condition_failed:user_is_already_an_owner'] = 'User is already an owner of the workspace';
$string['owner_addition_condition_failed:user_is_not_a_member'] = 'User is not a member of the workspace';
$string['owner_addition_condition_failed:user_is_suspended'] = 'User is suspended';
$string['owner_removal_condition_failed:can_manage'] = 'Actor does not have ability to remove workspace owner';
$string['owner_removal_condition_failed:empty_list'] = "Cannot run remove owners if the list of owner ids is empty";
$string['owner_removal_condition_failed:remaining_owner_count'] = "Cannot remove the owners, at least one remaining owner should be left, add a new owner first";
$string['owner_removal_condition_failed:too_many_owners_to_remove'] = "The maximum amount of removed owners is exceeded";
$string['pinned_post'] = 'Pinned post';
$string['pluginname'] = 'Workspace';
$string['private'] = 'Private';
$string['private_workspace'] = 'Private workspace';
$string['public'] = 'Public';
$string['public_workspace'] = 'Public workspace';
$string['recent'] = 'Recent';
$string['recent_joined'] = 'Recently joined';
$string['recommended_spaces'] = 'Recommended workspaces';
$string['remove_audience_warning_bullet_1'] = 'All audience members will be removed from the workspace';
$string['remove_audience_warning_bullet_2'] = 'Any content they shared will remain, including resources, playlists, discussions, and comments';
$string['remove_audience_warning_msg'] = 'Are you sure you want to remove "{$a->audience}" from "{$a->workspace}"?';
$string['remove_like_discussion'] = 'Remove like for discussion';
$string['remove_member_as_owner'] = 'Remove as owner';
$string['remove_member_as_owner_modal_title'] = 'Remove as owner';
$string['remove_member_as_owner_modal_body'] = '{$a} will be removed as an owner of this workspace.';
$string['remove_member_as_owner_modal_body_confirm'] = 'Are you sure you want to continue?';
$string['remove_member_as_owner_success'] = '{$a->user} has been successfully removed as the owner of the {$a->workspace} workspace.';
$string['remove_member_from_workspace'] = 'Remove from workspace';
$string['remove_member_title_warning_msg'] = 'Remove member';
$string['remove_member_warning_msg'] = 'Are you sure you want to remove {$a} from this workspace?';
$string['remove_x'] = 'Remove "{$a}"';
$string['removed_discussion'] = 'This discussion has been removed.';
$string['report_discussion'] = 'Report';
$string['request_to_join'] = "Request to join";
$string['request_to_join_pending'] = 'Your request to join is awaiting approval';
$string['request_to_join_space'] = 'Request to join workspace {$a}';
$string['request_to_join_text'] = 'Write to workspace administrators (optional)';
$string['requested_to_join'] = 'Requested';
$string['requests_to_join'] = "Requests to join this workspace";
$string['save'] = 'Save';
$string['save_changes'] = 'Save changes';
$string['search_contents'] = 'Search contents';
$string['search_discussions'] = 'Search discussions';
$string['search_library'] = 'Search library';
$string['search_members'] = 'Search members';
$string['search_spaces'] = 'Search workspaces';
$string['set_member_as_owner'] = 'Set as owner';
$string['set_member_as_owner_modal_title'] = 'Set as owner';
$string['set_member_as_owner_modal_body'] = '{$a} will be an owner of this workspace.';
$string['set_member_as_owner_modal_body_confirm'] = 'Are you sure you want to continue?';
$string['set_member_as_owner_success'] = '{$a->user} is now an owner of the {$a->workspace} workspace.';
$string['single_space'] = '1 workspace';
$string['size'] = 'Size';
$string['space'] = 'Workspace';
$string['space_empty_result'] = 'No matching items found.';
$string['space_name_label'] = 'Workspace name';
$string['spaces'] = 'Workspaces';
$string['start_discussion'] = 'Start a discussion';
$string['suspended'] = 'Suspended';
$string['tagarea_course'] = 'Workspaces';
$string['total_discussions'] = '{$a} discussions';
$string['total_files'] = '{$a} files';
$string['total_member_x'] = '{$a} members';
$string['total_search_results'] = '{$a} search results';
$string['total_space_x'] = '{$a} workspaces';
$string['unhidden_workspace_help'] = 'If you unhide this workspace it will remain Private, but people will be able to find it and request to join.';
$string['unhidden_workspace_label'] = 'Workspace type: Private (Hidden)';
$string['unhide_workspace'] = 'Unhide workspace';
$string['unmute_notifications'] = 'Unmute notifications';
$string['unmute_workspace'] = 'Unmute workspace';
$string['updated_to_private'] = 'This workspace has been updated to Private';
$string['uploaded_by'] = 'Uploaded by';
$string['uploaded_date'] = 'Uploaded date';
$string['user_data_item_discussion'] = 'Discussion';
$string['user_data_item_discussion_helper'] = 'All the comments, replies and files related to the discussions will also be removed';
$string['user_data_item_member_request'] = 'Workspace\'s member request';
$string['user_data_item_workspace'] = 'Workspace';
$string['user_data_item_workspace_off_notification'] = 'Workspace\'s notification mute';
$string['view_all_spaces'] = 'View all workspaces';
$string['view_comment'] = 'View comment';
$string['view_discussion'] = 'View discussion';
$string['view_full_discussion'] = 'View full discussion';
$string['view_member_request'] = 'View request';
$string['view_workspace'] = 'View workspace';
$string['vieweditems'] = 'You\'ve viewed {$a} of';
$string['visibility_help'] = "This is a private workspace. To view and participate in this workspace, you need to request to join.";
$string['warning_change_title'] = "Share with workspace";
$string['warning_change_to_public'] = 'Are you sure you want to share this content?

Sharing private content with a public workspace makes it visible to everyone. This change can’t be undone.';
$string['warning_change_to_restricted'] = 'Are you sure you want to share this content?

Sharing private content with a private workspace makes it visible to all members in that workspace.';
$string['workspace_access'] = 'Type';
$string['workspace_cards_grid'] = 'Workspace cards grid';
$string['workspace_created'] = 'Workspace created';
$string['workspace_created_user'] = 'The workspace was successfully created.';
$string['workspace_deleted'] = 'Workspace deleted';
$string['workspace_image_alt'] = 'Workspace image';
$string['workspace_navigation'] = 'Workspace navigation';
$string['workspace_type'] = 'Workspace type';
$string['workspace_type_help'] = '
Anyone can join and participate in Public workspaces.

Private workspaces require approval from the owner to join and content is only visible to members. They can also be hidden from search. To become a member of a hidden workspace, the owner must directly add them.
';
$string['workspace_updated'] = 'Workspace updated';
$string['workspace_updated_notification'] = '{$a} workspace had been updated recently';
$string['workspace_viewed'] = 'Workspace viewed';
$string['workspace_visibility'] = 'Visibility';
$string['you_are_member'] = 'You are a member of this workspace';
$string['you_are_not_member'] = 'You are not a member of this workspace';
$string['you_are_owner'] = 'You are the owner of this workspace';
$string['your_spaces'] = 'Your workspaces';

/**
 * String for capabilities
 */
$string['workspace:addmember'] = 'Add member to workspace';
$string['workspace:administrate'] = 'Administrate all workspaces';
$string['workspace:create'] = 'Create workspace';
$string['workspace:createhidden'] = 'Create hidden workspace';
$string['workspace:createprivate'] = 'Create private workspace';
$string['workspace:delete'] = 'Remove workspace';
$string['workspace:discussioncreate'] = 'Create workspace discussions';
$string['workspace:discussionmanage'] = 'Moderate workspace discussions';
$string['workspace:invite'] = 'Invite user to workspace';
$string['workspace:joinprivate'] = 'Request to join private workspace';
$string['workspace:joinpublic'] = 'Join a public workspace';
$string['workspace:libraryadd'] = 'Link a resource/survey with workspace';
$string['workspace:libraryremove'] = 'Unlink a resource/survey from workspace';
$string['workspace:manage'] = 'Manage a workspace';
$string['workspace:removemember'] = 'Remove member from workspace';
$string['workspace:update'] = 'Update workspace';
$string['workspace:workspacesview'] = 'View workspaces';

/**
 * Strings for errors
 */
$string['error:accept_member_request'] = 'Cannot approve the member request for user {$a}';
$string['error:cohort_enrol_permission'] = 'User does not have permission to enrol cohort members into workspace';
$string['error:copy_to_clipboard'] = 'Cannot copy to the clipboard';
$string['error:create'] = 'The workspace could not be created because something went wrong. Please try again later.';
$string['error:create_discussion'] = 'Cannot create a discussion for workspace';
$string['error:decline_member_request'] = 'Cannot decline the member request for user {$a}';
$string['error:delete_discussion'] = 'Cannot delete the discussion';
$string['error:delete_workspace'] = 'Cannot delete the workspace';
$string['error:discussion_not_found'] = 'The discussion cannot be found. It appears to be deleted.';
$string['error:manual_enrol'] = 'Cannot manual add user to workspace';
$string['error:remove_as_owner'] = 'Cannot remove as owner';
$string['error:remove_user'] = 'Cannot remove the user';
$string['error:report_discussion'] = 'Cannot report the discussion';
$string['error:self_enrol'] = 'Cannot self enrol to workspace';
$string['error:set_as_owner'] = 'Cannot set as owner';
$string['error:share_to_workspace'] = 'You don\'t have permission to share to this workspace';
$string['error:update'] = 'Cannot update the workspace';
$string['error:update_discussion'] = 'Cannot update the discussion';
$string['error:upload_image'] = 'Sorry, the file failed to upload. Please try again';
$string['error:view_workspace'] = 'You don\'t have permission to view this page.';
$string['error:view_workspace_audiences'] = 'Permission denied: Cannot view audiences';
$string['error:workspace_not_found'] = 'The workspace cannot be found. It appears to be deleted.';

/**
 * Strings for Library
 */
$string['workspace:add_library'] = 'Select content to share with workspaces';

/**
 * String for message provider
 */
$string['messageprovider:accept_member_request'] = "Member request accepted";
$string['messageprovider:added_to_workspace'] = 'User has been added to a workspace';
$string['messageprovider:bulk_members_via_audience_added'] = "Members added in bulk via audience(s)";
$string['messageprovider:comment_on_discussion'] = "Comments on discussion posts";
$string['messageprovider:create_new_discussion'] = 'New discussion in a workspace';
$string['messageprovider:decline_request_join'] = "Declined request to join a workspace";
$string['messageprovider:join_request'] = "Request to join Private workspace";
$string['messageprovider:notification'] = "New items added to workspace library";
$string['messageprovider:transfer_ownership'] = 'Workspace ownership has been transferred';

/**
 * Totara Notifications 16.0+
 */
$string['added_for_subject_body'] = 'You are now a member of the [workspace:full_name_link] workspace.';
$string['added_for_subject_subject'] = 'You have been added to a workspace';
$string['added_for_subject_title'] = 'User added to workspace';
$string['notification_log_user_added'] = '{$a->resolver_title}: User "{$a->user}", workspace "{$a->workspace}"';
$string['notification_log_role_changed'] = '{$a->resolver_title}: User "{$a->user}", workspace "{$a->workspace}"';
$string['notification_role_changed_for_subject_body'] = "You have been assigned the role of [role:full_name] in the [workspace:full_name_link] workspace.";
$string['notification_role_changed_for_subject_subject'] = 'New role assigned in [workspace:full_name]';
$string['notification_role_changed_for_subject_title'] = 'User role changed';
$string['notification_role_changed_resolver_title'] = 'User role changed';
$string['notification_user_added_resolver_title'] = 'User added to a workspace';
$string['notification_workspace_enrolment_placeholder_group'] = 'Membership {$a}';
$string['notification_workspace_owner_recipient'] = 'Workspace Owner';
$string['notification_workspace_placeholder_group'] = 'Workspace {$a}';
$string['notification_workspace_role_placeholder_group'] = 'Workspace role {$a}';
$string['placeholder_workspace_role_full_name'] = 'Full name';
$string['placeholder_workspace_fullname'] = 'Full name';
$string['placeholder_workspace_fullname_linked'] = 'Full name (with link)';
$string['placeholder_workspace_join_date'] = 'Join Date';
$string['placeholder_workspace_number_synced'] = 'Number Added';

/**
 * Deprecated since Totara 13.2.
 */
$string['copy_discussion_link'] = 'Copy link';

/**
 * Deprecated since Totara 15.
 */
$string['hashtag_tip'] = 'Tip: Add a hashtag to make this more findable';
$string['hashtag_tip_help'] = 'Hashtags make it easier to find information on specific themes. For example, a workspace for Health and Safety Officers might include hashtags like #healthandsafety #staysafe #hazards';

/**
 * Deprecated since Totara 16.
 */
$string['bulk_add_audiences'] = 'Bulk add audience(s)';
$string['bulk_add_audiences_modal_confirm_button'] = 'Add members';
$string['bulk_add_audiences_modal_confirmation_message'] = 'The \'bulk add members\' process has successfully started. You\'ll receive a notification when the action has completed.';
$string['bulk_add_audiences_modal_content_1'] = 'Please note:';
$string['bulk_add_audiences_modal_content_2'] = 'workspace members can only be removed individually.';
$string['bulk_add_audiences_modal_content_3'] = 'future changes to the audience(s) will have no effect on workspace membership.';
$string['bulk_add_audiences_modal_content_no_members'] = 'This is either because the audience contains no new people to add or they are not eligible to become members of this workspace.';
$string['bulk_add_audiences_modal_reselect_button'] = 'Reselect audiences';
$string['bulk_add_audiences_modal_title'] = 'Bulk add {$a} new members to workspace?';
$string['bulk_add_audiences_modal_title_no_members'] = 'Your selection will not add any new members to the workspace.';
$string['bulk_add_audiences_notification_message'] = '{$a->number} people from the following audiences were added to <a href="{$a->link}">{$a->name}</a>:';
$string['bulk_add_audiences_notification_subject'] = 'Audience members have been successfully added to workspace.';
$string['delete_discussion_warning_msg'] = "Your discussion post will be deleted. Any comments, replies, and likes will also be deleted.";
$string['delete_warning_msg'] = 'This will result in <strong>permanent deletion of workspace, discussions and files</strong>. Resources and playlists shared to the workspace\'s library will continue to exist in other areas of this site.';
$string['error:add_members'] = "Cannot add members to the workspace";
$string['error:bulk_add_audiences'] = 'Cannot add members via given audience(s).';
$string['error:cancel_member_request'] = 'Cannot cancel the member request';
$string['error:join_space'] = 'Cannot join a workspace';
$string['error:leave_space'] = 'Cannot leave the workspace';
$string['error:request_to_join'] = 'Cannot request to join the workspace';
$string['filter_users'] = 'Filter users';
$string['member_added_message'] = 'You are now a member of the {$a} workspace';
$string['member_added_title'] = 'You have been added to a workspace';
$string['people_selected'] = 'People selected: {$a}';

/**
 * Deprecated since Totara 19.0.
 */
$string['select_existing_resource'] = "select an existing resource";
$string['select_new_owner'] = "New owner";
$string['select_new_owner_placeholder'] = "Type name to add, or click to browse...";
$string['to_share_with_workspace'] = 'to share with this workspace';
$string['transfer_ownership'] = 'Transfer ownership';
$string['transfer_ownership_help_text_one'] = 'After you transfer ownership to another person you will become a member only.';
$string['transfer_ownership_help_text_two'] = 'After you transfer ownership, the current owner will become a member only.';
$string['transfer_ownership_title'] = 'Transfer of workspace';
// NOTE: DO NOT update the deprecated.txt file with the strings below as behat tests will fail because of the Vue files.
$string['transfer_ownership_message'] = '{$a->author} has transferred ownership of the {$a->workspace} workspace to you.';
$string['transfer_ownership_of_workspace'] = 'Transfer ownership';
$string['transfer_ownership_success_alert'] = '{$a->user} is now the owner of the {$a->workspace} workspace';
