<?php
/*
 * This file is part of Totara Core
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Nathan Lewis <nathan.lewis@totara.com>
 * @package format_pathway
 */

namespace format_pathway;

use core\orm\query\builder;

/**
 * Provides functions to help determine if an activity is blacklisted.
 */
class blacklist_helper {

    /**
     * @return string[]
     */
    public static function get_blacklist(): array {
        static $modules = [];
        if (defined('PHPUNIT_TEST') && PHPUNIT_TEST) {
            $modules = [];
        }
        if (empty($modules)) {
            $modules = builder::table('modules')
                ->where_in('name', ['wiki', 'book', 'folder', 'data', 'label', 'lesson'])
                ->where('visible', 1)
                ->select(['name'])
                ->order_by('name', 'ASC')
                ->get()
                ->pluck('name');
        }
        return $modules;
    }

    /**
     * @param string $module
     * @return bool
     */
    public static function is_blacklisted(string $module): bool {
        return in_array($module, self::get_blacklist());
    }
}
