<?php
      // This function fetches math. images from the data directory
      // If not, it obtains the corresponding TeX expression from the cache_tex db table
      // and uses mimeTeX to create the image file

// disable moodle specific debug messages and any errors in output
define('NO_DEBUG_DISPLAY', true);
define('NO_MOODLE_COOKIES', true); // Because it interferes with caching

    require_once('../../config.php');

    if (!filter_is_enabled('tex')) {
        print_error('filternotenabled');
    }

    require_once($CFG->libdir.'/filelib.php');
    require_once($CFG->dirroot.'/filter/tex/lib.php');
    require_once($CFG->dirroot.'/filter/tex/latex.php');

    $cmd    = '';               // Initialise these variables
    $status = '';

    $relativepath = get_file_argument();

    $args = explode('/', trim($relativepath, '/'));

    if (count($args) == 1) {
        $image    = $args[0];
        $pathname = $CFG->dataroot.'/filter/tex/'.$image;
    } else {
        print_error('invalidarguments', 'error');
    }

    if (!file_exists($pathname)) {
        $convertformat = get_config('filter_tex', 'convertformat');
        if (strpos($image, '.png')) {
            $convertformat = 'png';
        }
        $md5 = str_replace(".{$convertformat}", '', $image);
        if ($texcache = $DB->get_record('cache_filters', array('filter'=>'tex', 'md5key'=>$md5))) {
            if (!file_exists($CFG->dataroot.'/filter/tex')) {
                make_upload_directory('filter/tex');
            }

            // try and render with latex first
            $latex = new latex();
            $density = get_config('filter_tex', 'density');
            $background = get_config('filter_tex', 'latexbackground');
            $texexp = $texcache->rawtext; // the entities are now decoded before inserting to DB
            $lateximage = $latex->render($texexp, $image, 12, $density, $background);
            if ($lateximage) {
                copy($lateximage, $pathname);
                $latex->clean_up($md5);

            } else {
                // failing that, use mimetex
                // Mimetex only outputs gifs, not pngs or svgs. So update the file extension if necessary.
                $image = str_replace('.' . $convertformat, '.gif', $image);
                $pathname = $CFG->dataroot.'/filter/tex/'.$image;

                $texexp = $texcache->rawtext;
                $texexp = str_replace('&lt;', '<', $texexp);
                $texexp = str_replace('&gt;', '>', $texexp);
                $texexp = preg_replace('!\r\n?!', ' ', $texexp);
                $texexp = '\Large '.$texexp;

                $commandpath = filter_tex_get_executable();
                $texcommand = new \core\command\executable($commandpath);
                if (core\command\executable::is_windows()) {
                    $texcommand->add_switch('++');
                }
                $texcommand->add_switch('-e');
                $texcommand->add_value($pathname, PARAM_PATH);

                $texexp = filter_tex_sanitize_formula($texexp);
                $texcommand->add_argument('--', $texexp, PARAM_TEXT, ' ');

                if (isset($stderr) && $stderr) {
                    $texcommand->redirect_stderr_to_stdout();
                }

                $texcommand->execute();
            }
        }
    }

    if (file_exists($pathname)) {
        send_file($pathname, $image);
    } else {
        if (debugging()) {
            echo "The shell command<br />$cmd<br />returned status = $status<br />\n";
            echo "Image not found!<br />";
            echo "Please try the <a href=\"$CFG->wwwroot/filter/tex/texdebug.php\">debugging script</a>";
        } else {
            echo "Image not found!<br />";
            echo "Please try the <a href=\"$CFG->wwwroot/filter/tex/texdebug.php\">debugging script</a><br />";
            echo "Please turn on debug mode in site configuration to see more info here.";
        }
    }
