<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class for preparing data for Roles Assignment.
 *
 * @package    bi_intellidata
 * @author     IntelliBoard
 * @copyright  2020 intelliboard.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace bi_intellidata\entities\roles;


/**
 * Class for preparing data for Role Assignment.
 *
 * @package    bi_intellidata
 * @author     IntelliBoard
 * @copyright  2020 intelliboard.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class roleassignment extends \bi_intellidata\entities\entity {

    /**
     * Entity type.
     */
    const TYPE = 'roleassignments';

    /**
     * Return the definition of the properties of this model.
     *
     * @return array
     */
    protected static function define_properties() {
        return array(
            'id' => array(
                'type' => PARAM_INT,
                'description' => 'Role assignment ID.',
                'default' => 0,
            ),
            'roleid' => array(
                'type' => PARAM_INT,
                'description' => 'Role ID.',
                'default' => 0,
            ),
            'userid' => array(
                'type' => PARAM_INT,
                'description' => 'User ID.',
                'default' => 0,
            ),
            'courseid' => array(
                'type' => PARAM_INT,
                'description' => 'Course ID.',
                'default' => 0,
            ),
            'contexttype' => array(
                'type' => PARAM_INT,
                'description' => 'Assignment context type.',
                'default' => 0,
            ),
            'component' => array(
                'type' => PARAM_TEXT,
                'description' => 'Assignment component.',
                'default' => '',
            ),
            'itemid' => array(
                'type' => PARAM_INT,
                'description' => 'Assignment item ID.',
                'default' => 0,
            ),
        );
    }

}