<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings used by My Moodle pages.
 *
 * @note Automatically cleaned: 2024-09-24
 * @package   core
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['a11y_overview_achievement_level_label'] = 'Achievement level: {$a}';
$string['a11y_overview_assignment_type_label'] = 'Assignment: {$a}';
$string['a11y_overview_description_hide'] = 'Hide description';
$string['a11y_overview_description_show'] = 'Show description';
$string['a11y_overview_doughnut_label'] = '{$a->achieved} achieved, {$a->progressed} progressed, {$a->notProgressed} not progressed, {$a->notStarted} not started';
$string['a11y_overview_doughnut_label_completed'] = '{$a->achieved} completed, {$a->progressed} progressed, {$a->notProgressed} not progressed, {$a->notStarted} not started';
$string['a11y_overview_due_date_status_button'] = 'Due date status';
$string['a11y_overview_overdue_action_link_view'] = 'View {$a}';
$string['a11y_overview_select_activity_participants'] = 'Select participants';
$string['a11y_overview_view_activities'] = 'View activities';
$string['addpage'] = 'Add page';
$string['alldashboardswerereset'] = 'All My Learning pages have been reset to default.';
$string['allprofileswerereset'] = 'All profile pages have been reset to default.';
$string['defaultpage'] = 'Default My Learning page';
$string['defaultprofilepage'] = 'Default profile page';
$string['delpage'] = 'Delete page';
$string['managepages'] = 'Manage pages';
$string['menu_title_my_overview'] = 'Performance overview';
$string['mymoodle'] = 'My Learning';
$string['no_permission'] = 'You do not have permission to view this page.';
$string['nocourses'] = 'No course information to show.';
$string['noguest'] = 'The \'My Learning\' page is not available to guest users';
$string['overview_achieved_date'] = 'Achieved {$a}';
$string['overview_activities_about_others_requires_response'] = 'There is 1 activity about others that requires you to respond.';
$string['overview_activities_about_others_requires_response_one_overdue_plural'] = 'There are {$a->count} activities about others that require you to respond. 1 of them is overdue.';
$string['overview_activities_about_others_requires_response_overdue'] = 'There is 1 activity about others that requires you to respond. It is overdue.';
$string['overview_activities_about_others_requires_response_overdue_plural'] = 'There are {$a->count} activities about others that require you to respond. {$a->overdue} of them are overdue.';
$string['overview_activities_about_others_requires_response_plural'] = 'There are {$a->count} activities about others that require you to respond.';
$string['overview_activities_about_others_requires_user_response'] = 'There is 1 activity about others that requires {$a->name} to respond.';
$string['overview_activities_about_others_requires_user_response_one_overdue_plural'] = 'There are {$a->count} activities about others that require {$a->name} to respond. 1 of them is overdue.';
$string['overview_activities_about_others_requires_user_response_overdue'] = 'There is 1 activity about others that requires {$a->name} to respond. It is overdue.';
$string['overview_activities_about_others_requires_user_response_overdue_plural'] = 'There are {$a->count} activities about others that require {$a->name} to respond. {$a->overdue} of them are overdue.';
$string['overview_activities_about_others_requires_user_response_plural'] = 'There are {$a->count} activities that require {$a->name} to respond.';
$string['overview_activities_actions_about_others'] = 'Activities about others';
$string['overview_activities_awaiting_participant_selection'] = 'Activities awaiting participant selection';
$string['overview_activities_count_label'] = 'Activities';
$string['overview_activities_pending_their_participant_selection'] = 'There are {$a->count} activities that require {$a->name} to select participants.';
$string['overview_activities_pending_your_participant_selection'] = 'There are {$a->count} activities that require you to select participants.';
$string['overview_activities_section_title'] = 'Performance activities';
$string['overview_activity_completion_date'] = 'Completed {$a}';
$string['overview_activity_pending_their_participant_selection'] = 'There is 1 activity that requires {$a->name} to select participants.';
$string['overview_activity_pending_your_participant_selection'] = 'There is 1 activity that requires you to select participants.';
$string['overview_add_goal'] = 'Create personal goal';
$string['overview_assigned_date'] = 'Assigned {$a}';
$string['overview_button_select'] = 'Select';
$string['overview_competencies_count_label'] = 'Competencies';
$string['overview_competencies_pending_changes'] = 'The competencies on this page are currently being updated, and changes may take some time to appear.';
$string['overview_competencies_section_title'] = 'Competencies';
$string['overview_competency_scale_updated_to'] = 'Competency achievement level was updated to \'{$a}\'.';
$string['overview_completed_date'] = 'Completed {$a}';
$string['overview_description'] = 'Description';
$string['overview_due_date'] = 'Due {$a}';
$string['overview_due_soon'] = 'Due soon';
$string['overview_goals_count_label'] = 'Goals';
$string['overview_goals_scale_updated_to'] = 'Goal was updated to \'{$a}\'.';
$string['overview_goals_section_title'] = 'Goals';
$string['overview_no_activities'] = 'No activities are currently assigned for this period.';
$string['overview_no_competencies'] = 'No competencies are currently assigned for this period.';
$string['overview_no_goals'] = 'No goals are currently assigned for this period.';
$string['overview_overdue'] = 'Overdue';
$string['overview_overdue_action_link_view'] = 'View';
$string['overview_page_title'] = 'Performance overview';
$string['overview_period_14_days'] = '14 days';
$string['overview_period_1_year'] = '1 year';
$string['overview_period_30_days'] = '30 days';
$string['overview_period_6_months'] = '6 months';
$string['overview_period_90_days'] = '90 days';
$string['overview_period_label'] = 'Period';
$string['overview_require_action_section_title'] = 'Require action';
$string['overview_section_expanded_details'] = 'Expanded details';
$string['overview_section_hide_details'] = 'Hide details';
$string['overview_section_show_details'] = 'Show details';
$string['overview_self_assign_competencies'] = 'Self-assign competencies';
$string['overview_status_heading_achieved'] = 'Achieved';
$string['overview_status_heading_achieved_proficiency'] = 'Achieved proficiency';
$string['overview_status_heading_completed'] = 'Completed';
$string['overview_status_heading_not_progressed'] = 'Not progressed';
$string['overview_status_heading_not_started'] = 'Not started';
$string['overview_status_heading_progressed'] = 'Progressed';
$string['overview_status_table_count'] = '{$a->left}{$a->total}{$a->right}';
$string['overview_status_table_count_left'] = '(';
$string['overview_status_table_count_right'] = ')';
$string['overview_updated_date'] = 'Updated {$a}';
$string['overview_view_all'] = 'View all';
$string['overview_view_all_activities_completed_heading'] = '{$a} activities completed';
$string['overview_view_all_activities_not_progressed_heading'] = '{$a} activities not progressed';
$string['overview_view_all_activities_not_started_heading'] = '{$a} activities not started';
$string['overview_view_all_activities_progressed_heading'] = '{$a} activities progressed';
$string['overview_view_all_close'] = 'Close';
$string['overview_view_all_competencies_achieved_heading'] = '{$a} competencies achieved proficiency';
$string['overview_view_all_competencies_not_progressed_heading'] = '{$a} competencies not progressed';
$string['overview_view_all_competencies_not_started_heading'] = '{$a} competencies not started';
$string['overview_view_all_competencies_progressed_heading'] = '{$a} competencies progressed';
$string['overview_view_all_goals_achieved_heading'] = '{$a} goals achieved';
$string['overview_view_all_goals_not_progressed_heading'] = '{$a} goals not progressed';
$string['overview_view_all_goals_not_started_heading'] = '{$a} goals not started';
$string['overview_view_all_goals_progressed_heading'] = '{$a} goals progressed';
$string['overview_view_all_load_more'] = 'Load more';
$string['pinblocks'] = 'Configure pinned blocks for My Learning';
$string['pinblocksexplan'] = 'Any block settings you configure here will be visible (and non-editable) for any user of Totara on their \'My Learning\' overview page.';
$string['reseterror'] = 'There was an error resetting your page';
$string['reseteveryonesdashboard'] = 'Reset My Learning for all users';
$string['reseteveryonesprofile'] = 'Reset profile for all users';
$string['resetpage'] = 'Reset page to default';
$string['userdataitemprofile_customisations'] = 'Customisations to Profile page';
$string['x_achieved'] = '{$a} achieved';
$string['x_completed'] = '{$a} completed';
$string['x_not_progressed'] = '{$a} not progressed';
$string['x_not_started'] = '{$a} not started';
$string['x_progressed'] = '{$a} progressed';
