<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Fabian Derschatta <fabian.derschatta@totaralearning.com>
 * @package core
 */

namespace core\performance_statistics;

use core\session\manager;
use stdClass;

class session extends provider {

    /**
     * @inheritDoc
     */
    public function get_data() {
        // Display size of session if session started.
        if ($session_info = manager::get_performance_info()) {
            $data = new stdClass();
            $data->size = $session_info['size'];
            $data->handler = $session_info['handler'];
            $data->html = $session_info['html'];
            $data->txt = $session_info['txt'];
        }

        return $data ?? null;
    }

}