<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package core
 */
defined('MOODLE_INTERNAL') || die();

use core\json_editor\node\hard_break;

class core_json_editor_hard_break_test extends \core_phpunit\testcase {
    /**
     * @return void
     */
    public function test_validate_schema(): void {
        $this->assertTrue(
            hard_break::validate_schema([
                'type' => hard_break::get_type()
            ])
        );

        $this->assertTrue(
            hard_break::validate_schema([
                'type' => hard_break::get_type(),
                'marks' => [['type' => 'strong']],
            ])
        );
    }

    /**
     * @return void
     */
    public function test_validate_schema_with_extra_keys(): void {
        $this->assertFalse(
            hard_break::validate_schema([
                'type' => hard_break::get_type(),
                'woops' => []
            ])
        );

        $this->assertDebuggingCalled();
    }
}