<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package mod_facetoface
 */

require_once($CFG->dirroot . '/mod/facetoface/backup/moodle2/backup_facetoface_stepslib.php'); // Because it exists (must)

/**
 * facetoface backup task that provides all the settings and steps to perform one
 * complete backup of the activity
 */
class backup_facetoface_activity_task extends backup_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // No particular settings for this activity
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        // facetoface only has one structure step
        $this->add_step(new backup_facetoface_activity_structure_step('facetoface_structure', 'facetoface.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     */
    static public function encode_content_links($content, backup_task $task = null) {

        if (!self::has_scripts_in_content($content, 'mod/facetoface', ['index.php', 'view.php'])) {
            // No scripts present in the content, simply continue.
            return $content;
        }

        if (empty($task)) {
            // No task has been provided, lets just encode everything, must be some old school backup code.
            $content = self::encode_content_link_basic_id($content, "/mod/facetoface/index.php?id=", 'FACETOFACEINDEX');
            $content = self::encode_content_link_basic_id($content, "/mod/facetoface/view.php?id=", 'FACETOFACEVIEWBYID');
        } else {
            // OK we have a valid task, we can translate just those links belonging to content that is being backed up.
            $content = self::encode_content_link_basic_id($content, "/mod/facetoface/index.php?id=", 'FACETOFACEINDEX', $task->get_courseid());
            foreach ($task->get_tasks_of_type_in_plan('backup_facetoface_activity_task') as $task) {
                /** @var backup_facetoface_activity_task $task */
                $content = self::encode_content_link_basic_id($content, "/mod/facetoface/view.php?id=", 'FACETOFACEVIEWBYID', $task->get_moduleid());
            }
        }

        return $content;
    }
}
