<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @package mod_facetoface
 */

$string['actions'] = 'Actions';
$string['activate'] = 'Activate';
$string['active'] = 'Active';
$string['activitycompletiontask'] = 'Trigger delayed seminar activity completions';
$string['activitydefaults'] = 'Activity defaults';
$string['addasset'] = 'Add an asset';
$string['addattendees'] = 'Add users';
$string['addattendeestep1'] = "Select users to add (step 1 of 2)";
$string['addattendeestep2'] = "Add users (step 2 of 2)";
$string['addattendeesviafileupload'] = 'Add users via file upload';
$string['addattendeesviaidlist'] = 'Add users via list of IDs';
$string['addeditattendeeserror'] = 'Add/edit attendees error';
$string['addeditattendeesresults'] = 'Add/edit attendees results';
$string['addeditattendeessuccess'] = 'Add/edit attendees success';
$string['addedsuccessfully'] = 'Added successfully';
$string['addfacilitator'] = 'Add a facilitator';
$string['addingseminarsession'] = 'Adding a new Seminar to {$a}';
$string['addingsession'] = 'Adding a new event in {$a}';
$string['additionalfeaturesheading'] = 'Additional features';
$string['addmessage'] = 'Add ad-hoc message';
$string['addnewasset'] = 'Add a new asset';
$string['addnewfacilitator'] = 'Add a new facilitator';
$string['addnewfield'] = 'Add a new custom field';
$string['addnewfieldlink'] = 'Create a new custom field';
$string['addnewroom'] = 'Add a new room';
$string['addnotification'] = 'Add notification';
$string['addnotificationtemplate'] = 'Add notification template';
$string['addremoveattendees'] = 'Add/remove attendees';
$string['addremoveattendeeswaitlisted'] = 'Please Note: Attendees added will be automatically added to the waiting list';
$string['address'] = 'Address';
$string['addroom'] = 'Add a room';
$string['addsession'] = 'Add event';
$string['addstudent'] = 'Add learner';
$string['addtositewidelist'] = 'Add to sitewide list';
$string['adhocdisabled'] = 'Ad-hoc messages are disabled.';
$string['afterendofsession'] = 'after event (closing session end time)';
$string['allfacilitators'] = 'All';
$string['allfilteredsessionsin'] = 'Events in {$a}';
$string['alljamanagersdesc'] = 'Managers from all job assignments will be chosen if left empty.';
$string['alllocations'] = 'All locations';
$string['allocate'] = 'Allocate spaces for team';
$string['allocatenoteam'] = 'There are no team members you can allocate to this event';
$string['allocationfull_noreserve'] = 'Without replacing your current reservations, you can only allocate {$a} space(s) for this event';
$string['allocationfull_reserve'] = 'You can only allocate {$a} space(s) for this event';
$string['allowassetconflicts'] = 'Allow booking conflicts';
$string['allowassetconflicts_help'] = 'Checking this box will allow an asset to be assigned to two or more sessions that are running at the same time.';
$string['allowbookingscancellations'] = 'Allow cancellations';
$string['allowbookingscancellations_help'] = 'Allow users to cancel their bookings; at any time, never, or until cut-off reached (x amount of time before the event starts).';
$string['allowbookingscancellationsdefault'] = 'Default &lsquo;allow cancellations&rsquo; setting for all events';
$string['allowbookingscancellationsdefault_help'] = 'Set the default cancellation settings for this seminar and allow users to cancel their bookings at any time, never or until cut-off reached (x amount of time before the event starts).';
$string['allowcancellationanytime'] = 'At any time';
$string['allowcancellationcutoff'] = 'Until specified period';
$string['allowcancellationnever'] = 'Never';
$string['allowcancellations'] = 'Allow cancellations';
$string['allowcancellations_help'] = 'Whether event attendees will be able to cancel their bookings.';
$string['allowcancellationsdefault'] = 'Allow cancellations default';
$string['allowcancellationsdefault_help'] = 'Whether events in this activity will allow cancellations by default, can be overridden in the event settings.';
$string['allowfacilitatorconflicts'] = 'Allow booking conflicts';
$string['allowfacilitatorconflicts_help'] = 'Checking this box will allow a facilitator to be assigned to two or more sessions that are running at the same time.';
$string['allowoverbook'] = 'Enable waitlist';
$string['allowroomconflicts'] = 'Allow booking conflicts';
$string['allowroomconflicts_help'] = 'This will allow room scheduling conflicts to exist.';
$string['allowroomconflictswarning'] = 'Note: Room scheduling conflicts are not automatically prevented. Please ensure that this room is available before creating this booking.';
$string['allowscheduleconflicts'] = 'Allow scheduling conflicts';
$string['allowschedulingconflicts'] = 'Override user conflicts';
$string['allowschedulingconflicts_help'] = 'If trainers or users are already assigned or booked onto another seminar event at the same time as this event then the administrator will be warned, but can override such warnings and proceed anyway by selecting **Yes** from the dropdown menu.';
$string['allowselectedschedulingconflicts'] = 'Allow selected scheduling conflicts';
$string['allrooms'] = 'All';
$string['allsessionsin'] = 'All events in {$a}';
$string['alreadysignedup'] = 'You have already signed-up for this seminar activity.';
$string['answer'] = 'Sign in';
$string['answercancel'] = 'Sign out';
$string['anytime'] = 'Any time';
$string['appearanceheader'] = 'Appearance';
$string['applyfilter'] = 'Apply filter';
$string['approval_activityapprover'] = '{$a} (activity level approver)';
$string['approval_addapprover'] = 'Add approver';
$string['approval_admin'] = 'Manager and Administrative approval';
$string['approval_manager'] = 'Manager Approval';
$string['approval_managerselect'] = 'Users Select Manager';
$string['approval_none'] = 'No Approval';
$string['approval_role'] = 'Role Approval';
$string['approval_self'] = 'Learner accepts terms and conditions';
$string['approval_siteapprover'] = '{$a} (site level approver)';
$string['approvalnocapacity'] = 'There are {$a->waiting} learners awaiting approval but no spaces available, you cannot approve any more learners at this time.';
$string['approvalnocapacitywaitlist'] = 'There are {$a->waiting} learners awaiting approval but no spaces available - any approvals will be added to the waitlist instead.';
$string['approvaloptions'] = 'Require approval by';
$string['approvaloptions_help'] = 'Available options are defined by the approval options setting on the seminar administration settings page:

* **No approval**: A user will be immediately booked into an event when signing up.
* **Learner accepts terms and conditions**: A user will be presented the text defined in the text area below, and required to accept the terms and conditions.
* **Event role**: All user\'s assigned to the role in the event will be immediately sent a notification with instructions to approve the user\'s request to sign-up for the event.
* **Manager approval**: The learner\'s manager will be immediately sent a notification with instructions to approve the user\'s request to sign-up for the event.
* **Manager and Administrative approval**: All users selected as an approver will be immediately sent a notification with instructions to approve the user\'s request to sign-up for the event. Approval can then be given by the Manager followed by the Administrator, or the Administrator may finalise the request without Manager approval.';
$string['approvalovercapacity'] = 'There are {$a->waiting} learners awaiting approval but only {$a->available} spaces available. Only the first {$a->available} learners you approve will be added to the event.';
$string['approvalovercapacitywaitlist'] = 'There are {$a->waiting} learners awaiting approval but only {$a->available} spaces available.<br /> Only the first {$a->available} learners you approve will be added to the event - additional approvals will be added to the waitlist.';
$string['approvalreqd'] = 'Approval required';
$string['approvalrequiredby'] = 'Approval required by: ';
$string['approvalterms'] = 'Terms and conditions';
$string['approvaltime'] = 'Time approved';
$string['approvalusers'] = 'Approval Administrators';
$string['approvalusers_help'] = 'The approval administrators will receive a notification about your request to book into this session. If there are none displayed, please contact the Site administrator.';
$string['approve'] = 'Approve';
$string['approved'] = 'Approved';
$string['approverdatetime'] = 'Approval Date/Time';
$string['approveremail'] = 'Approver Email';
$string['approvername'] = 'Approver name';
$string['approverrolename'] = 'Approver role';
$string['approvertime'] = 'Approval Time';
$string['approveuserevent'] = 'Approve {$a} for this event';
$string['archive_nousers'] = 'No users have been archived.';
$string['archive_restore'] = 'Restore selected users';
$string['archive_success'] = 'Successfully restored {$a} user(s).';
$string['archive_warning'] = 'Notifications will NOT be sent to restored archived users and their managers.';
$string['archivewarning_removeattendees'] = 'The disabled attendees can not be removed because they hold archived course completion records';
$string['archivewarning_takeattendance'] = 'The disabled attendees can not be updated because they hold archived course completion records';
$string['areyousureconfirmwaitlist'] = 'This will be over the event maximum bookings allowance. Are you sure you want to continue?';
$string['assessmentyour'] = 'Your assessment';
$string['asset'] = 'Asset';
$string['assetalreadybooked'] = ' (asset unavailable on selected dates)';
$string['assetcreatesuccess'] = 'Successfully created asset';
$string['assetcustomfieldtab'] = ' Asset';
$string['assetdeleted'] = 'Asset deleted';
$string['assetdescription'] = 'Description';
$string['assetdetails'] = 'Asset details';
$string['assetdoesnotexist'] = 'Asset does not exist';
$string['assethidden'] = 'Asset hidden successfully';
$string['assethide'] = 'Hide from users when choosing an asset on the Add/Edit event page';
$string['assetname'] = 'Name';
$string['assetnameedittoolong'] = 'Asset name can only be upto {$a} characters in length';
$string['assets'] = 'Assets';
$string['assetshow'] = 'Show to users when choosing an asset on the Add/Edit event page';
$string['assetshown'] = 'Asset shown successfully';
$string['assetupdatesuccess'] = 'Successfully updated asset';
$string['attendance'] = 'Attendance';
$string['attendancename'] = 'Name';
$string['attendancerequestsupdated'] = 'Attendance requests updated';
$string['attendancestatus'] = 'Attendance status';
$string['attendancetaken'] = 'Attendance taken';
$string['attendancetaken_info'] = 'Your attendance has already been recorded for this session. No further action is needed.';
$string['attendancetimeofsignup'] = 'Time of sign-up';
$string['attendancetracking:noattendees'] = 'No attendees';
$string['attendancetracking:open'] = 'Take attendance';
$string['attendancetracking:openatend'] = 'Will open at session end time';
$string['attendancetracking:openatstart'] = 'Will open at session start time';
$string['attendancetracking:saved'] = 'Attendance saved';
$string['attendancetrackingheader'] = 'Attendance tracking and grading';
$string['attendedsession'] = 'Attended event';
$string['attendeeactions'] = 'Attendee actions';
$string['attendeenote'] = 'Attendee\'s note';
$string['attendees'] = 'Attendees';
$string['attendees_notification_not_sent'] = 'Notifications will not be sent when users are added after the first session in the event has started.';
$string['attendeestablesummary'] = 'People planning on or having attended this event.';
$string['available'] = 'Available';
$string['backtoassets'] = 'Back to assets';
$string['backtofacilitators'] = 'Back to facilitators';
$string['backtorooms'] = 'Back to rooms';
$string['backtoseminar'] = 'Go to seminar';
$string['beforeregistrationends'] = 'before end of Sign-up period (cut-off point)';
$string['beforestartofsession'] = 'before event (opening session start time)';
$string['body'] = 'Body';
$string['body_help'] = 'This is the body of the notification to be sent.

In the notification there are a number of placeholders that can be used, these placeholders will be replaced with the appropriate values when the message is sent.

All place holders are enclosed within square brackets.
There are several types of place holders, the patterns for each are as follows:

* Event details: [placeholder]
* Event custom fields: [session:placeholder]
* Event cancellation custom fields: [sessioncancel:placeholder]
* Multiple session event details: [#sessions][session:placeholder][/sessions]
* Room/Asset/Facilitator details for each session: [#sessions][session:rooms][/sessions]
* Room/Asset/Facilitator individual fields for each session: [#sessions][session:room:placeholder][/sessions]
* Room/Asset/Facilitator custom fields for each session: [#sessions][session:room:cf_placeholder][/sessions]
* User details: [placeholder]
* User custom fields: [user:placeholder]

You can find out which placeholder are available, and how custom field placeholders work for each type under the relevant heading below.

### 1. Event details

The details of the seminar can be added to the notification by using the desired placeholders from the following list.

* [coursename] - Name of course
* [coursenamelink] - Name of course with link
* [seminarname] - Name of seminar activity
* [seminarnamelink] - Name of seminar activity with link
* [seminardescription] - Seminar description
* [eventpagelink] - Link to the event page
* [cost] - Cost of event
* [reminderperiod] - Amount of time before the event that the reminder message is sent
* [sessiondate] - Date of the event the learner is booked on
* [startdate] - Date at the start of the event. If there are multiple sessions it will use the first one.
* [finishdate] - Date at the end of the event. If there are multiple sessions it will use the first one.
* [starttime] - Start time of the event. If there are multiple sessions it will use the first one.
* [finishtime] - Finish time of the event. If there are multiple sessions it will use the first one.
* [duration] - Length of the event
* [details] - Details about the event
* [attendeeslink] - Link to the attendees page for the event
* [lateststarttime] - Start time of the event. If there are multiple sessions it will use the last one.
* [lateststartdate] - Date at the start of the event. If there are multiple sessions it will use the last one.
* [latestfinishtime] - Finish time of the event. If there are multiple sessions it will use the last one.
* [latestfinishdate] - Date at the end of the event. If there are multiple sessions it will use the last one.
* [registrationcutoff] - The deadline for registrations, if not set this will default to [starttime].
* [booked] - Number of attendees booked for the event
* [capacity] - Total number of seats available in an event
* [mincapacity] - Minimum bookings setting for the event

### 2. Event custom fields

If you have created event custom fields, and wish to use these in your notification body you can do so using the following placeholder, replacing \'placeholder\' with the shortname for the custom field.

    [session:placeholder]

For example if you have an event custom field with the shortname \'department\', to use the value recorded in the custom field in the notification body you would use the placeholder [session:department].

### 3. Event cancellation custom fields

If you have created event cancellation custom fields, and wish to use these in your notification body you can do so using the following placeholder, replacing \'placeholder\' with the shortname for the custom field.

    [sessioncancel:placeholder]

For example if you have an event custom field with the shortname \'cancellationreason\', to use the value recorded in the custom field in the notification body you would use the placeholder [sessioncancel:cancellationreason].

### 4. Multiple session event details

It is possible to include details of each session if you have multiple sessions for an event.
A segment of the notification can be repeated to include the details of each individual session. To do this, add [#sessions] where you would like the loop to start, add [/sessions] where you would like it to end.

You can then add the following placeholders between these tags:

* [session:starttime] - start time of the session.
* [session:startdate] - start date of the session.
* [session:finishtime] - finish time of the session.
* [session:finishdate] - finish date of the session.
* [session:timezone] - timezone of the session.
* [session:duration] - session duration.

### 4.1. Room details for each session

The details of any rooms used for the session can also be added to the notification by using the desired placeholders from the following list.

* [session:rooms] - room or list of rooms assigned to this session, each with building, location, and link to details.
* [session:room:name] - name of each room assigned to this session.
* [session:room:link] - link to details page for each room.

Room custom field information for each session can be added to the notification by using the following placeholder, replacing \'placeholder\' with the shortname for the custom field.

    [session:room:cf_placeholder]

For example if you have a room custom field with the shortname \'building\', to use the value recorded in the custom field in the notification body you would use the placeholder [session:room:cf_building].

### 4.2. Asset details for each session

The details of any assets used for the session can also be added to the notification by using the desired placeholders from the following list.

* [session:assets] - asset or list of assets assigned to this session, with link(s) to details.
* [session:asset:name] - name of each asset assigned to this session.
* [session:asset:link] - link to details page for each asset.
* [session:asset:cf_placeholder] - asset custom field information for each session, replacing \'placeholder\' with the shortname for the custom field.

### 4.3. Facilitator details for each session

The details of any facilitators used for the session can also be added to the notification by using the desired placeholders from the following list.

* [session:facilitators] - facilitator or list of facilitators assigned to this session, with link(s) to details.
* [session:facilitator:name] - name of each facilitator assigned to this session.
* [session:facilitator:link] - link to details page for each facilitator.
* [session:facilitator:cf_placeholder] - facilitator custom field information for each session, replacing \'placeholder\' with the shortname for the custom field.

### 5. User details

Available user placeholders:

* [firstname] - User\'s first name
* [lastname] - User\'s last name
* [middlename] - User\'s middle name
* [firstnamephonetic] - Phonetic spelling of the User\'s first name
* [lastnamephonetic] - Phonetic spelling of the User\'s last name
* [alternatename] - Alternate name the user is known by
* [fullname] - User\'s full name
* [username] - User\'s username
* [idnumber] - User\'s ID Number
* [email] - User\'s email address
* [address] - User\'s address
* [city] - User\'s city
* [country] - User\'s country
* [department] - User\'s department
* [description] - User\'s description
* [institution] - User\'s institution
* [lang] - User\'s language
* [skype] - User\'s Skype ID
* [phone1] - User\'s phone number
* [phone2] - User\'s mobile phone number
* [timezone] - User\'s timezone
* [url] - User\'s URL

### 6. User custom fields

There are also placeholders available for user custom profile fields that can be added to the notification by using the following placeholder, replacing the word placeholder with the user custom profile field shortname:

    [user:placeholder]

For example if you have a user custom profile field with the shortname \'suburb\' that you wish to use in the notification you would [user:suburb] as the placeholder.

### 7. Trusted content

To use placeholders in URL\'s, an admin will need to enable the **Enable trusted content** setting and grant **Trust submitted content** capability to approved roles.';
$string['booked'] = 'Booked';
$string['booked_status'] = 'Booked ({$a})';
$string['bookingcancelled'] = 'Your booking has been cancelled.';
$string['bookingcompleted'] = 'Your request was accepted.';
$string['bookingcompleted_approvalrequired'] = 'Your request was sent to your manager for approval.';
$string['bookingcompleted_roleapprovalrequired'] = 'Your request was sent for approval to each {$a} in this session.';
$string['bookingcompleted_roleapprovalrequired2'] = 'Your request was sent for approval to the following user(s): {$a}';
$string['bookingconflict'] = 'Booking conflict';
$string['bookingfull'] = 'Booking full';
$string['bookingopen'] = 'Booking open';
$string['bookingoptions'] = 'Booking options';
$string['bookingrestricted'] = 'Booking restricted';
$string['bookings'] = 'Bookings';
$string['bookingsessioncancelled'] = 'Event cancelled';
$string['bookingstatus'] = 'You are booked for the following event';
$string['building'] = 'Building';
$string['bulkactions'] = 'Bulk actions';
$string['bulkaddattendeeserror'] = 'Bulk add attendees error';
$string['bulkaddattendeesresults'] = 'Bulk add attendees results';
$string['bulkaddattendeessuccess'] = 'Bulk add attendees success';
$string['bulkaddhelptext'] = 'Note: Users must be referenced by their {$a} and must be delimited by a comma or newline';
$string['bulkaddsourceidnumber'] = 'ID number';
$string['bulkaddsourceuserid'] = 'user id';
$string['bulkaddsourceusername'] = 'username';
$string['bulkremoveattendeeserror'] = 'Bulk remove users errors';
$string['bulkremoveattendeessuccess'] = 'Bulk remove users success';
$string['cachedef_user_has_no_conflicts_passed'] = 'User has no conflicts condition passed';
$string['calendareventdescriptionbooking'] = 'You are booked for this <a href="{$a}">Seminar event</a>.';
$string['calendareventdescriptionfacilitato'] = 'You are a facilitator on this <a href="{$a}">Seminar event</a> session.';
$string['calendareventdescriptionsession'] = 'You have created this <a href="{$a}">Seminar event</a>.';
$string['calendaroptions'] = 'Calendar options';
$string['cancelattendance'] = 'Cancel changes';
$string['cancelattendees'] = 'Remove from waitlist';
$string['cancelbooking'] = 'Cancel booking';
$string['cancelbookingfor'] = 'Cancel booking for {$a}';
$string['cancelingsession'] = 'Cancelling event in {$a}';
$string['cancellation'] = 'Cancellation';
$string['cancellationconfirm'] = 'Are you sure you want to cancel your booking to this event?';
$string['cancellationcustomfieldtab'] = 'User cancellation';
$string['cancellationfields'] = 'Cancellation fields';
$string['cancellationfieldslimitation'] = 'The values entered below will be populated for all selected users.';
$string['cancellationmessage'] = 'Cancellation message';
$string['cancellationnotsent'] = 'Seminar activity email notifications are turned off.';
$string['cancellationreasoncourseunenrollment'] = '{$a->username} has been unenrolled from the course {$a->coursename}.';
$string['cancellations'] = 'Cancellations';
$string['cancellationsent'] = 'You should immediately receive a cancellation email.';
$string['cancellationsentmgr'] = 'You and your manager should immediately receive a cancellation email.';
$string['cancellationstablesummary'] = 'List of people who have cancelled their event signups.';
$string['cancelledstatus'] = 'Cancelled status';
$string['cancelreason'] = 'Reason';
$string['cancelreservation'] = 'Cancel reservation';
$string['cancelsession'] = 'Cancel event';
$string['cancelsessionconfirm'] = 'Cancelling this event will remove all of its booking, attendance and grade records. All attendees will be notified.';
$string['canceltype'] = 'Cancellation type';
$string['cancelwaitlist'] = 'Cancel waitlist';
$string['cancelwaitlistfor'] = 'Cancel place on the waitlist for {$a}';
$string['cannotapproveatcapacity'] = 'You cannot approve any more attendees as this session is full.';
$string['cannotsignupguest'] = 'Cannot sign up guest';
$string['cannotsignupsessioninprogress'] = 'You cannot sign up, this event is in progress';
$string['cannotsignupsessionover'] = 'You cannot sign up, this event is over.';
$string['capacity'] = 'Capacity';
$string['capacityallowoverbook'] = '{$a} (waitlist enabled)';
$string['capacitycurrentofmaximum'] = '{$a->current} / {$a->maximum}';
$string['capacitycurrentofmaximumwaitlist'] = '{$a->current} / {$a->maximum} ({$a->waitlist} on waitlist)';
$string['capacityoverbooked'] = ' (Overbooked)';
$string['capacityoverbookedlong'] = 'This event is overbooked ({$a->current} / {$a->maximum})';
$string['ccmanager'] = 'Manager copy';
$string['ccmanager_note'] = 'Send a copy of this notification to the user\'s manager';
$string['centralisednotifications_disabled'] = 'Modern notifications are disabled for this seminar';
$string['changeselectedusers'] = 'Change selected users';
$string['chooseapprovers'] = 'Select activity level approvers';
$string['chooseassets'] = 'Choose assets';
$string['choosefacilitator'] = 'Choose facilitator';
$string['choosefacilitators'] = 'Choose facilitators';
$string['chooserooms'] = 'Choose rooms';
$string['cleanuptask'] = 'Cleanup seminar';
$string['clearall'] = 'Clear all';
$string['close'] = 'Close';
$string['closed'] = 'Closed';
$string['closeregistrationstask'] = 'Close seminar events registration';
$string['completiondelay'] = 'Require event over for';
$string['completiondelay_error'] = '"Require event over for" must be a whole number between {$a->min} and {$a->max} days.';
$string['completiondelay_help'] = 'Checking this completion criteria will require the event to be over by the number of days set. The activity will not be considered complete until this time has lapsed.

Use this setting to allow trainers to mark attendance and/or grades without triggering activity completions. The setting of 0 days will delay activity completion until the event is over.';
$string['completiondelaydays'] = 'days';
$string['completiondelayrequirement'] = 'Event is over for {$a} day(s)';
$string['completiondelayrequirement_achieved'] = 'Event has been over for {$a} day(s)';
$string['completiondelayrequirement_notachieved'] = 'Event has not been over for {$a} day(s)';
$string['completionpass'] = 'Require grade'; // the language string should be identical to completion::completionpass
$string['completionpass:any'] = 'Yes, any grade (0&ndash;100)';
$string['completionpass:no'] = 'No';
$string['completionpass:pass'] = 'Yes, passing grade';
$string['completionpass_help'] = 'In order to complete this seminar, learners must receive a grade. Pass and fail icons may be displayed if "Passing grade" is not set to 0.';
$string['completionpassrequirement:any'] = 'Achieving any grade (0&ndash;100)';
$string['completionpassrequirement:pass'] = 'Achieving passing grade';
$string['completionstatusrequired'] = 'Require status';
$string['completionstatusrequired_help'] = 'Checking one or more statuses will require a user to achieve at least one of the checked statuses in order to be marked complete in this seminar activity, as well as any other Activity Completion requirements.';
$string['completionstatusrequirement_notachieved'] = 'Has not attended';
$string['confirm'] = 'Confirm';
$string['confirmanager'] = 'Confirm manager\'s email address';
$string['confirmation'] = 'Confirmation';
$string['confirmationmessage'] = 'Confirmation message';
$string['confirmationsent'] = 'You will receive a booking confirmation email shortly.';
$string['confirmationsentmgr'] = 'You will be notified about their decision.';
$string['confirmattendees'] = 'Confirm';
$string['confirmlotterybody'] = '"Play Lottery" randomly chooses attendees from the selected users in order to fill the event to its capacity. The chosen users will be immediately booked to the event and sent a booking confirmation email. Do you want to continue?';
$string['confirmlotteryheader'] = 'Confirm Play Lottery';
$string['connectedas'] = 'Connected as {$a}';
$string['connectedasx'] = 'Connected as {$a->name} ({$a->email})';
$string['connectionfailed'] = 'Connnection failed';
$string['copyingsession'] = 'Copying as a new event in {$a}';
$string['copynotification'] = 'Copy notification';
$string['copynotificationconfirm'] = 'Confirm you would like to copy the notification <strong>"{$a}"</strong>:';
$string['copynotificationcreated'] = 'Copy of the notification is created.';
$string['copynotificationtitle'] = 'Copy of {$a}';
$string['copyroomlink'] = 'Copy room link';
$string['copysession'] = 'Copy event';
$string['cost'] = 'Cost';
$string['created'] = 'Created';
$string['createnewasset'] = 'Create new asset';
$string['createnewfacilitator'] = 'Create new facilitator';
$string['createnewroom'] = 'Create new room';
$string['csvtextfile'] = 'CSV text file';
$string['csvtextfile_help'] = 'Preparing a file for upload: Use .CSV text file with a heading row and one or more data rows.

Mandatory columns

* \'username\' **OR** \'idnumber\' **OR** \'email\' (use only one)
{$a->requiredcustomfields}';
$string['csvtextfileoptionalcolumns_help'] = '

Optional columns

{$a->customfields}';
$string['csvtextinput'] = 'CSV text input';
$string['currentallocations'] = 'Allocated team members ({$a->allocated} / {$a->max})';
$string['currentattendees'] = 'Current attendees';
$string['currentlyassigned'] = 'Currently assigned to an event';
$string['currentlyselected'] = 'Currently selected';
$string['currentmanager'] = 'Current manager: ';
$string['customfieldother'] = '{$a}';
$string['customfieldroom'] = 'Room: {$a}';
$string['customfieldsession'] = 'Event: {$a}';
$string['customfieldsheading'] = 'Custom fields';
$string['customfieldsheadingaction'] = '{$a} Custom Fields';
$string['cutoff'] = 'Cut-off';
$string['cutoff_help'] = 'The amount of time before the first event that messages about minimum bookings will be sent.
This must be at least 24 hours before the event.
The start date of the earliest event must be at least this far in the future.';
$string['cutoffnote'] = 'before event starts';
$string['dataoptional'] = 'data may be empty';
$string['date'] = 'Date';
$string['dateadd'] = 'Add a new session';
$string['dateandtime'] = 'Date and time';
$string['dateremove'] = 'Remove this date';
$string['dateselect'] = 'Select date';
$string['datesignedup'] = 'Date Signed Up';
$string['datetext'] = 'You are signed in for date';
$string['deactivate'] = 'Deactivate';
$string['decidelater'] = 'Decide Later';
$string['decideuserlater'] = 'Decide later for {$a}';
$string['declareinterest'] = 'Declare interest';
$string['declareinterest_help'] = 'Displays an option within the seminar activity to allow a user to flag their interest and write a message without signing up.
Information about those who have declared an interest can be reported on from within the activity.';
$string['declareinterestalways'] = 'Always';
$string['declareinterestenable'] = 'Users can declare interest';
$string['declareinterestfiltercheckbox'] = 'Show only users who declared interest in this activity';
$string['declareinterestin'] = 'Declare interest in {$a}';
$string['declareinterestinconfirm'] = 'You can declare an interest in {$a} in order to be considered when new events are added or places become available in existing events.';
$string['declareinterestnever'] = 'Never';
$string['declareinterestnoupcoming'] = 'When no upcoming events are available for booking';
$string['declareinterestreason'] = 'Reason for interest:';
$string['declareinterestreport'] = 'Declared interest report';
$string['declareinterestreportdate'] = 'Date of declared interest';
$string['declareinterestreportreason'] = 'Stated reason for interest';
$string['declareinterestwithdraw'] = 'Withdraw interest';
$string['declareinterestwithdrawfrom'] = 'Withdraw interest declaration from {$a}';
$string['declareinterestwithdrawfromconfirm'] = 'Are you sure you want to withdraw your interest declaration from {$a}?';
$string['decline'] = 'Decline';
$string['declineuserevent'] = 'Decline {$a} for this event';
$string['decluttersessiontable'] = 'Events table - hide empty columns';
$string['decluttersessiontable_help'] = 'Enable this setting to hide empty columns in event sessions table. Hiding empty columns improves readability and reduces visual clutter on course and seminar pages.';
$string['defaultcsvdelimiter'] = 'Default CSV file delimiter';
$string['defaultcsvdelimiter_desc'] = 'Default CSV file delimiter description';
$string['defaultdaysbetweenstartfinish'] = 'Default days between start and finish';
$string['defaultdaysbetweenstartfinish_desc'] = 'The default number of days between the event start and finish.';
$string['defaultdaysskipweekends'] = 'Default days ahead on week days only';
$string['defaultdaysskipweekends_desc'] = 'When defaulting the start and finish dates only count week days';
$string['defaultdaystosession'] = 'Default days ahead for added events';
$string['defaultdaystosession_desc'] = 'When creating a new event its start and finish dates will default to this many days in the future.';
$string['defaultfinishtime'] = 'Default finish time';
$string['defaultfinishtimehelp'] = 'Default finish time for new events';
$string['defaultsessiontimes'] = 'Default event times';
$string['defaultstarttime'] = 'Default start time';
$string['defaultstarttimehelp'] = 'Default start time for new events';
$string['deleteall'] = 'Delete all';
$string['deleteassetconfirm'] = 'Are you sure you want to delete asset <strong>"{$a}"</strong>:';
$string['deletecancelsessionconfirm'] = 'Deleting this event will remove all booking, attendance and grade records associated with the seminar event. This action cannot be reversed.<br/><br/>
Are you sure you want to delete this event?';
$string['deletefacilitatorconfirm'] = 'Are you sure you want to delete facilitator <strong>"{$a}"</strong>:';
$string['deletenotificationconfirm'] = 'Confirm you would like to delete the notification <strong>"{$a}"</strong>:';
$string['deletenotificationtemplateconfirm'] = 'Confirm you would like to delete the notification template <strong>"{$a}"</strong>:';
$string['deletereservation'] = 'Delete reservations';
$string['deletereservationconfirm'] = 'Are you sure you want to delete all reservations in this event made by "{$a}"?';
$string['deleteroomconfirm'] = 'Are you sure you want to delete room <strong>"{$a}"</strong>:';
$string['deletesession'] = 'Delete event';
$string['deletesessionconfirm'] = 'Deleting this event will remove all of its booking, attendance and grade records.';
$string['deletesessionconfirmdelete'] = 'Delete';
$string['deletingsession'] = 'Deleting event in {$a}';
$string['delimiter'] = 'CSV file delimiter';
$string['delimiter:auto'] = 'Automatic';
$string['delimiter:colon'] = 'Colon (:)';
$string['delimiter:comma'] = 'Comma (,)';
$string['delimiter:semicolon'] = 'Semi-colon (;)';
$string['delimiter:tab'] = 'Tab (\t)';
$string['description'] = 'Introduction text';
$string['descriptionlabel'] = 'Description';
$string['details'] = 'Details';
$string['discardmessage'] = 'Discard message';
$string['discountcode'] = 'Discount code';
$string['discountcost'] = 'Discount cost';
$string['discountcosthinttext'] = '';
$string['dismiss'] = 'Dismiss';
$string['dismissedwarning'] = 'The warning will no longer be displayed for this seminar';
$string['download'] = 'Download';
$string['downloadsigninsheet'] = 'Download sign-in sheet:';
$string['downloadqrcode'] = 'Download QR code';
$string['due'] = 'due';
$string['duration'] = 'Duration';
$string['early'] = '{$a} early';
$string['editasset'] = 'Edit asset';
$string['editcustomassetx'] = 'Edit custom asset {$a} in session';
$string['editcustomfacilitatorx'] = 'Edit custom facilitator {$a} in session';
$string['editcustomroomx'] = 'Edit custom room {$a} in session';
$string['editdate'] = 'Edit session';
$string['editfacilitator'] = 'Edit facilitator';
$string['editingsession'] = 'Editing event in {$a}';
$string['editmessagerecipientsindividually'] = 'Edit recipients individually';
$string['editnotificationtemplate'] = 'Edit notification template';
$string['editnotificationx'] = 'Edit "{$a}"';
$string['editroom'] = 'Edit room';
$string['editsession'] = 'Edit event';
$string['email:instrmngr'] = 'Notice for manager';
$string['email:message'] = 'Message';
$string['email:subject'] = 'Subject';
$string['emailmanager'] = 'Send notice to manager';
$string['embedded:seminarassets'] = 'Seminars: Manage assets';
$string['embedded:seminarassetsupcoming'] = 'Seminars: Upcoming events using asset';
$string['embedded:seminareventattendance'] = 'Seminars: Event attendees';
$string['embedded:seminareventcancellations'] = 'Seminars: Event cancellations attendees';
$string['embedded:seminarevents'] = 'Seminars: View and manage events';
$string['embedded:seminareventwaitlist'] = 'Seminars: Event wait-list attendees';
$string['embedded:seminarfacilitators'] = 'Seminars: Manage facilitators';
$string['embedded:seminarfacilitatorsupcoming'] = 'Seminars: Upcoming events using facilitator';
$string['embedded:seminarinterest'] = 'Seminars: Declared interest';
$string['embedded:seminarrooms'] = 'Seminars: Manage rooms';
$string['embedded:seminarroomsupcoming'] = 'Seminars: Upcoming events using room';
$string['embedded:seminarsessionattendance'] = 'Seminars: Event sign-in sheet';
$string['embedded:seminarsessions'] = 'Seminars: View and manage sessions';
$string['embedded:seminarsignups'] = 'Seminars: Sign ups';
$string['emptylocation'] = 'Location was empty';
$string['enablemincapacity'] = 'Enable minimum bookings';
$string['enablemincapacitynotification'] = 'Notify about minimum bookings';
$string['enablemincapacitynotification_help'] = 'If the minimum bookings have not been reached by the cut-off point, then the appropriate users will be notified. Users to be notified is determined by the role assignments and the configuration setting under *Site administration > Seminars > General Settings > Notification*.';
$string['encoding'] = 'CSV file encoding';
$string['enrolled'] = 'enrolled';
$string['error:addalreadysignedupattendee'] = 'This user is already signed-up for this seminar activity.';
$string['error:addalreadysignedupattendeeaddself'] = 'You are already signed-up for this seminar activity.';
$string['error:addattendee'] = 'Could not add {$a} to the event.';
$string['error:alreadysignedup'] = 'Already signed up';
$string['error:approvaladminnotactive'] = 'Manager and Administrative approval is not activated';
$string['error:approvalinvalidmanager'] = 'Attendee {$a} is currently not assigned to you in this event';
$string['error:approvalinvalidstatus'] = 'Invalid signup status for attendee {$a}';
$string['error:approverinactive'] = 'User ID: {$a} does not exist or is not active.';
$string['error:approvernotselected'] = 'Please select an approver';
$string['error:approverselected'] = 'User {$a} selected more than once.';
$string['error:approversystem'] = 'User {$a} is system wide approver and cannot be selected here.';
$string['error:assetconflicts'] = 'Asset has conflicting usage';
$string['error:assetdoesnotexist'] = 'Asset does not exist';
$string['error:assetisinuse'] = 'This asset is used in one or more events';
$string['error:assetnotpublished'] = 'Asset is not publicly available';
$string['error:cancelbooking'] = 'There was a problem cancelling your booking';
$string['error:cancellationsnotallowed'] = 'You are not allowed to cancel this booking.';
$string['error:cannotapprovefull'] = 'One or more users were not assigned because the event is fully booked and over booking is not allowed';
$string['error:cannotcancel'] = 'Cannot cancel this signup';
$string['error:cannotchangestateuser'] = 'Could not change booking state for {$a->user}: {$a->error}';
$string['error:cannotdeclareinterest'] = 'Cannot declare interest in this seminar activity.';
$string['error:cannoteditcancelledevent'] = 'This event has been cancelled and can no longer be edited.';
$string['error:cannotemailmanager'] = 'Sent reminder mail for submission id {$a->submissionid} to user {$a->userid}, but could not send the message for the user\'s manager email address ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'Could not send out mail for submission id {$a->submissionid} to user {$a->userid} ({$a->useremail}).';
$string['error:cannotrepublishasset'] = 'This asset can not be published, it is already public';
$string['error:cannotrepublishfacilitator'] = 'This facilitator can not be published, it is already public';
$string['error:cannotrepublishroom'] = 'This room can not be published, it is already public';
$string['error:cannotsendconfirmationmanager'] = 'A confirmation message was sent to your email account, but there was a problem sending the confirmation message to your manager\'s email address.';
$string['error:cannotsendconfirmationthirdparty'] = 'A confirmation message was sent to your email account and your manager\'s email account, but there was a problem sending the confirmation message to the third party\'s email address.';
$string['error:cannotsendconfirmationuser'] = 'There was a problem sending the confirmation message to your email account.';
$string['error:cannotsendconfirmationusermanager'] = 'A confirmation message could not be sent to your email address and to your manager\'s email address.';
$string['error:cannotsendrequestmanager'] = 'There was a problem sending the signup request message to your manager\'s email account.';
$string['error:cannotsendrequestuser'] = 'There was a problem sending the signup request message to your email account.';
$string['error:cannotsignupforacancelledevent'] = 'This event has been cancelled. It is no longer possible to sign up for it.';
$string['error:cannotsignuptoeventasguest'] = 'Guests can not sign up for seminar events.';
$string['error:canttakeattendanceforunstartedsession'] = 'Can not take attendance for an event that has yet to start.';
$string['error:capabilityaddattendees'] = 'You do not have the necessary permissions to add attendees';
$string['error:capabilityapprovalrequired'] = 'You do not have the necessary permissions to view Approval Required page';
$string['error:capabilityremoveattendees'] = 'You do not have the necessary permissions to remove attendees';
$string['error:capabilitysendmessages'] = 'You do not have the necessary permissions to send messages';
$string['error:capacitynotnumeric'] = 'Event maximum bookings is not a number';
$string['error:capacityzero'] = 'Event maximum bookings must be greater than zero';
$string['error:conflictingsession'] = 'The user {$a} is already signed up for another event';
$string['error:couldnotaddfield'] = 'Could not add custom event field.';
$string['error:couldnotaddnotice'] = 'Could not add site notice.';
$string['error:couldnotaddtrainer'] = 'Could not save new seminar event trainer';
$string['error:couldnotcancelsession'] = 'Could not cancel session';
$string['error:couldnotcopysession'] = 'Could not copy event';
$string['error:couldnotdeclinerequest'] = 'Could not decline event for the user {$a}';
$string['error:couldnotdeletefield'] = 'Could not delete custom event field';
$string['error:couldnotdeletenotice'] = 'Could not delete site notice';
$string['error:couldnotdeletesession'] = 'Could not delete event';
$string['error:couldnotdeletetrainer'] = 'Could not delete a seminar event trainer';
$string['error:couldnotfindsession'] = 'Could not find the newly inserted event';
$string['error:couldnotsavecustomfield'] = 'Could not save custom field';
$string['error:couldnotsaveevent'] = 'Could not save event';
$string['error:couldnotsaveroom'] = 'There is a room conflict - another event is using the room at the same time';
$string['error:couldnotupdatecalendar'] = 'Could not update event in the calendar.';
$string['error:couldnotupdatef2frecord'] = 'Could not update seminar signup record in database';
$string['error:couldnotupdatefield'] = 'Could not update custom event field.';
$string['error:couldnotupdatenotice'] = 'Could not update site notice.';
$string['error:coursemisconfigured'] = 'Course is misconfigured';
$string['error:cronprefix'] = 'Error: seminar cron:';
$string['error:csvcannotparse'] = 'Cannot parse submitted CSV file.';
$string['error:csvinconsistentrows'] = 'Rows {$a} of your file contain a different number of columns than the header row';
$string['error:csvnoidfields'] = 'The column called \'username\', \'email\', or \'idnumber\' was not detected. Please check that the column header matches one of these fields and the CSV file delimiter setting below matches your file.';
$string['error:csvnorequiredcf'] = 'You did not provide a column called \'{$a}\'';
$string['error:csvtoomanyfields'] = 'Your file contained too many columns. Please provide the columns as per below help description.';
$string['error:csvtoomanyidfields'] = 'Your file contained more than one of the following columns: \'username\', \'email\', \'idnumber\'';
$string['error:cutofftooclose'] = 'The cut-off time for minimum bookings is too close to the events earliest start date, please set at least a 24 hours cut-off';
$string['error:cutofftoolate'] = 'The cut-off for minimum bookings is after the events earliest start date, it must be before to have any effect.';
$string['error:datesunavailablestuff'] = 'The new dates you have selected are unavailable due to a scheduling conflict with the following resources:<br/>{$a}Please choose different dates or change the selected room/facilitators/assets.';
$string['error:delimiternotfound'] = 'Supported CSV file delimiter is not found.';
$string['error:disconnected'] = 'Authorisation required.';
$string['error:emptylocation'] = 'Location was empty.';
$string['error:emptyvenue'] = 'Venue was empty.';
$string['error:enrolmentfailed'] = 'Could not enrol {$a} into the course.';
$string['error:eventoccurred'] = 'You cannot cancel an event that has already occurred.';
$string['error:f2ffailedupdatestatus'] = 'Seminar failed to update the user\'s status';
$string['error:facilitatorconflicts'] = 'Facilitator has conflicting usage';
$string['error:facilitatordoesnotexist'] = 'Facilitator does not exist';
$string['error:facilitatorexists'] = '{$a} facilitator is already exists with this user id';
$string['error:facilitatorisinuse'] = 'This facilitator is used in one or more events';
$string['error:facilitatornotpublished'] = 'Facilitator is not publicly available';
$string['error:facilitatornotselected'] = 'Facilitator is not selected';
$string['error:facilitatortypewrong'] = 'Facilitator type is wrong, please select \'External\'';
$string['error:fieldidincorrect'] = 'Field ID is incorrect: {$a}';
$string['error:incorrectassetid'] = 'Asset ID was incorrect';
$string['error:incorrectcourseid'] = 'Course ID was incorrect';
$string['error:incorrectcoursemodule'] = 'Course module is incorrect';
$string['error:incorrectcoursemoduleid'] = 'Course Module ID was incorrect';
$string['error:incorrectcoursemodulesession'] = 'Course Module Seminar Event was incorrect';
$string['error:incorrectfacetofaceid'] = 'Seminar ID was incorrect';
$string['error:incorrectfacilitatorid'] = 'Facilitator ID was incorrect';
$string['error:incorrectnotificationtype'] = 'Incorrect notification type supplied';
$string['error:incorrectroomid'] = 'Room ID was incorrect';
$string['error:invalidstatus'] = 'Invalid signup status';
$string['error:invaliduserid'] = 'Invalid user ID';
$string['error:invalidvalue'] = '(invalid)';
$string['error:isalreadybooked'] = '{$a} is already booked';
$string['error:jobassignementsonsignupdisabled'] = 'Select job assignments on sign up is not enabled for this Seminar activity.';
$string['error:lotterynocapacity'] = '"Play Lottery" disabled. The event is fully booked.';
$string['error:manageremailaddressmissing'] = 'You are currently not assigned to a manager in the system. Please contact the site administrator.';
$string['error:mincapacitymissing'] = 'Session minimum bookings value is missing';
$string['error:mincapacitynotnumeric'] = 'Event minimum bookings is not a number';
$string['error:mincapacitytoolarge'] = 'Event minimum bookings cannot be greater than the capacity';
$string['error:mincapacityzero'] = 'Event minimum bookings cannot be zero';
$string['error:missingrequiredmanager'] = 'This seminar requires manager approval. Users without a manager cannot join the seminar.';
$string['error:missingrequiredrole'] = 'This seminar requires role approval. There are no users assigned to this role. Please contact the site administrator.';
$string['error:missingselectedmanager'] = 'This seminar requires manager approval. Please select a manager to request approval';
$string['error:mustspecifycoursemodulefacetoface'] = 'Must specify a course module or a seminar ID';
$string['error:mustspecifytimezone'] = 'You must set the timezone for each date';
$string['error:nojobassignmentselected'] = 'You must have a suitable job assignment to sign up for this seminar event.';
$string['error:nojobassignmentselectedactivity'] = 'You must have a suitable job assignment to sign up for this seminar activity.';
$string['error:nojobassignmentselectedlist'] = 'You must select a suitable job assignment for all attendees in this list.';
$string['error:nomanagersemailset'] = 'No manager email is set';
$string['error:nopermissiontosignup'] = 'You don\'t have permission to signup to this seminar event.';
$string['error:nopredefinedassets'] = 'No pre-defined assets';
$string['error:nopredefinedfacilitators'] = 'No pre-defined facilitators';
$string['error:nopredefinedrooms'] = 'No pre-defined rooms';
$string['error:norecipientsselected'] = 'You must choose which learners will receive this notification';
$string['error:noticeidincorrect'] = 'Notice ID is incorrect: {$a}';
$string['error:notificationdoesnotexist'] = 'Notification does not exist';
$string['error:notificationnocopy'] = 'Notification copy failed.';
$string['error:notificationnonduplicate'] = 'Can not delete non-duplicate auto notification';
$string['error:notificationtemplatemissing'] = 'The following notification templates are missing (notifications could not be created for them):';
$string['error:nouseradded1'] = 'No users added.';
$string['error:nouseradded2'] = 'It appears that your list doesn\'t match the site records for usernames, id numbers or email addresses.';
$string['error:nouseradded3'] = 'Please try again with a valid user list.';
$string['error:plugin_is_disabled'] = 'Virtual meeting is disabled on this event';
$string['error:problemsigningup'] = 'There was a problem signing you up.';
$string['error:removeattendee'] = 'Could not remove {$a} from the event.';
$string['error:rolerequired'] = 'Seminar require approval by "{$a}" role. Please select at least one user with {$a} role.';
$string['error:roomconflicts'] = 'Room has conflicting usage';
$string['error:roomdoesnotexist'] = 'Room does not exist';
$string['error:roomisinuse'] = 'Room is in use';
$string['error:roomnotpublished'] = 'Room is not publicly available';
$string['error:roomunavailable'] = 'The "{$a}" room is no longer available.';
$string['error:selfattendance'] = ' The self check-in link has expired. Please contact your course trainer.';
$string['error:selfattendance_attendee'] = 'You are not booked for this event.';
$string['error:selfattendance_expiration'] = 'Self-attendance close time cannot be the same as or before Self-attendance open time.';
$string['error:selfattendance_event'] = 'Self check-in has not yet opened. Please check back later.';
$string['error:selfattendance_max_validity'] = 'Self-attendance close time cannot be more than 60 days from the open time.';
$string['error:selfapprovalupgrade'] = 'Self approval has been moved from sessions to a seminar setting, please run the admin tool to resolve any conflicts before upgrading.';
$string['error:sessiondatesbookingconflict'] = 'Booking conflict: {$a->users} user(s) have another booking on the selected date and time. Change event time or exclude these users to continue. {$a->link}';
$string['error:sessiondatesconflict'] = 'This date conflicts with an earlier date in this event';
$string['error:sessionstartafterend'] = 'Event start date/time is after end.';
$string['error:shortnamecustomfield'] = 'This shortname is reserved by Totara seminar custom field';
$string['error:shortnametaken'] = 'Custom field with this short name already exists.';
$string['error:signedupinothersession'] = 'You are already signed up in another event for this activity. You can only sign up for one event per seminar activity.';
$string['error:takeattendance'] = 'An error occurred while taking attendance.';
$string['error:therearexconflicts'] = 'There are ({$a}) conflicts with the proposed time period.';
$string['error:thereisaconflict'] = 'There is a conflict with the proposed time period.';
$string['error:toomanyvirtualmeetings'] = 'Too many virtual meetings. Please ensure that <strong>only one</strong> virtual meeting is assigned per session';
$string['error:unknownbuttonclicked'] = 'No action associated with the button that was clicked';
$string['error:unknownuserfield'] = 'This field is not supported for user search.';
$string['error:unrecognisedapprovaltype'] = 'Unrecognised approval type passed to facetoface_get_approvaltype_string()';
$string['error:urlformat'] = 'Invalid URL format';
$string['error:userassignedsessionconflictmultiday'] = '{$a->fullname} is already assigned as a \'{$a->participation}\' for {$a->session} at {$a->datetimestart} to {$a->datetimefinish}. Please select another user or change the session';
$string['error:userassignedsessionconflictmultidayselfsignup'] = 'You are already assigned as a \'{$a->participation}\' for {$a->session} at {$a->datetimestart} to {$a->datetimefinish}.';
$string['error:userassignedsessionconflictsameday'] = '{$a->fullname} is already assigned as a \'{$a->participation}\' for {$a->session} at {$a->timestart} to {$a->timefinish} on {$a->datestart}. Please select another user or change the session';
$string['error:userassignedsessionconflictsamedayselfsignup'] = 'You are already assigned as a \'{$a->participation}\' for {$a->session} at {$a->timestart} to {$a->timefinish} on {$a->datestart}.';
$string['error:userbookedsessionconflictmultiday'] = '{$a->fullname} is already booked to attend {$a->session} at {$a->datetimestart} to {$a->datetimefinish}. Please select another user or change the session';
$string['error:userbookedsessionconflictmultidayselfsignup'] = 'You are already booked to attend {$a->session} at {$a->datetimestart} to {$a->datetimefinish}.';
$string['error:userbookedsessionconflictsameday'] = '{$a->fullname} is already booked to attend {$a->session} at {$a->timestart} to {$a->timefinish} on {$a->datestart}. Please select another user or change the session';
$string['error:userbookedsessionconflictsamedayselfsignup'] = 'You are already booked to attend {$a->session} at {$a->timestart} to {$a->timefinish} on {$a->datestart}.';
$string['error:userdeleted'] = 'Can not add deleted user {$a} to the seminar.';
$string['error:userimportuseridnotanint'] = 'Cannot add user with user id {$a} because it is not an integer';
$string['error:usernotfound'] = '(not found)';
$string['error:usersuspended'] = 'Can not add suspended user {$a} to the seminar.';
$string['error:xinvalidjaidnumber'] = 'Job assignment with idnumber {$a->idnumber} not found for user {$a->user}';
$string['error_email_not_found'] = 'No user was found with the following email: {$a}';
$string['error_idnumber_not_found'] = 'No user was found with the following user ID number: {$a}';
$string['error_username_not_found'] = 'No user was found with the following username: {$a}';
$string['eventapprovalrequiredviewed'] = 'Approval required viewed';
$string['eventattendanceheader'] = 'Event Attendance';
$string['eventattendancerequestsapproved'] = 'Attendance requests approved';
$string['eventattendancerequestsdeclined'] = 'Attendance requests declined';
$string['eventattendancetime'] = 'Event attendance – mark at';
$string['eventattendancetime:any'] = 'Unrestricted – mark at any time';
$string['eventattendancetime:firststart'] = 'Beginning of first session';
$string['eventattendancetime:lastend'] = 'End of final session';
$string['eventattendancetime:laststart'] = 'Beginning of final session';
$string['eventattendancetime_help'] = 'Set when to unlock event attendance marking for trainers. Note that \'Beginning\' is effectively 15 minutes before session time.';
$string['eventattendancetracking:open'] = 'Take event attendance';
$string['eventattendancetracking:saved'] = 'Attendance submitted';
$string['eventattendanceupdated'] = 'Attendance updated';
$string['eventattendeejobassignmentupdated'] = 'Attendee job assignment updated';
$string['eventattendeenoteupdated'] = 'Attendee note updated';
$string['eventattendeesedited'] = 'Attendees edited';
$string['eventattendeesviewed'] = 'Attendees viewed';
$string['eventbookingbooked'] = 'Event booked';
$string['eventbookingcancelled'] = 'Event booking cancelled';
$string['eventbookingrequestapproved'] = 'Event booking request approved';
$string['eventbookingrequested'] = 'Event booking request created';
$string['eventbookingrequestedrole'] = 'Event booking request (role) created';
$string['eventbookingrequestrejected'] = 'Event booking request rejected';
$string['eventbookingstatus'] = 'Event booking';
$string['eventbookingwaitlisted'] = 'Event signup added to waitlist';
$string['eventdetails'] = 'Event details';
$string['eventgradeheader'] = 'Event Grade';
$string['eventgradingmanual'] = 'Manual event grading';
$string['eventgradingmanual_help'] = 'Separate event grades from attendance records. Event Grades will not be calculated by the system and will need to be entered manually.';
$string['eventgradingmethod'] = 'Grading method';
$string['eventgradingmethod:first'] = 'First event grade';
$string['eventgradingmethod:highest'] = 'Highest event grade';
$string['eventgradingmethod:last'] = 'Last event grade';
$string['eventgradingmethod:lowest'] = 'Lowest event grade';
$string['eventgradingmethod_help'] = 'Method used to determine the seminar grade for users who attend multiple events, based on highest event grade, lowest event grade, first event grade or last event grade.';
$string['eventgradingoutofrange'] = 'Event grade value "{$a->val}" has to be between {$a->min} and {$a->max}';
$string['eventinfo:allevents'] = 'All events';
$string['eventinfo:assets'] = 'Assets';
$string['eventinfo:attendees'] = 'Manage attendees';
$string['eventinfo:cancelcancel'] = 'Cancel';
$string['eventinfo:details:bookedcapacity'] = 'Booked/Capacity';
$string['eventinfo:details:sessiondate'] = 'Times';
$string['eventinfo:details:sessionstatus'] = 'Status';
$string['eventinfo:eventinfo'] = 'Event';
$string['eventinfo:movetotop'] = 'Back to top';
$string['eventinfo:rooms'] = 'Rooms';
$string['eventinfo:sessions'] = 'Sessions';
$string['eventinprogress'] = 'Event (in progress)';
$string['eventinterestdeclared'] = 'Interest declared';
$string['eventinterestreportviewed'] = 'Interest report viewed';
$string['eventinterestwithdrawn'] = 'Interest withdrawn';
$string['eventmessagesent'] = 'Message sent';
$string['eventmessageusersviewed'] = 'Message users viewed';
$string['eventmoreinfo'] = 'Event info';
$string['eventover'] = 'Event (over)';
$string['eventreportcnt'] = 'Seminar events: {$a}';
$string['eventreportheading'] = 'Seminar events';
$string['eventselfattendance'] = 'Successfully marked your attendance.';
$string['eventsessioncancelled'] = 'Event cancelled';
$string['eventsessioncreated'] = 'Event created';
$string['eventsessiondeleted'] = 'Event deleted';
$string['eventsessionsignup'] = 'Event signup';
$string['eventsessionstatus'] = 'Session status';
$string['eventsessionupdated'] = 'Event updated';
$string['eventsigninsheetexported'] = 'Sign-in sheet exported';
$string['eventsignupdeleted'] = 'Signup deleted';
$string['eventsignupstatusupdated'] = 'Signup status updated';
$string['eventsreport'] = 'Events report';
$string['eventstatususerbooking'] = '({$a})';
$string['eventsummary'] = 'Event summary: {$a->total} session(s) ({$a->upcoming} upcoming; {$a->over} over)';
$string['eventsview'] = 'Events view';
$string['eventupcoming'] = 'Event (upcoming)';
$string['excelformat'] = 'Excel';
$string['existingbookings'] = 'Bookings in other events';
$string['existingrecipients'] = 'Existing recipients';
$string['export'] = 'Export';
$string['exportattendance'] = 'Export attendance';
$string['exportattendance_help'] = 'Please note: when exporting attendees report from this page any deleted users will be excluded. To include deleted users you must go to Report Builder and export it there.';
$string['exportattendanceods'] = 'Export attendance form (ods)';
$string['exportattendancetxt'] = 'Export attendance form (txt)';
$string['exportattendancexls'] = 'Export attendance form (xls)';
$string['exportcsv'] = 'CSV';
$string['exportcsvforupload'] = 'CSV export for Upload';
$string['exportcustomprofilefields'] = 'Export custom profile fields';
$string['exportcustomprofilefields_desc'] = 'Include these custom user profile fields (short names) in seminar exports, separated by commas.';
$string['exportods'] = 'ODS (OpenDocument)';
$string['exporttofile'] = 'Export to file';
$string['exportuserprofilefields'] = 'Export user profile fields';
$string['exportuserprofilefields_desc'] = 'Include these user profile fields in the seminar exports, separated by commas.';
$string['exportxls'] = 'XLS (Microsoft Excel)';
$string['external'] = 'Allow room conflicts';
$string['f2f-waitlist-actions'] = 'Actions';
$string['f2f-waitlist-actions_help'] = 'The actions are:

* **Confirm**: Book the selected users into the event and remove them from the wait-list.
* **Cancel**: Cancel the selected user\'s requests and remove them from the wait-list.
* **Play Lottery**: Fill the available places on the events with a random selection of the users from the wait-list. Users who are not selected will be left on the wait-list.';
$string['facetoface'] = 'Seminar';
$string['facetoface:addattendees'] = 'Add attendees to a seminar event';
$string['facetoface:addinstance'] = 'Add a new seminar';
$string['facetoface:addrecipients'] = 'Add recipients to a seminar\'s message';
$string['facetoface:approveanyrequest'] = 'Approve any booking requests';
$string['facetoface:changesignedupjobassignment'] = 'Change signed up job assignment';
$string['facetoface:configurecancellation'] = 'Allow the configuration of booking cancellations, upon adding/editing a seminar activity.';
$string['facetoface:editevents'] = 'Add, edit, copy and delete seminar events';
$string['facetoface:exportattendance'] = 'Export attendance from all events';
$string['facetoface:exportsessionsigninsheet'] = 'Export the seminar session sign-in sheet';
$string['facetoface:joinanyvirtualroom'] = 'View \'Join now\' room link';
$string['facetoface:manageadhocassets'] = 'Manage ad-hoc assets';
$string['facetoface:manageadhocfacilitators'] = 'Manage ad-hoc facilitators';
$string['facetoface:manageadhocrooms'] = 'Manage ad-hoc rooms';
$string['facetoface:managearchivedattendees'] = 'Manage archived attendees';
$string['facetoface:manageattendeesnote'] = 'Manage event attendee\'s notes';
$string['facetoface:managecustomfield'] = 'Manage seminar custom fields';
$string['facetoface:managereservations'] = 'Manage reservations for an event';
$string['facetoface:managesitewideassets'] = 'Manage sitewide assets';
$string['facetoface:managesitewidefacilitators'] = 'Manage sitewide facilitators';
$string['facetoface:managesitewiderooms'] = 'Manage sitewide rooms';
$string['facetoface:removeattendees'] = 'Remove attendees from a seminar event';
$string['facetoface:removerecipients'] = 'Remove recipients from a seminar\'s message';
$string['facetoface:reserveother'] = 'Reserve on behalf of other managers';
$string['facetoface:reservespace'] = 'Reserve or allocate spaces for team members';
$string['facetoface:signup'] = 'Sign-up for an event';
$string['facetoface:signuppastevents'] = 'Sign-up for an event in the past';
$string['facetoface:signupwaitlist'] = 'Sign-up to full events';
$string['facetoface:surpasssignupperiod'] = 'Add attendees to a seminar event before or after the sign-up window';
$string['facetoface:takeattendance'] = 'Take attendance: ';
$string['facetoface:view'] = 'View seminar activities and events';
$string['facetoface:viewallsessions'] = 'View all seminar sessions';
$string['facetoface:viewattendees'] = 'View attendance list and attendees';
$string['facetoface:viewattendeesnote'] = 'View event attendee\'s notes';
$string['facetoface:viewcancellations'] = 'View cancellations';
$string['facetoface:viewemptyactivities'] = 'View empty seminar activities';
$string['facetoface:viewinterestreport'] = 'View seminar declared interest report';
$string['facetofacebooking'] = 'Seminar booking';
$string['facetofacename'] = 'Seminar name';
$string['facetofacesession'] = 'Seminar event';
$string['facilitator'] = 'Facilitator';
$string['facilitatoralreadybooked'] = ' (facilitator unavailable on selected dates)';
$string['facilitatorcreatesuccess'] = 'Successfully created facilitator';
$string['facilitatorcustomfieldtab'] = 'Facilitator';
$string['facilitatordeleted'] = 'Facilitator deleted';
$string['facilitatordescriptionlabel'] = 'Bio';
$string['facilitatordetails'] = 'Facilitator details';
$string['facilitatordisplayname'] = '{$a->name} ({$a->fullname})';
$string['facilitatorexternal'] = 'External';
$string['facilitatorhidden'] = 'Facilitator hidden successfully';
$string['facilitatorinternal'] = 'Internal';
$string['facilitatorlinkeduser'] = 'Linked user';
$string['facilitatorname'] = 'Name';
$string['facilitatornameedittoolong'] = 'Facilitator name can only be upto {$a} characters in length';
$string['facilitators'] = 'Facilitators';
$string['facilitatorshown'] = 'Facilitator shown successfully';
$string['facilitatortype'] = 'Type';
$string['facilitatortype_help'] = '* **Internal facilitator** must be linked to a site user. This user will see their facilitator sessions on their calendar.
* **External facilitator** doesn\'t require linking to a site user, therefore it can be anyone in or out of the organisation.';
$string['facilitatortype_label'] = 'Facilitator type';
$string['facilitatorupdatesuccess'] = 'Successfully updated facilitator';
$string['facilitatoruserchanged'] = 'Changing facilitator user will affect all upcoming seminar events';
$string['facilitatoruserdeleted'] = 'This facilitator/user has an inactive account or had been deleted, please contact the site administrator';
$string['facilitatoruserwarning'] = '{$a} has an inactive account or had been deleted, please update this record';
$string['feedback'] = 'Feedback';
$string['feedbackupdated'] = 'Feedback updated for \{$a} people';
$string['field:multiselect'] = 'Multiple selection';
$string['field:select'] = 'Menu of choices';
$string['field:text'] = 'Text';
$string['fielddeleteconfirm'] = 'Delete field \'{$a}\' and all event data associated with it?';
$string['filter_advanced:all'] = 'All';
$string['filter_advanced:attendanceopen'] = 'Take attendance';
$string['filter_advanced:attendancesaved'] = 'Attendance saved';
$string['filter_advanced:overbooked'] = 'Over maximum booking';
$string['filter_advanced:underbooked'] = 'Under minimum booking';
$string['filter_assetavailable'] = 'Available between';
$string['filter_assetavailable_help'] = 'This filter allows you to find assets that are available for a session by specifying the session start and end date.';
$string['filter_booking:all'] = 'All';
$string['filter_booking:booked'] = 'Booked';
$string['filter_booking:cancelled'] = 'Cancelled';
$string['filter_booking:open'] = 'Open';
$string['filter_booking:requested'] = 'Requested';
$string['filter_booking:waitlisted'] = 'Wait-listed';
$string['filter_event:all'] = 'All';
$string['filter_event:cancelled'] = 'Cancelled';
$string['filter_event:future'] = 'Upcoming only';
$string['filter_event:inprogress'] = 'In progress';
$string['filter_event:over'] = 'Over';
$string['filter_event:past'] = 'Past only';
$string['filter_event:upcoming'] = 'Upcoming';
$string['filter_event:waitlisted'] = 'Wait-listed';
$string['filter_facilitatoravailable'] = 'Available between';
$string['filter_facilitatoravailable_help'] = 'This filter allows you to find facilitators that are available for a session by specifying the session start and end date.';
$string['filter_roomavailable'] = 'Available between';
$string['filter_roomavailable_help'] = 'This filter allows you to find rooms that are available for a session by specifying the session start and end date.';
$string['filterby'] = 'Filter';
$string['filterbyadvanced'] = 'Advanced';
$string['filterbybooking'] = 'Booking';
$string['filterbyeventtime'] = 'Event';
$string['filterbyfacilitator'] = 'Facilitator';
$string['filterbyroom'] = 'Room';
$string['filtertoggle:closed'] = 'Show filters';
$string['filtertoggle:open'] = 'Hide filters';
$string['finishdatebefore'] = 'Finish date before';
$string['floor'] = 'Floor';
$string['forceselectjobassignment'] = 'Prevent signup if no job assignment is selected or can be found';
$string['format'] = 'Format';
$string['freebetween'] = 'Free between the following times';
$string['freebetweendates'] = 'Free between {$a->start} and {$a->end}';
$string['full'] = 'Date is fully occupied';
$string['generalsettings'] = 'General settings';
$string['gettointerestreport'] = 'To view the declare interest report go to the seminar activity and follow the \'Declared interest report\' link in the module admin menu.';
$string['gettosigninreport'] = 'To view the sign-in sheet go to the event attendees page and press the Download sign-in sheet button.';
$string['globalsettings'] = 'Global settings';
$string['goback'] = 'Go back';
$string['gotosession'] = 'Go to event';
$string['gradeinput_label'] = '{$a}\'s event grade';
$string['gradeinput_placeholder'] = 'Empty';
$string['gradepass'] = 'Passing grade';
$string['gradepass_error'] = 'Passing grade must be between {$a->min} and {$a->max}.';
$string['gradepass_help'] = 'A number between 0&ndash;100. Default values for attendance-based grades are: <ul><li>Fully attended: 100</li><li>Partially attended: 50</li><li>Unable to attend: 0</li><li>No show: 0</li></ul>';
$string['guestsno'] = 'Sorry, guests are not allowed to sign up for events.';
$string['header:approvalstate'] = 'Manager Approval';
$string['header:approvaltime'] = 'Approval Time';
$string['header:managername'] = 'Manager\'s Name';
$string['icaldescription'] = 'This calendar event is for the "{$a->name}" seminar event you have been booked on to.';
$string['icalendarheading'] = 'iCalendar Attachments';
$string['icallocationstringdelimiter'] = ',';
$string['id'] = 'Id';
$string['ignoreapprovalwhenaddingattendees'] = 'Book users without requiring approval';
$string['import'] = 'Import';
$string['importexportattendancelegend'] = 'Import/Export attendance';
$string['inactive'] = 'Inactive';
$string['individuals'] = 'Individuals';
$string['info'] = 'Info';
$string['inprogress'] = 'In progress';
$string['internal'] = 'Custom virtual room link';
$string['itemstoadd'] = 'Items to add';
$string['jobassignment'] = 'Job assignment';
$string['joinwaitlist'] = 'Join waitlist';
$string['joinwaitlistcompleted'] = 'You have been placed on the waitlist for this event.';
$string['lastreservation'] = 'Last reservations are {$a->reservedays} days before the event starts. Unallocated reservations will be deleted {$a->reservecanceldays} days before the event starts.';
$string['late'] = '\{$a} late';
$string['legacy_notifications'] = 'Use legacy notifications';
$string['legacy_notifications_disabled'] = 'Legacy notifications are disabled for this Seminar.';
$string['legacy_notifications_help'] = 'Disable modern notifications. Legacy seminar notifications will be used in this seminar instead of modern notifications.';
$string['location'] = 'Location';
$string['locationtimetbd'] = 'Location and time to be announced later.';
$string['lookfor'] = 'Search';
$string['managearchivedattendees'] = 'Manage archived users';
$string['manageassets'] = 'Manage assets';
$string['manageevents'] = 'View and manage events';
$string['managefacilitators'] = 'Manage facilitators';
$string['managenotificationtemplates'] = 'Manage notification templates';
$string['managerbookings'] = 'Bookings / reservations made by {$a}';
$string['managereservations'] = 'Manage reservations';
$string['managername'] = 'Manager\'s name';
$string['managername_help'] = 'Your manager will receive a notification about your request to book into this session. If the name and email address shown here do not belong to your manager, please contact the Site Administrator.';
$string['managerooms'] = 'Manage rooms';
$string['managerprefix'] = 'Manager copy prefix';
$string['managerreservationdeleted'] = 'Manager reservation deleted successfully';
$string['managerreservationdeletionfailed'] = 'Manager reservation deletion failed';
$string['managerreserve'] = 'Allow manager reservations';
$string['managerreserve_help'] = 'Managers are able to make reservations or bookings on behalf of their team members';
$string['managerreserveheader'] = 'Manager reservations';
$string['managesessions'] = 'View and manage sessions';
$string['managevirtualmeetingstask'] = 'Manage virtual meetings';
$string['mark_selected_as'] = 'and mark as';
$string['maxbookings'] = 'Maximum bookings';
$string['maxbookings_help'] = '**Maximum bookings** is the number of seats available in an event.

When a seminar event reaches maximum bookings the event details do not appear on the course page. The details will appear greyed out on the **View all events** page and the learner cannot enrol on the event.';
$string['maximumpoints'] = 'Maximum number of points';
$string['maximumsize'] = 'Maximum number of attendees';
$string['maxmanagerreserves'] = 'Maximum reservations';
$string['maxmanagerreserves_help'] = 'The maximum number of reservations / bookings that a manager can make for their team.';
$string['message'] = 'Change in booking in the course {$a->coursename}!

There has been a free place in the event on {$a->duedate} ({$a->name}) in the course {$a->coursename}.
You have been registered. If the date does not suit you anymore, please unregister at <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['messagebody'] = 'Body';
$string['messagecc'] = 'CC recipient\'s managers';
$string['messageheader'] = 'Message';
$string['messagerecipientgroups'] = 'Recipient Groups';
$string['messagerecipients'] = 'Recipients';
$string['messagesenttostaffmember'] = 'The following message has been sent to your staff member {$a}';
$string['messagesubject'] = 'Subject';
$string['messageusers'] = 'Message users';
$string['minbookings'] = 'Minimum bookings';
$string['minbookings_help'] = 'Sessions with a minimum bookings are highlighted when the number of booked users is less than the minimum bookings. To prevent highlighting, set the minimum bookings to zero.';
$string['mincapacity'] = 'Minimum bookings';
$string['mincapacity_help'] = 'Set a <b>Minimum bookings</b> number if you wish to notify the event organisers ahead of time in case of low turnout. <b>Default value: 0.</b><br><br>In order for this notification to work you must set a <b>cut-off point</b> for this event.<br><ul><li>For legacy seminar notifications, use ‘Notify about minimum bookings’ on this page.</li><li>If you are using the <b>modern notifications system</b> go to the minimum booking notification in order to set the cut-off point.</li></ul>';
$string['missingjobassignment'] = 'The job assignment was <strong>deleted</strong>';
$string['modulename'] = 'Seminar';
$string['modulenameplural'] = 'Seminars';
$string['moreactions'] = 'More actions';
$string['multidate'] = '(multi-date)';
$string['namewithmanager'] = '{$a->attendeename} ({$a->managername})';
$string['noactionableunapprovedrequests'] = 'No actionable unapproved requests';
$string['noadhocmessages'] = 'No ad-hoc messages found.';
$string['nocancellations'] = 'There have been no cancellations';
$string['nocustomfields'] = '<p>No custom fields are defined.</p>';
$string['nocustomroomedit'] = 'Custom Room can only be edited in event dialog box';
$string['nodatesyet'] = 'This event has no sessions. Attendees can sign-up to the waitlist for this event and will be booked automatically once one or more sessions are added.';
$string['nodownloadfiletype'] = 'No file type was found for downloading the content';
$string['nofacetofaces'] = 'There are no seminar activities';
$string['nojobassignment'] = 'User has no active job assignments';
$string['none'] = 'None';
$string['nonotifications'] = 'No notifications';
$string['nonotificationsmatchingsearch'] = 'No notifications matching search';
$string['nonotificationsofthistype'] = 'No notifications of this type';
$string['nonotificationtemplates'] = 'No notification templates';
$string['nonotificationtemplatesmatchingsearch'] = 'No notification templates matching search';
$string['nopendingapprovals'] = 'No pending approvals';
$string['norecipients'] = 'No recipients';
$string['noremindersneedtobesent'] = 'No reminders need to be sent.';
$string['noreservations'] = 'None';
$string['noreservationsforsession'] = 'There are no reservations for this event.';
$string['noresults'] = 'No results';
$string['normalcost'] = 'Normal cost';
$string['normalcosthinttext'] = '';
$string['nosessionfound'] = 'No sessions found for this event';
$string['nosessions'] = 'No events';
$string['nosignedupusers'] = 'No users have signed-up for this event.';
$string['nosignedupusersnumrequests'] = 'No users are fully booked for this event. {$a} users are awaiting approval.';
$string['nosignedupusersonerequest'] = 'No users are fully booked for this event. 1 user is awaiting approval.';
$string['nostarttime'] = 'No dates specified';
$string['notallowedtocancel'] = 'You are not allowed to cancel your booking in this event.';
$string['notapplicable'] = 'N/A';
$string['note'] = 'Note';
$string['notefull'] = 'Even if the event is fully booked you can still register. You will be queued (marked in red). If someone signs out, the first learner in the queue will be moved into registered learners and a notification will be sent to him/her by mail.';
$string['notification_attendance_status'] = 'Attendance status';
$string['notification_booking_status'] = 'Booking status';
$string['notification_options'] = 'Notifications';
$string['notification_other_status'] = 'Other';
$string['notification_subject_status'] = 'Attendance status';
$string['notificationalreadysent'] = 'This notification has already been sent, so can no longer be edited.';
$string['notificationboth'] = 'Email with iCalendar appointment';
$string['notificationdeleted'] = 'Notification deleted';
$string['notificationduplicatesfound'] = 'Duplicates of auto notifications found. Please remove them manually on <a href="{$a}">Notifications page</a> to avoid wrong notifications being sent.';
$string['notificationduplicatesmessage'] = 'This message has duplicate. Please remove all duplicates manually.';
$string['notificationemail'] = 'Email only';
$string['notificationnone'] = 'Do not send confirmation';
$string['notificationnotesetonintendeddate'] = 'NOTE: This notification was not sent on its originally intended date';
$string['notifications'] = 'Notifications';
$string['notifications_adhoc'] = 'Ad-hoc messages';
$string['notifications_adhocin'] = 'Ad-hoc messages in {$a}';
$string['notifications_help'] = 'Here you can manage notifications for this Seminar activity.';
$string['notifications_legacy'] = 'Legacy notifications';
$string['notifications_legacyin'] = 'Legacy notifications in {$a}';
$string['notificationsaved'] = 'Notification saved';
$string['notificationsheading'] = 'Notifications';
$string['notificationssuccessfullyreset'] = 'Notifications successfully reset';
$string['notificationtemplatedeleted'] = 'Notification template deleted';
$string['notificationtemplaterestored'] = 'Notification template restored. {$a} seminars are affected.';
$string['notificationtemplates'] = 'Notification templates';
$string['notificationtemplatesaved'] = 'Notification template saved';
$string['notificationtemplatestatus'] = 'Notification template status';
$string['notificationtemplatestatus_help'] = 'This status allows a notification template to be marked as **Active** or **Inactive**. Inactive notification templates will not be available to be used when setting up notifications for a seminar activity.';
$string['notificationtitle'] = 'Notification title';
$string['notificationtype'] = 'Receive confirmation by';
$string['notificationtype_1'] = 'Instant';
$string['notificationtype_2'] = 'Scheduled';
$string['notificationtype_4'] = 'Auto';
$string['notifycancelleduser'] = 'Notify cancelled attendees';
$string['notifycancelledusermanager'] = 'Notify cancelled attendees\' managers';
$string['notifynewuser'] = 'Send booking confirmation to new attendees';
$string['notifynewusermanager'] = 'Send booking confirmation to new attendees\' managers';
$string['notrequired'] = 'Not required';
$string['notsignedup'] = 'You are not signed up for this event.';
$string['notspecified'] = 'N/A';
$string['notsubmittedyet'] = 'Not yet evaluated';
$string['nottenantparticipant'] = 'The user is not a tenant participant';
$string['noupcoming'] = '<p><i>No upcoming events</i></p>';
$string['noupcomingsessionsinroom'] = 'No upcoming events in this room';
$string['numberofattendees'] = 'Number of attendees';
$string['occuredonx'] = 'Occurred on {$a}';
$string['occurswhenenabled'] = 'Occurs when enabled';
$string['occurswhenseminareventcancel'] = 'Occurs when a seminar\'s event is cancelled';
$string['occurswhenseminareventsignupexpired'] = 'Occurs when the registration period of a seminar\'s event session has been closed';
$string['occurswhenseminareventtrainerassigned'] = 'Occurs when a trainer is assigned to a seminar\'s event';
$string['occurswhenseminareventtrainerunassigned'] = 'Occurs when a trainer is unassigned from a seminar\'s event';
$string['occurswhenuserbookssession'] = 'Occurs when a learner books an event';
$string['occurswhenuserrequestssessionwithmanagerapproval'] = 'Occurs when a user attempts to book an event with manager approval required';
$string['occurswhenuserrequestssessionwithmanagerdecline'] = 'Occurs when a user attempts to declined an event with manager approval required';
$string['occurswhenusersbookingiscancelled'] = 'Occurs when a learner\'s booking is cancelled';
$string['occurswhenuserwaitlistssession'] = 'Occurs when a learner is waitlisted on an event';
$string['occursxaftersession'] = 'Occurs {$a} after end of event';
$string['occursxbeforesession'] = 'Occurs {$a} before start of event';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 hour';
$string['oneminute'] = '1 minute';
$string['options'] = 'Options';
$string['optionscolon'] = 'Options:';
$string['or'] = 'or';
$string['order'] = 'Order';
$string['otherbookedby'] = 'Booked by another manager';
$string['otherroom'] = 'Other room';
$string['othersession'] = 'Other event(s) in this activity';
$string['over'] = 'Over';
$string['place'] = 'Room';
$string['placeholder:address'] = '[address]';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:alternatename'] = '[alternatename]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:booked'] = '[booked]';
$string['placeholder:capacity'] = '[capacity]';
$string['placeholder:city'] = '[city]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:country'] = '[country]';
$string['placeholder:coursename'] = '[coursename]';
$string['placeholder:department'] = '[department]';
$string['placeholder:description'] = '[description]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:email'] = '[email]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishdate'] = '[finishdate]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:firstnamephonetic'] = '[firstnamephonetic]';
$string['placeholder:fullname'] = '[fullname]';
$string['placeholder:idnumber'] = '[idnumber]';
$string['placeholder:institution'] = '[institution]';
$string['placeholder:lang'] = '[lang]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:lastnamephonetic'] = '[lastnamephonetic]';
$string['placeholder:latestfinishdate'] = '[latestfinishdate]';
$string['placeholder:latestfinishtime'] = '[latestfinishtime]';
$string['placeholder:lateststartdate'] = '[lateststartdate]';
$string['placeholder:lateststarttime'] = '[lateststarttime]';
$string['placeholder:location'] = '[session:location]';
$string['placeholder:middlename'] = '[middlename]';
$string['placeholder:mincapacity'] = '[mincapacity]';
$string['placeholder:phone1'] = '[phone1]';
$string['placeholder:phone2'] = '[phone2]';
$string['placeholder:registrationcutoff'] = '[registrationcutoff]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:room'] = '[session:room]';
$string['placeholder:seminardescription'] = '[seminardescription]';
$string['placeholder:seminarname'] = '[seminarname]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:sessionrole'] = '[sessionrole]';
$string['placeholder:skype'] = '[skype]';
$string['placeholder:startdate'] = '[startdate]';
$string['placeholder:starttime'] = '[starttime]';
$string['placeholder:timezone'] = '[timezone]';
$string['placeholder:url'] = '[url]';
$string['placeholder:username'] = '[username]';
$string['placeholder:venue'] = '[session:venue]';
$string['playlottery'] = 'Play Lottery';
$string['pleaseselectusers'] = 'Please select users before continuing.';
$string['pluginadministration'] = 'Seminar administration';
$string['pluginname'] = 'Seminar';
$string['points'] = 'Points';
$string['pointsplural'] = 'Points';
$string['potentialallocations'] = 'Available team members ({$a} left)';
$string['potentialattendees'] = 'Potential Attendees';
$string['potentialrecipients'] = 'Potential recipients';
$string['previouseventstimeperiod'] = 'Previous events time period';
$string['previouseventstimeperiod_help'] = 'This specifies the length of time you want to see the previous events in Seminar page.';
$string['previoussessions'] = 'Past events';
$string['previoussessionslist'] = 'List of all past events for this seminar activity';
$string['printversionid'] = 'Print version: without name';
$string['printversionname'] = 'Print version: with name';
$string['published'] = 'Published';
$string['really'] = 'Do you really want to delete all results for this seminar?';
$string['recipients'] = 'Recipients';
$string['recipients_allbooked'] = 'All events (present and future)';
$string['recipients_attendedonly'] = 'Attended only';
$string['recipients_noshowsonly'] = 'No shows only';
$string['registeredon'] = 'Registered On';
$string['registrations'] = 'Registrations';
$string['reminder'] = 'Reminder';
$string['remindermessage'] = 'Reminder message';
$string['removeassetx'] = 'Remove asset {$a} from session';
$string['removeattendees'] = 'Remove users';
$string['removeattendeestep1'] = "Select users to remove (step 1 of 2)";
$string['removeattendeestep2'] = "Remove users (step 2 of 2)";
$string['removecfdatawarning'] = 'Removing users from this session also deletes their sign up data.';
$string['removedsuccessfully'] = 'Removed successfully';
$string['removefacilitatorx'] = 'Remove facilitator {$a} from session';
$string['removeroominuse'] = 'This room is currently being used';
$string['removeroomx'] = 'Remove room {$a} from session';
$string['replaceallocations'] = 'Create reservations when removing allocations';
$string['replacereservations'] = 'Replace reservations when adding allocations';
$string['reports:selectasset'] = 'To view this report, first <a href="{$a}">select an asset</a> you want to view.';
$string['reports:selectfacilitator'] = 'To view this report, first <a href="{$a}">select a facilitator</a> you want to view.';
$string['reports:selectroom'] = 'To view this report, first <a href="{$a}">select a room</a> you want to view.';
$string['requestmessage'] = 'Request message';
$string['requeststablesummary'] = 'People requesting to attended this event.';
$string['reservations'] = '{$a} reservation(s)';
$string['reserve'] = 'Reserve spaces for team';
$string['reserveallallocated'] = 'You have already allocated the maximum number of spaces you are able for this activity, you cannot reserve any more';
$string['reserveallallocatedother'] = 'This manager has already allocated the maximum number of spaces they are able to for this activity, you cannot reserve any more for them';
$string['reservecancel'] = 'Automatically cancel reservations';
$string['reservecanceldays'] = 'Reservation cancellation days';
$string['reservecanceldays_help'] = 'The number of days in advance of the event that reservations will be automatically cancelled, if not confirmed.';
$string['reservecapacitywarning'] = '* Any new reservations over the current event maximum bookings ({$a} left) will be added to the waiting list';
$string['reserved'] = 'Reserved';
$string['reservedays'] = 'Reservation deadline';
$string['reservedays_help'] = 'The number of days before the event starts after which no more reservations are allowed (must be greater than the cancellation days).';
$string['reservedby'] = 'Reserved ({$a})';
$string['reservegtcancel'] = 'The reservation deadline must be greater than the cancellation days';
$string['reserveintro'] = 'You can use this form to change the number of reservations you have for this event - to cancel existing reservations, just reduce the number below.';
$string['reserveintroother'] = 'You can use this form to change the number of reservations {$a} has for this event - to cancel existing reservations, just reduce the number below.';
$string['reservelinkformat'] = '{$a->link} ({$a->capacity}/{$a->maxcapacity})';
$string['reservenocapacity'] = 'There are no spaces left on this course, so you will not be able to make any reservations unless one of the participants cancels';
$string['reservenopermissionother'] = 'This manager does not have capabilities to reserve places in Seminar';
$string['reserveother'] = 'Reserve for another manager';
$string['reservepastdeadline'] = 'You cannot make any further reservations within {$a} days of the event starting';
$string['resetattendees'] = 'Delete attendees';
$string['resetattendees_help'] = 'Clear all attendees, waitlists and cancelled bookings.';
$string['resetseminarevents'] = 'Delete all events';
$string['resetseminarevents_help'] = 'Delete all events and keep seminar description and general settings.';
$string['restore'] = 'Restore this default notification template for all seminars';
$string['restoremissingdefaultnotifications'] = 'Restore missing default notifications';
$string['restoremissingdefaultnotificationsconfirm'] = 'This will restore any missing default notifications for "{$a}" these notifications are used by built in seminar functionality and may result in messages being sent to users. Do you want to continue?';
$string['restorenotificationtemplateconfirm'] = 'Confirm you would like to restore <strong>"{$a}"</strong> notification template for the ALL existing seminars:';
$string['result'] = 'Result';
$string['return'] = 'Return';
$string['room'] = 'Room';
$string['roomalreadybooked'] = ' (Room unavailable)';
$string['roomcapacity'] = 'Capacity';
$string['roomcreatesuccess'] = 'Successfully created room';
$string['roomcustom'] = '(Custom Room)';
$string['roomcustomfieldtab'] = 'Room';
$string['roomdeleted'] = 'Room deleted';
$string['roomdescription'] = 'Room description';
$string['roomdescriptionedit'] = 'Description';
$string['roomdetails'] = 'Room details';
$string['roomdoesnotexist'] = 'Room does not exist';
$string['roomgoto'] = 'Go to room';
$string['roomgotox'] = 'Go to \'{$a}\'';
$string['roomhidden'] = 'Room hidden successfully';
$string['roomhide'] = 'Hide from users when choosing a room on the Add/Edit event page';
$string['roomhost'] = 'Host meeting';
$string['roomhostjoin'] = 'Join as attendee';
$string['roomhostjoinx'] = 'Join \'{$a}\' as attendee';
$string['roomhostx'] = 'Start meeting as host of \'{$a}\'';
$string['roomidentifier_name_building'] = 'Room name and building';
$string['roomidentifier_name_building_address'] = 'Room name, building and address';
$string['roomidentifier_nameonly'] = 'Room name';
$string['roomisinuse'] = 'Room is in use';
$string['roomjoinnow'] = 'Join now';
$string['roomjoinnowx'] = 'Join \'{$a}\' now';
$string['roommustbebookedtoexternalcalendar'] = 'Note: Please ensure that this room is available before creating this booking.';
$string['roomname'] = 'Room name';
$string['roomnameedit'] = 'Name';
$string['roomnameedittoolong'] = 'Room name can only be upto {$a} characters in length';
$string['roomnumber'] = 'Room {$a}';
$string['rooms'] = 'Rooms';
$string['roomshow'] = 'Show to users when choosing a room on the Add/Edit event page';
$string['roomshown'] = 'Room shown successfully';
$string['roomtype'] = 'Room type';
$string['roomtype_help'] = 'If checked, allows the room to be booked for different events that are running at the same time.';
$string['roomupdatesuccess'] = 'Successfully updated room';
$string['roomurl'] = 'Virtual room link';
$string['roomurl_help'] = 'Use this setting to add your third-party video conferencing URL. When this room is assigned to a session, booked learners will see "Join now" button 15 minutes before session start time and throughout the session.';
$string['saveallfeedback'] = 'Save all responses';
$string['saveattendance'] = 'Save attendance';
$string['savenote'] = 'Save note';
$string['schedule_unit_1'] = '{$a} hours';
$string['schedule_unit_1_singular'] = '1 hour';
$string['schedule_unit_2'] = '{$a} days';
$string['schedule_unit_2_singular'] = '1 day';
$string['schedule_unit_4'] = '{$a} weeks';
$string['schedule_unit_4_singular'] = '1 week';
$string['scheduledsession'] = 'Scheduled event';
$string['scheduledsessions'] = 'Scheduled events';
$string['scheduling'] = 'Scheduling';
$string['searchlabel'] = 'Search keyword';
$string['seatsavailable'] = 'Seats available';
$string['select'] = ' Select ';
$string['selectall'] = 'Select all';
$string['selectallop'] = 'All';
$string['selectassets'] = 'Select assets';
$string['selected'] = 'Selected';
$string['selectedjob'] = 'Job on sign up';
$string['selectedjobassignment'] = 'Job assignment on sign up';
$string['selectedjobassignment_help'] = 'Select the job assignment that this training is for.';
$string['selectedjobassignmentedit'] = 'Job assignment';
$string['selectedjobassignmentname'] = 'Job assignment name on sign up';
$string['selectedposition'] = 'Position on sign up';
$string['selectedposition_help'] = 'Select the position that this training is for.';
$string['selectexport'] = 'Export (select file format)';
$string['selectfacilitators'] = 'Select facilitators';
$string['selectfileformat'] = 'Select file format';
$string['selectjobassignment'] = 'Select a job assignment';
$string['selectjobassignmentsignup'] = 'Select job assignment on signup';
$string['selectlearner'] = 'Select learners';
$string['selectmanager'] = 'Select manager';
$string['selectnone'] = 'Select none';
$string['selectnoneop'] = 'None';
$string['selectnotsetop'] = 'Not Set';
$string['selectone'] = 'Select one ...';
$string['selectoptionbefore'] = ' Please choose an option (All, Set or Not set) before selecting this option';
$string['selectrooms'] = 'Select rooms';
$string['selectsession'] = 'Select session';
$string['selectsetop'] = 'Set';
$string['selectuserwithdot'] = 'Select user...';
$string['selectwithdot'] = 'Select...';
$string['selfapproval'] = 'Self Approval';
$string['selfapproval_help'] = 'This setting allows a user to confirm that they have sought approval to attend the event. Instead of their manager needing to approve their booking the user is presented with a check box when signing up and must confirm they have met the specified terms and conditions.
This setting will be disabled unless **Requires approval** is enabled in the seminar activity settings.';
$string['selfapprovalsought'] = 'Self Approval Sought';
$string['selfapprovalsoughtbrief'] = 'I accept the terms and conditions.';
$string['selfapprovalsoughtdesc'] = 'By checking this box, I confirm that I have read and agreed to the {$a} (opens a new window).';
$string['selfapprovaltandc'] = 'Self Approval Terms and Conditions';
$string['selfapprovaltandc_help'] = 'Where an activity has approval required and an event has self approval enabled these are the terms and conditions that will be displayed when a user signs up.';
$string['selfapprovaltandccontents'] = 'Check the box to confirm your eligibility to sign up to this seminar.
';
$string['selfauthorisation'] = 'Self authorisation';
$string['selfauthorisation_help'] = 'You must read and agree to the terms and conditions before signing up for the session.';
$string['selfauthorisationdesc'] = 'By checking this box, I confirm that I have read and agreed to the {$a} (opens a new window).';
$string['selfbooked'] = 'Self booked';
$string['selfattendance'] = 'Enable self-attendance';
$string['selfattendancecopy'] = 'Copy link';
$string['selfattendancecopysuccess'] = 'Link copied to clipboard';
$string['selfattendanceheader'] = 'Self-attendance';
$string['selfattendance_expire'] = 'Link expired on {$a}';
$string['selfattendance_close'] = 'Self-attendance close';
$string['selfattendance_close_help'] = 'Define the self attendance end date and time. Participants will not be able to mark their own attendance after this date and time.';
$string['selfattendance_help'] = 'Allow participants to mark their own attendance for this event using a unique check-in link. When enabled, participants can confirm their attendance. A check-in expiry time must be set to control when self check-in is available.';
$string['selfattendance_open'] = 'Self-attendance open';
$string['selfattendance_open_help'] = 'Define the self attendance open date and time. Participants will not be able to mark their own attendance before this date and time.';
$string['seminarid'] = 'Seminar ID';
$string['sendlater'] = 'Send later';
$string['sendmessage'] = 'Send message';
$string['sendnotificationstask'] = 'Send seminar notifications';
$string['sendnow'] = 'Send now';
$string['sent'] = 'Sent';
$string['sentremindermanager'] = 'Sent reminder email to user manager';
$string['sentreminderuser'] = 'Sent reminder email to user';
$string['sentxnotifications'] = 'Send {$a} notifications';
$string['sessionattendanceheader'] = 'Session Attendance';
$string['sessionattendancetime'] = 'Session attendance tracking';
$string['sessionattendancetime:any'] = 'Unrestricted – mark at any time';
$string['sessionattendancetime:disabled'] = 'Disabled – don\'t track sessions';
$string['sessionattendancetime:end'] = 'End of session';
$string['sessionattendancetime:start'] = 'Beginning of session';
$string['sessionattendancetime_help'] = 'Set when to unlock session attendance marking, or disable the feature. Note that \'Beginning\' is effectively 15 minutes before session time.';
$string['sessionattendees'] = 'Session attendees';
$string['sessioncancellationcustomfieldtab'] = 'Event cancellation';
$string['sessioncancelled'] = 'Cancelled';
$string['sessioncustomfieldtab'] = 'Event';
$string['sessiondate'] = 'Session';
$string['sessiondatecolumn_html'] = '{$a->startdate} {$a->starttime} -<br>{$a->enddate} {$a->endtime}<br>{$a->timezone}';
$string['sessiondates'] = 'Specify sessions details';
$string['sessiondatestart'] = 'Session Start Date';
$string['sessiondatetime'] = 'Event date/time';
$string['sessiondatetimecourseformat'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (time zone: {$a->timezone})';
$string['sessiondatetimecourseformatwithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessiondefaults'] = 'Event defaults';
$string['sessionenddate'] = 'Session end date';
$string['sessionenddatewithtime'] = '{$a->enddate}, {$a->endtime} {$a->timezone}';
$string['sessionfinishdate'] = 'Session Finish Date';
$string['sessionfinishdateshort'] = 'Finish date';
$string['sessionfinishdatetime'] = 'Session Finish Date/Time';
$string['sessionfinishdatetimelink'] = 'Session Finish Date/Time (linked to activity)';
$string['sessionfinishtime'] = 'Event finish time';
$string['sessionfinishtime_help'] = 'When creating or editing an event, the event timezone may differ from the timezone for the **Finish time**. This is because the timezone for **Finish time** is determined by the timezone of the user creating or editing the event. The timezone of the user creating or editing the event does not affect the event timezone itself.';
$string['sessioninformation'] = '- Session: {$a->datetime} ({$a->status})';
$string['sessioninprogress'] = 'In progress';
$string['sessionisfull'] = 'This event is now full. You will need to pick another time or talk to the instructor.';
$string['sessionnoattendeesaswaitlist'] = 'This event does not have any attendees because it does not have a known date and time.<br />See the wait-list tab for users that have signed up.';
$string['sessionover'] = 'Over';
$string['sessionreport'] = 'Seminar sessions';
$string['sessionreportcnt'] = 'Seminar sessions: {$a}';
$string['sessionrequiresmanagerapproval'] = 'This event requires manager approval to book.';
$string['sessionroles'] = 'Event roles';
$string['sessionroles_help'] = 'These users have these roles in this course, and they can be assigned for them in this event. If assigned, they will be tracked with the event and receive all notifications sent to \'Users with event roles\'.';
$string['sessions'] = 'Events';
$string['sessionsdatelist'] = 'List of sessions for this seminar event';
$string['sessionsdetailstablesummary'] = 'Full description of the current event.';
$string['sessionslist'] = 'List of events for this seminar activity';
$string['sessionslist:actions'] = 'Actions';
$string['sessionslist:attendancetracking'] = 'Attendance tracking';
$string['sessionslist:bookedandcapacity'] = 'Booked';
$string['sessionslist:date'] = 'Session dates';
$string['sessionslist:eventstatus'] = 'Event status';
$string['sessionslist:roomdetails'] = 'View details';
$string['sessionslist:sessionstatus'] = 'Session status';
$string['sessionslist:time'] = 'Session times';
$string['sessionslist:timeandtimezone'] = 'Session times';
$string['sessionsoncoursepage'] = 'Events displayed on course page';
$string['sessionsreport'] = 'Sessions report';
$string['sessionstartdate'] = 'Session start';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} {$a->timezone}';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartdateshort'] = 'Start date';
$string['sessionstartdatewithtime'] = '{$a->startdate}, {$a->starttime} {$a->timezone}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->enddate}, {$a->endtime} {$a->timezone}';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->enddate}, {$a->endtime}';
$string['sessionstarttime'] = 'Event start time';
$string['sessionstarttime_help'] = 'When creating or editing an event, the event timezone may differ from the timezone for the **Start time**. This is because the timezone for **Start time** is determined by the timezone of the user creating or editing the event. The timezone of the user creating or editing the event does not affect the event timezone itself.';
$string['sessionstatus'] = '{$a->statuslabel} sessions';
$string['sessionstatus:cancelled'] = 'Cancelled';
$string['sessionstatus:inprogress'] = 'Session in progress';
$string['sessionstatus:over'] = 'Session over';
$string['sessionstatus:upcoming'] = 'Upcoming';
$string['sessionstatus:waitlisted'] = 'Wait-listed';
$string['sessionsview'] = 'Sessions view';
$string['sessiontimedescription'] = '{$a->start} - {$a->end}';
$string['sessiontimezone'] = 'Timezone displayed';
$string['sessiontimezone_help'] = 'Select the timezone you want this event to be displayed in e.g. \'Pacific/Auckland\'. This will display the start time, finish time and timezone in accordance with the timezone selected. If you choose **User timezone**, this will display the start time, finish date and timezone in relation to the timezone of the user viewing the event.';
$string['sessiontimezoneunknown'] = 'Unknown Timezone';
$string['sessionupcoming'] = 'Upcoming';
$string['sessionvenue'] = 'Event venue';
$string['setactive'] = 'Set active';
$string['setinactive'] = 'Set inactive';
$string['setting:adminapprovers_caption'] = 'Site level administrative approvers';
$string['setting:adminapprovers_format'] = 'Selected users \'site level administrative approvers\' are automatically added to all seminar activities and can not be removed from within any given activity (note: other administrative approvers can be added to each seminar activity)';
$string['setting:allow_legacy_notifications'] = "Allow legacy notifications in seminars. If enabled, legacy seminar notifications can be used instead of the modern notification system. If disabled, all seminar notifications are sent using the modern notification system.";
$string['setting:allow_legacy_notifications_caption'] = "Allow legacy notifications";
$string['setting:allowschedulingconflicts'] = 'Allow or disallow user conflicts to exist while creating a new event.';
$string['setting:allowschedulingconflicts_caption'] = 'Allow override user conflicts:';
$string['setting:allowwaitlisteveryone'] = 'When enabled a setting will appear in seminar event settings to put all users onto the waiting list when they signup regardless of event maximum bookings.';
$string['setting:allowwaitlisteveryone_caption'] = 'Everyone on waiting list';
$string['setting:approval_admin'] = 'Manager and Administrative approval';
$string['setting:approval_manager'] = 'Manager approval';
$string['setting:approval_none'] = 'No approval required';
$string['setting:approval_role'] = 'Session role approved';
$string['setting:approval_self'] = 'Learner accepts terms and conditions';
$string['setting:approvaloptions_caption'] = 'Available Approval Options';
$string['setting:approvaloptions_default'] = 'The options selected above will be available in the \'require approval by\' setting for all seminar activities. Text entered below the \'Learner accepts terms and conditions\' option will be default for all activities and can be edited for each activity. Selected \'site level administrative approvers\' are automatically added to all seminar activities and can not be removed from within any given activity (note: other administrative approvers can be added to each seminar activity)';
$string['setting:calendarfilters'] = 'Selected fields will be displayed as filters in the user\'s calendar';
$string['setting:calendarfilterscaption'] = 'Add calendar filters:';
$string['setting:defaultadminrequestinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking request is copied below ****';
$string['setting:defaultadminrequestinstrmngrdefault'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as an approver for the session.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to approve the request:
[attendeeslink]
';
$string['setting:defaultadminrequestinstrmngrdefault_v92'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as an approver for the session.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to approve the request:
[attendeeslink]

Below is the message that was sent to the learner:

';
$string['setting:defaultadminrequestmessagedefault'] = 'Your request to book into the following course has been sent to the sessions approvers:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]
Cost:   [cost]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultadminrequestmessagedefault_v9'] = 'Your request to book into the following course has been sent to the sessions approvers:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]
Cost:   [cost]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

This request will expire on [registrationcutoff]
';
$string['setting:defaultadminrequestsubjectdefault'] = 'Seminar booking admin request: [seminarname], [eventperiod]';
$string['setting:defaultcancelallreservationsmessagedefault'] = 'This is to advise you that all unallocated reservations for the following course have been automatically cancelled, as the course will be starting soon:

***ALL RESERVATIONS CANCELLED***

Course:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultcancelallreservationsmessagedefault_v9'] = 'This is to advise you that all unallocated reservations for the following course have been automatically cancelled, as the course will be starting soon:

***ALL RESERVATIONS CANCELLED***

Course:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultcancelallreservationssubjectdefault'] = 'All reservations cancelled';
$string['setting:defaultcancelallreservationssubjectdefault_v9'] = 'All reservations cancelled';
$string['setting:defaultcancellationinstrmngr'] = 'Default cancellation message sent to managers.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Cancellation message (managers)';
$string['setting:defaultcancellationinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking cancellation is copied below ****';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** Advice only ****

This is to advise that [firstname] [lastname] is no longer signed-up for the following course and listed you as their Team Leader / Manager.

';
$string['setting:defaultcancellationinstrmngrdefault_v92'] = '*** Advice only ****

This is to advise that [firstname] [lastname] is no longer signed up for the following course and listed you as their Team Leader / Manager.

Below is the message that was sent to the learner:

';
$string['setting:defaultcancellationmessage'] = 'Default cancellation message sent to the user.';
$string['setting:defaultcancellationmessage_caption'] = 'Cancellation message';
$string['setting:defaultcancellationmessagedefault'] = 'This is to advise that your booking on the following course has been cancelled:

***BOOKING CANCELLED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultcancellationmessagedefault_v9'] = 'This is to advise that your booking on the following course has been cancelled:

***BOOKING CANCELLED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultcancellationsubject'] = 'Default subject line for cancellation emails.';
$string['setting:defaultcancellationsubject_caption'] = 'Cancellation subject';
$string['setting:defaultcancellationsubjectdefault'] = 'Face-to-face booking cancellation';
$string['setting:defaultcancellationsubjectdefault_v9'] = 'Seminar booking cancellation';
$string['setting:defaultcancelreservationmessagedefault'] = 'This is to advise you that your reservation for the following course has been cancelled:

***RESERVATION CANCELLED***

Course:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]';
$string['setting:defaultcancelreservationmessagedefault_v9'] = 'This is to advise you that your reservation for the following course has been cancelled:

***RESERVATION CANCELLED***

Course:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultcancelreservationsubjectdefault'] = 'Reservation cancellation';
$string['setting:defaultcancelreservationsubjectdefault_v9'] = 'Reservation cancellation';
$string['setting:defaultconfirmationinstrmngr'] = 'Default confirmation message sent to managers.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Confirmation message (managers)';
$string['setting:defaultconfirmationinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking confirmation is copied below ****';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Advice only ****

This is to advise that [firstname] [lastname] has been booked for the following course and listed you as their Team Leader / Manager.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.  If you have concerns about your staff member taking this course please discuss this with them directly.

';
$string['setting:defaultconfirmationinstrmngrdefault_v92'] = '*** Advice only ****

This is to advise that [firstname] [lastname] has been booked for the following course and listed you as their Team Leader / Manager.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.  If you have concerns about your staff member taking this course please discuss this with them directly.

Below is the message that was sent to the learner:

';
$string['setting:defaultconfirmationmessage'] = 'Default confirmation message sent to users.';
$string['setting:defaultconfirmationmessage_caption'] = 'Confirmation message';
$string['setting:defaultconfirmationmessagedefault'] = 'This is to confirm that you are now booked on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]
Cost:   [cost]

Duration:    [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]

***Please arrive ten minutes before the course starts***

To re-schedule or cancel your booking
To re-schedule your booking you need to cancel this booking and then re-book a new session.  To cancel your booking, return to the site, then to the page for this course, and then select \'cancel\' from the booking information screen.

[details]
';
$string['setting:defaultconfirmationmessagedefault_v9'] = 'This is to confirm that you are now booked on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]
Cost:   [cost]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

***Please arrive ten minutes before the course starts***

To re-schedule or cancel your booking
To re-schedule your booking you need to cancel this booking and then re-book a new event.  To cancel your booking, return to the site, then to the page for this course, and then select \'cancel\' from the booking information screen.

[details]
';
$string['setting:defaultconfirmationsubject'] = 'Default subject line for confirmation emails.';
$string['setting:defaultconfirmationsubject_caption'] = 'Confirmation subject';
$string['setting:defaultconfirmationsubjectdefault'] = 'Face-to-face booking confirmation: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultconfirmationsubjectdefault_v9'] = 'Seminar booking confirmation: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultdatetimechangemessagedefault'] = 'Your session date/time has changed:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultdatetimechangemessagedefault_v9'] = 'The session you are booked on (or on the waitlist) has changed:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultdatetimechangesubject'] = 'Default subject line for date/time change emails.';
$string['setting:defaultdatetimechangesubject_caption'] = 'Date/time change subject';
$string['setting:defaultdatetimechangesubjectdefault'] = 'Face-to-face booking date/time changed: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultdatetimechangesubjectdefault_v9'] = 'Seminar date/time changed: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultdeclineinstrmngr'] = 'Default decline message sent to managers.';
$string['setting:defaultdeclineinstrmngr_caption'] = 'Decline message (managers)';
$string['setting:defaultdeclineinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking decline is copied below ****';
$string['setting:defaultdeclineinstrmngrdefault'] = '*** Advice only ****

This is to advise that [firstname] [lastname] is no longer signed-up for the following course and listed you as their Team Leader / Manager.

';
$string['setting:defaultdeclineinstrmngrdefault_v92'] = '*** Advice only ****

This is to advise that [firstname] [lastname] is no longer signed-up for the following course and listed you as their Team Leader / Manager.

Below is the message that was sent to the learner:

';
$string['setting:defaultdeclinemessage'] = 'Default decline message sent to the user.';
$string['setting:defaultdeclinemessage_caption'] = 'Decline message';
$string['setting:defaultdeclinemessagedefault'] = 'This is to advise that your booking on the following course has been declined:

***BOOKING DECLINED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultdeclinemessagedefault_v9'] = 'This is to advise that your booking on the following course has been declined:

***BOOKING DECLINED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultdeclinesubject'] = 'Default subject line for decline emails.';
$string['setting:defaultdeclinesubject_caption'] = 'Decline subject';
$string['setting:defaultdeclinesubjectdefault'] = 'Face-to-face booking decline';
$string['setting:defaultdeclinesubjectdefault_v9'] = 'Seminar booking decline';
$string['setting:defaultfacilitatorassignedmessagedefault'] = 'This is to confirm that you are now assigned to deliver training on the following seminar session(s):

Facilitator: [firstname] [lastname]
Course: [coursenamelink]
Seminar: [seminarnamelink]

Date(s) and location(s):
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
Room: [session:room:name]
Building: [session:room:cf_building]
Location: [session:room:cf_location]
[session:room:link]
[/sessions]

[details]';
$string['setting:defaultfacilitatorassignedsubjectdefault'] = 'Seminar session facilitator confirmation';
$string['setting:defaultfacilitatorcancelmessagedefault'] = 'This is to advise that the seminar session(s) you are assigned to as facilitator have been cancelled:

***SESSION CANCELLED***

Facilitator: [firstname] [lastname]
Course: [coursenamelink]
Seminar: [seminarnamelink]

Date(s) and location(s):
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
Room: [session:room:name]
Building: [session:room:cf_building]
Location: [session:room:cf_location]
[session:room:link]
[/sessions]';
$string['setting:defaultfacilitatorcancelsubjectdefault'] = 'Seminar session facilitator cancellation';
$string['setting:defaultfacilitatortimechangemessagedefault'] = 'The seminar session(s) you are assigned to facilitate have been changed:

Facilitator: [firstname] [lastname]
Course: [coursenamelink]
Seminar: [seminarnamelink]

The updated information is:
Date(s) and location(s):
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
Room: [session:room:name]
Building: [session:room:cf_building]
Location: [session:room:cf_location]
[session:room:link]
[/sessions]';
$string['setting:defaultfacilitatortimechangesubjectdefault'] = 'Seminar session date/time changed: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultfacilitatorunassignedmessagedefault'] = 'This is to advise that you have been unassigned from facilitating the following seminar session(s):

***SESSION UNASSIGNED***

Facilitator: [firstname] [lastname]
Course: [coursenamelink]
Seminar: [seminarnamelink]

Date(s) and location(s):
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
Room: [session:room:name]
Building: [session:room:cf_building]
Location: [session:room:cf_location]
[session:room:link]
[/sessions]';
$string['setting:defaultfacilitatorunassignedsubjectdefault'] = 'Seminar session facilitator unassigned';
$string['setting:defaultminbookings'] = 'Default minimum bookings';
$string['setting:defaultminbookings_help'] = 'Default value for all seminar events. All events can still have a custom minimum bookings when setting up a new seminar event.';
$string['setting:defaultpendingreqclosureinstrmngr'] = 'Default registration closure message sent to managers.';
$string['setting:defaultpendingreqclosureinstrmngrcopybelow'] = '*** Advice only ****
Your staff member [firstname] [lastname] had a pending request to attend the below seminar event and has also received this closure email.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.
';
$string['setting:defaultpendingreqclosureinstrmngrcopybelow_v92'] = '*** Advice only ****
Your staff member [firstname] [lastname] had a pending request to attend the below seminar event and has also received this closure email.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.

Below is the message that was sent to the learner:

';
$string['setting:defaultpendingreqclosuremessage'] = 'Default cancellation message sent to the user.';
$string['setting:defaultpendingreqclosuremessage_caption'] = 'Registration closure message';
$string['setting:defaultpendingreqclosuremessagedefault_v9'] = 'This is to advise that your pending booking request for the following seminar event has expired:
This seminar events registration period has closed while your request was pending, please request a booking on a different event.

Course: [coursename]

Seminar: [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultpendingreqclosuresubject'] = 'Default subject line for registration closure emails.';
$string['setting:defaultpendingreqclosuresubject_caption'] = 'registration closure subject';
$string['setting:defaultpendingreqclosuresubjectdefault'] = 'Seminar event registration closure';
$string['setting:defaultregistrationexpiredinstrmngr'] = '
*** Advice only ****

This is to advise that [firstname] [lastname] has been sent the following email and you are listed as their Team Leader / Manager.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.

';
$string['setting:defaultregistrationexpiredinstrmngr_v92'] = '
*** Advice only ****

This is to advise that [firstname] [lastname] has been sent the following email and you are listed as their Team Leader / Manager.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.

Below is the message that was sent to the learner:

';
$string['setting:defaultregistrationexpiredmessagedefault'] = 'The registration period for the following session has been closed:

Course: [coursename]

Face-to-face: [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultregistrationexpiredmessagedefault_v9'] = 'The registration period for the following session has been closed:

Course: [coursename]

Seminar: [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultregistrationexpiredsubjectdefault'] = 'Seminar registration closed: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Default reminder message sent to managers.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Reminder message (managers)';
$string['setting:defaultreminderinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s reminder email is copied below ****';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Reminder only ****

Your staff member [firstname] [lastname] is booked to attend and above course and has also received this reminder email.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.

';
$string['setting:defaultreminderinstrmngrdefault_v92'] = '*** Reminder only ****

Your staff member [firstname] [lastname] is booked to attend and above course and has also received this reminder email.

If you are not their Team Leader / Manager and believe you have received this email by mistake please reply to this email.

Below is the message that was sent to the learner:

';
$string['setting:defaultremindermessage'] = 'Default reminder message sent to users.';
$string['setting:defaultremindermessage_caption'] = 'Reminder message';
$string['setting:defaultremindermessagedefault'] = 'This is a reminder that you are booked on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]
Cost:   [cost]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]

***Please arrive ten minutes before the course starts***

To re-schedule or cancel your booking
To re-schedule your booking you need to cancel this booking and then re-book a new session.  To cancel your booking, return to the site, then to the page for this course, and then select \'cancel\' from the booking information screen.

[details]
';
$string['setting:defaultremindermessagedefault_v9'] = 'This is a reminder that you are booked on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]
Cost:   [cost]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

***Please arrive ten minutes before the course starts***

To re-schedule or cancel your booking
To re-schedule your booking you need to cancel this booking and then re-book a new event.  To cancel your booking, return to the site, then to the page for this course, and then select \'cancel\' from the booking information screen.

[details]
';
$string['setting:defaultremindersubject'] = 'Default subject line for reminder emails.';
$string['setting:defaultremindersubject_caption'] = 'Reminder subject';
$string['setting:defaultremindersubjectdefault'] = 'Face-to-face booking reminder: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindersubjectdefault_v9'] = 'Seminar booking reminder: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking request is copied below ****';
$string['setting:defaultrequestinstrmngrdefault'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as their Team Leader / Manager.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to approve the request:
[attendeeslink]
';
$string['setting:defaultrequestinstrmngrdefault_v24'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as their Team Leader / Manager.

Course:   [seminarname]
Cost:   [cost]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]

Please follow the link below to approve the request:
[attendeeslink]

';
$string['setting:defaultrequestinstrmngrdefault_v92'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as their Team Leader / Manager.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to approve the request:
[attendeeslink]

Below is the message that was sent to the learner:

';
$string['setting:defaultrequestmessagedefault'] = 'Your request to book into the following course has been sent to your manager:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]
Cost:   [cost]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultrequestmessagedefault_v9'] = 'Your request to book into the following course has been sent to your manager:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]
Cost:   [cost]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

This request will expire on [registrationcutoff]
';
$string['setting:defaultrequestsubjectdefault'] = 'Face-to-face booking request: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestsubjectdefault_v9'] = 'Seminar booking request: [seminarname], [eventperiod]';
$string['setting:defaultrolerequestinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s booking request is copied below ****';
$string['setting:defaultrolerequestinstrmngrdefault'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as a [sessionrole] for the session.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to review the request:
[attendeeslink]
';
$string['setting:defaultrolerequestinstrmngrdefault_v92'] = 'This is to advise that [firstname] [lastname] has requested to be booked into the following course, and you are listed as a [sessionrole] for the session.

Please review this request before registration closes on [registrationcutoff]

Follow the link below to review the request:
[attendeeslink]

Below is the message that was sent to the learner:

';
$string['setting:defaultrolerequestmessagedefault'] = 'Your request to book into the following course has been sent to the sessions [sessionrole](s):

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]
Cost:   [cost]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultrolerequestmessagedefault_v9'] = 'Your request to book into the following course has been sent to the sessions [sessionrole](s):

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]
Cost:   [cost]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

This request will expire on [registrationcutoff]
';
$string['setting:defaultrolerequestsubjectdefault'] = 'Seminar booking role request: [seminarname], [eventperiod]';
$string['setting:defaultsessioncancellationinstrmngrcopybelow'] = '*** [firstname] [lastname]\'s session cancellation is copied below ****';
$string['setting:defaultsessioncancellationmessage'] = 'Default session cancellation message sent to the user.';
$string['setting:defaultsessioncancellationmessage_caption'] = 'Session cancellation message';
$string['setting:defaultsessioncancellationmessagedefault'] = 'This is to advise that the following session has been cancelled:

***EVENT CANCELLED***

Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaultsessioncancellationmessagedefault_v9'] = 'This is to advise that the following session has been cancelled:

***EVENT CANCELLED***

Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaultsessioncancellationsubject'] = 'Default subject line for session cancellation emails.';
$string['setting:defaultsessioncancellationsubject_caption'] = 'Event cancellation subject';
$string['setting:defaultsessioncancellationsubjectdefault'] = 'Seminar event cancellation';
$string['setting:defaulttrainerconfirmationmessage'] = 'Default message sent to trainers when assigned to an event.';
$string['setting:defaulttrainerconfirmationmessage_caption'] = 'Trainer confirmation message';
$string['setting:defaulttrainerconfirmationmessagedefault'] = 'This is to confirm that you are now assigned to deliver training on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:    [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]

***Please arrive ten minutes before the course starts***

[details]
';
$string['setting:defaulttrainerconfirmationmessagedefault_v9'] = 'This is to confirm that you are now assigned to deliver training on the following course:

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]

***Please arrive ten minutes before the course starts***

[details]
';
$string['setting:defaulttrainerconfirmationsubject'] = 'Default subject line for trainer confirmation emails.';
$string['setting:defaulttrainerconfirmationsubject_caption'] = 'Trainer confirmation subject';
$string['setting:defaulttrainerconfirmationsubjectdefault'] = 'Face-to-face trainer confirmation: [seminarname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaulttrainerconfirmationsubjectdefault_v9'] = 'Seminar trainer confirmation: [seminarname], [eventperiod]';
$string['setting:defaulttrainersessioncancellationmessage'] = 'Default event cancellation message sent to the trainer.';
$string['setting:defaulttrainersessioncancellationmessage_caption'] = 'Trainer event cancellation message';
$string['setting:defaulttrainersessioncancellationmessagedefault'] = 'This is to advise that your assigned training session the following course has been cancelled:

***SESSION CANCELLED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaulttrainersessioncancellationmessagedefault_v9'] = 'This is to advise that your assigned training event the following course has been cancelled:

***EVENT CANCELLED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaulttrainersessioncancellationsubject'] = 'Default subject line for trainer event cancellation emails.';
$string['setting:defaulttrainersessioncancellationsubject_caption'] = 'Trainer event cancellation subject';
$string['setting:defaulttrainersessioncancellationsubjectdefault'] = 'Face-to-face session trainer cancellation';
$string['setting:defaulttrainersessioncancellationsubjectdefault_v9'] = 'Seminar event trainer cancellation';
$string['setting:defaulttrainersessionunassignedmessage'] = 'Default event unassigned message sent to the trainer.';
$string['setting:defaulttrainersessionunassignedmessage_caption'] = 'Trainer event unassigned message';
$string['setting:defaulttrainersessionunassignedmessagedefault'] = 'This is to advise that you have been unassigned from training for following course:

***SESSION UNASSIGNED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Face-to-face:   [seminarname]

Duration:   [duration]
Date(s):
[alldates]

Location:   [session:location]
Venue:   [session:venue]
Room:   [session:room]
';
$string['setting:defaulttrainersessionunassignedmessagedefault_v9'] = 'This is to advise that you have been unassigned from training for following course:

***EVENT UNASSIGNED***

Participant:   [firstname] [lastname]
Course:   [coursename]
Seminar:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]
';
$string['setting:defaulttrainersessionunassignedsubject'] = 'Default subject line for trainer event unassigned emails.';
$string['setting:defaulttrainersessionunassignedsubject_caption'] = 'Trainer event unassigned subject';
$string['setting:defaulttrainersessionunassignedsubjectdefault'] = 'Face-to-face session trainer unassigned';
$string['setting:defaulttrainersessionunassignedsubjectdefault_v9'] = 'Seminar event trainer unassigned';
$string['setting:defaultundercapacitymessagedefault'] = 'The following event is under minimum bookings:

***EVENT UNDER CAPACITY***

Course:   [coursename]
Seminar:   [seminarname]

Capacity: [booked] / [capacity] (minimum: [mincapacity])

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]';
$string['setting:defaultundercapacitysubjectdefault'] = 'Event under minimum bookings for: [seminarname]';
$string['setting:defaultvalue'] = 'Default value';
$string['setting:defaultvirtualmeetingfailuremessagedefault'] = 'This is to advise that the system failed to create virtual meetings for the following event. Please try again by deleting and recreating these virtual rooms in the event. If the error persists check your connection to the virtual meeting service provider or contact site administrators:


***VIRTUAL MEETING CREATION FAILURE***

Course: [coursename]
Seminar: [facetofacename]

Event times and virtual meeting details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
Room: [session:room:name]
[seminareventdetailslink]
[/sessions]';
$string['setting:defaultvirtualmeetingfailuresubjectdefault'] = 'Virtual meeting creation failure';
$string['setting:defaultwaitlistautocleanmessagedefault'] = 'This is to advise you that your waitlisted signup for the following course has been cancelled due to the event starting:

***WAITLIST CANCELLATION***

Course:   [seminarname]

Details:
[#sessions]
[session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators]
[/sessions]';
$string['setting:defaultwaitlistautocleansubjectdefault'] = 'Waitlisted signup expired';
$string['setting:defaultwaitlistedmessage'] = 'Default wait-listed message sent to users.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Wait-listed message';
$string['setting:defaultwaitlistedmessagedefault'] = 'This is to advise that you have been added to the waitlist for:

Course:   [coursename]
Face-to-face:   [seminarname]
Location:  [session:location]
Participant:   [firstname] [lastname]

***Please note this is not a course booking confirmation***

By waitlisting you have registered your interest in this course and will be contacted directly when sessions become available.

To remove yourself from this waitlist please return to this course and click Cancel waitlist. Please note there is no waitlist removal confirmation email.
';
$string['setting:defaultwaitlistedmessagedefault_v27'] = 'This is to advise that you have been added to the waitlist for:

Course:   [coursename]
Face-to-face:   [seminarname]
Location:  [session:location]
Participant:   [firstname] [lastname]

***Please note this is not a course booking confirmation***

By waitlisting you have registered your interest in this course and will be contacted directly when sessions become available.

To remove yourself from this waitlist please return to this course and click Cancel Booking. Please note there is no waitlist removal confirmation email.
';
$string['setting:defaultwaitlistedmessagedefault_v9'] = 'This is to advise that you have been added to the waitlist for:

Course:   [coursename]
Seminar:   [seminarname]
Participant:   [firstname] [lastname]

Location(s):
[#sessions]
[session:rooms]
[session:facilitators]
[/sessions]

***Please note this is not a course booking confirmation***

By waitlisting you have registered your interest in this course and will be contacted directly when events become available.

To remove yourself from this waitlist please return to this course and click Cancel waitlist. Please note there is no waitlist removal confirmation email.
';
$string['setting:defaultwaitlistedsubject'] = 'Default subject line for wait-listed emails.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Wait-listed subject';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Waitlisting advice for [seminarname]';
$string['setting:defaultwaitlistedsubjectdefault_v9'] = 'Waitlisting advice for [seminarname]';
$string['setting:disableicalcancel'] = 'Check this setting to send event cancellation emails without iCal attachments. Booked users for a cancelled event will receive an 
email, but their calendar won\'t be updated';
$string['setting:disableicalcancel_caption'] = 'Disable iCalendar cancellations:';
$string['setting:displaysessiontimezones'] = 'When enabled, Seminar event times are shown with timezones, and events can be created with custom timezone per session. Otherwise event timezones will be hidden.

<b>Important</b>: Changing this setting will trigger an update of all seminar calendar events. On large-scale sites with lots of seminars this process could take significant time to complete, and affect the site and server performance. For that reason we recommend not changing this setting on production sites.

<b>Warning</b>: Once you start the update process, it will take over your session and you might lose access until the update is completed.';
$string['setting:displaysessiontimezones_caption'] = 'Display event timezones';
$string['setting:hidecost'] = 'Hide the normal cost, discount cost and user discount code fields.';
$string['setting:hidecost_caption'] = 'Hide cost and discount:';
$string['setting:hidediscount'] = 'Hide the discount cost and user discount code fields.';
$string['setting:hidediscount_caption'] = 'Hide discount:';
$string['setting:legacy_notifications'] = 'Use legacy notifications';
$string['setting:legacy_notifications_desc'] = 'Disable modern notifications. Legacy seminar notifications will be used in new seminars instead of modern notifications';
$string['setting:lotteryenabled'] = 'Enable or disable waitlist lottery';
$string['setting:lotteryenabled_caption'] = 'Waitlist lottery';
$string['setting:managerreserve'] = 'Allow reserve/assign';
$string['setting:managerreserve_desc'] = 'Managers are able to make reservations or bookings on behalf of their team members';
$string['setting:managerreserveheader'] = 'Manager reservations';
$string['setting:managerselect_caption'] = 'Users Select Manager';
$string['setting:managerselect_format'] = 'Recommended when manager assignment data is not available. When enabled and an activity requires approval by Manager, the event sign-up page will force users to search for and select a user to approve their request to attend an event each time they sign-up. The selected user will receive a notification about the request and instructions on how to approve or decline it.';
$string['setting:maxmanagerreserves'] = 'Max reservations';
$string['setting:maxmanagerreserves_desc'] = 'The total number of reservations / bookings that a manager can make for their team';
$string['setting:notificationdisable'] = 'When seminars are set to use legacy notifications, this setting will enable and disable legacy notifications and adhoc messages. When seminars are set to modern notifications, this setting will enable and disable adhoc messages only.';
$string['setting:notificationdisable_caption'] = 'Disable legacy notifications';
$string['setting:notificationsheader'] = 'Notifications';
$string['setting:oneemailperday'] = 'If disabled, legacy notifications will be sent as one email containing one ical
which contains all of the sessions, which is not supported by some calendars. For improved calendar compatibility,
enable this setting to send multiple notification emails for multi-session events in seminars which are configured to
use legacy notifications. Note: When enabled, events with more than one session on a single day will generate emails for
every session, while one session spanning over multiple days will generate only one email. This setting does not apply
to centralised notifications, which instead sends just one email containing multiple attachments, one for each session.';
$string['setting:oneemailperday_caption'] = 'One message per date:';
$string['setting:possiblevalues'] = 'List of possible values';
$string['setting:reservecanceldays'] = 'Reservation cancellation days';
$string['setting:reservecanceldays_desc'] = 'The number of days in advance of the event that reservations will be automatically cancelled, if not confirmed.';
$string['setting:reservedays'] = 'Reservation deadline';
$string['setting:reservedays_desc'] = 'The number of days before the event starts after which no more reservations are allowed (must be greater than the cancellation days)';
$string['setting:roomidentifier'] = 'Room identifier';
$string['setting:roomidentifier_help'] = 'Controls the level of detail when displaying rooms as part of seminar events. Note: Room name is always linked to \'Room details\' page with all details.';
$string['setting:selectjobassignmentonsignupglobal'] = 'Select job assignment on signup';
$string['setting:selectjobassignmentonsignupglobal_caption'] = 'When enabled a setting will appear in seminar activity settings to force users with multiple job assignments to choose which capacity they will be signing up on.';
$string['setting:sessionroles'] = 'Users enrolled as the selected roles in a course will become available for these roles in seminar events. If assigned to an event, they will be tracked with that event and receive all notifications sent to \'Users with event roles\'.';
$string['setting:sessionroles_caption'] = 'Event roles:';
$string['setting:sessionrolesnotify'] = 'This setting affects <b>minimum booking</b> and <b>minimum booking cut-off</b> notifications. Make sure you select roles that can manage seminar events. Automated warnings will be sent to all users with selected role(s) in seminar activity, course, category, or system level.';
$string['setting:sessionrolesnotify_caption'] = 'Notification recipients';
$string['setting:showinsummary'] = 'Show in exports and lists';
$string['setting:termsandconditions_caption'] = 'Terms and conditions';
$string['setting:termsandconditions_default'] = 'Check the box to confirm your eligibility to sign up to this seminar.
';
$string['setting:termsandconditions_format'] = 'Text entered in this setting will be the default for the \'Learner accepts terms and conditions\' setting but can be edited for each activity.';
$string['setting:type'] = 'Field type';
$string['showattendeesnote'] = 'Show attendee\'s note';
$string['showbylocation'] = 'Show by location';
$string['showcancelreason'] = 'Show cancellation reason';
$string['showoncalendar'] = 'Calendar display settings';
$string['showpreviousevents:link:all'] = 'show all';
$string['showpreviousevents:link:less'] = 'show less';
$string['showpreviousevents:state:all'] = 'Showing all previous events';
$string['showpreviousevents:state:partial'] = 'Showing events form last {$a} days';
$string['sign-ups'] = 'Sign-ups';
$string['signature'] = 'Signature';
$string['signinsheet'] = 'Sign-in sheet';
$string['signinsheetreport'] = 'Session attendance sheet';
$string['signup'] = 'Sign-up';
$string['signupandaccept'] = 'Agree and submit';
$string['signupandrequest'] = 'Request approval';
$string['signupcustomfieldtab'] = 'Sign-up';
$string['signupdata'] = 'Sign-up data';
$string['signupfields'] = 'Sign-up fields';
$string['signupfieldslimitation'] = 'The values entered below will be populated for all selected users. To enter different values for each user use the <a href="{$a}">file import</a>';
$string['signupfor'] = 'Sign-up for {$a}';
$string['signupforsession'] = 'Sign-up for an available upcoming event';
$string['signupforthissession'] = 'Sign-up for this seminar event';
$string['signupforthissessionlink'] = 'Go to this <a href="{$a}">Seminar event</a>';
$string['signups'] = 'Sign-ups';
$string['signupunavailable'] = 'Sign-up unavailable';
$string['signupworkflowheader'] = 'Sign-up Workflow';
$string['spacesreserved'] = 'Spaces reserved';
$string['startdateafter'] = 'Start date after';
$string['state_actorcanaddattendees_desc'] = 'The current user has capability to add attendees to events';
$string['state_actorcanoverbook_desc'] = 'Current user can overbook event';
$string['state_actorcanoverbook_fail'] = 'You do not have capability to overbook this event';
$string['state_actorcanremoveattendees_desc'] = 'The current user has capability to remove attendees from events';
$string['state_actorcanremoveattendees_fail'] = 'The current user does not have capability to remove attendees from events';
$string['state_actorcansignuppastevents_desc'] = 'The current user has capability to signup on events in progress and past events';
$string['state_actorcansignuppastevents_fail'] = 'The current user does not have capability to signup on events in progress and past events';
$string['state_actorcansurpasssignupperiod_desc'] = 'The current user has capability to signup for events outside Sign-up registration period';
$string['state_actorcansurpasssignupperiod_fail'] = 'The current user does not have capability to signup for events outside Sign-up registration period';
$string['state_actorhasrole_desc'] = 'The current user has the approval role for the event';
$string['state_actorisadmin_desc'] = 'The current user is an administrator for the event';
$string['state_actorisadmin_fail'] = 'The current user is not an administrator for the event';
$string['state_actorismanager_desc'] = 'The current user is the manager for the signup user';
$string['state_actorismanager_fail'] = 'The current user is not the manager when expected';
$string['state_approvaladminnotrequired_desc'] = 'Administrator approval is not required';
$string['state_approvaladminrequired_desc'] = 'Administrator approval is required';
$string['state_approvalnotrequired_desc'] = 'Approval is not required';
$string['state_approvalrequired_desc'] = 'Approval is required';
$string['state_bookingcommon_desc'] = 'Common booking conditions must be met';
$string['state_eventallowscancellations_desc'] = 'Seminar event allows cancellations';
$string['state_eventallowscancellations_fail'] = 'Seminar event does not allow cancellations';
$string['state_eventhascapacity_desc'] = 'The event has capacity for more signups';
$string['state_eventhasnocapacity_desc'] = 'The event is at or exceeding capacity';
$string['state_eventhasnosession_desc'] = 'The event has no session(s)';
$string['state_eventhasroleapprover_desc'] = 'The event must have role approver for signup';
$string['state_eventhasroleapprover_fail'] = 'This seminar requires role approver but event has no role approver. Please contact administrator.';
$string['state_eventhassession_desc'] = 'The event has session(s)';
$string['state_eventinthefuture_desc'] = 'The event starts in the future';
$string['state_eventinthefuture_fail'] = 'The event has already started';
$string['state_eventinthepast_desc'] = 'The event has already finished';
$string['state_eventinthepast_fail'] = 'The event has not finished yet';
$string['state_eventiscancelled_desc'] = 'The event is cancelled';
$string['state_eventiscancelled_fail'] = 'The event is not cancelled when it is expected to be';
$string['state_eventisnotcancelled_desc'] = 'The event is not cancelled';
$string['state_eventnotinthepast_desc'] = 'Event is started or has no dates, or user has permission to signup for events in the past';
$string['state_eventregistrationisavailable_desc'] = 'We are currently within the registration period of the event, as definied by the registrationtimestart and registrationtimefinish settings';
$string['state_eventregistrationisavailable_failstart'] = 'The sign-up period for the event has not been open yet';
$string['state_eventtakingattendance_desc'] = 'The event taking attendance has started';
$string['state_eventtakingattendance_fail'] = 'The event taking attendance has not started yet';
$string['state_hasmanager_desc'] = 'Seminar requires user to have a manager during signup.';
$string['state_hasrequiredjobassignment_desc'] = 'Seminar requires user must have job assignment selected during sign up.';
$string['state_hassignupcapability_desc'] = 'User must have "mod/facetoface:signup" capability or seminar enrolment module is enabled for course';
$string['state_isnotreservation_desc'] = 'Signup is not reservation';
$string['state_isreservation_desc'] = 'Signup is reservation';
$string['state_multisignup_common_desc'] = 'Check whether the user is signed up for multiple events in the same seminar';
$string['state_multisignup_exceeded_fail'] = 'Learner sign-up limit for this seminar was reached.';
$string['state_multisignup_restricted_fail'] = 'Attendance in other events restrict booking this event.';
$string['state_noothersignups_desc'] = 'User must not have active signups in other events of the same activity, unless multiple signups is enabled for the event.';
$string['state_signup_awaits_approval_desc'] = 'The user\'s signup is waiting for approval';
$string['state_signup_awaits_approval_fail'] = 'The user\'s signup is not waiting for approval';
$string['state_signup_not_archived_desc'] = 'The user does not hold an archived sign-up record for the seminar event';
$string['state_signup_not_archived_fail'] = 'The user holds an archived sign-up record for the seminar event';
$string['state_userhasmanager_desc'] = 'The signup user must have a manager';
$string['state_userhasnoconflicts_desc'] = 'The signup user does not have conflicting signups';
$string['state_userhasnoconflicts_fail'] = 'The signup user has conflicting signups';
$string['state_userisenrolable_desc'] = 'The user being signed up can be enrolled on the course';
$string['state_userisenrolable_fail'] = 'User is not enrolled and cannot be enrolled by signing up to the seminar event';
$string['state_waitlistcommon_desc'] = 'Common waitlist conditions must be met';
$string['state_waitlistenabled_desc'] = 'The event has the waitlist enabled';
$string['state_waitlisteveryonedisabled_desc'] = 'The waitlist everyone setting is disabled either globally or locally for the event';
$string['state_waitlisteveryoneenabled_desc'] = 'The waitlist everyone setting is enabled both globally and locally for the event';
$string['statemessage_declined'] = 'Your request to attend this event has been declined.';
$string['statemessage_user_cancelled'] = 'Your signup to the event has been cancelled.';
$string['status'] = 'Status';
$string['status_approved'] = 'Approved';
$string['status_attended'] = 'Attended';
$string['status_booked'] = 'Booked';
$string['status_capacity_waitlisted'] = '{$a} on waitlist';
$string['status_declined'] = 'Declined';
$string['status_event_cancelled'] = 'Event Cancelled';
$string['status_events_in_progress'] = 'Events in progress';
$string['status_fully_attended'] = 'Fully attended';
$string['status_no_show'] = 'No show';
$string['status_not_set'] = 'Not set';
$string['status_partially_attended'] = 'Partially attended';
$string['status_past_events'] = 'Past events';
$string['status_pending_requests'] = 'Pending Requests';
$string['status_requested'] = 'Requested';
$string['status_requestedadmin'] = 'Requested (2step)';
$string['status_requestedrole'] = 'Requested';
$string['status_unable_to_attend'] = 'Unable to attend';
$string['status_upcoming_events'] = 'Upcoming events';
$string['status_user_cancelled'] = 'User Cancelled';
$string['status_waitlisted'] = 'On waitlist';
$string['subject'] = 'Change in booking in the course {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Submissions';
$string['submit'] = 'Submit';
$string['submitcsvtext'] = 'Submit CSV text';
$string['submitted'] = 'Submitted';
$string['successfullyaddededitedxattendees'] = 'Successfully added/edited {$a} attendees.';
$string['successfullyremovedxattendees'] = 'Successfully removed {$a} attendees.';
$string['summary'] = 'Summary';
$string['suppressccmanager'] = 'Suppress notifications to manager about added and removed attendees';
$string['suppressemail'] = 'Suppress email notification';
$string['suppressemailforattendees'] = 'Suppress the confirmation and calendar invite emails for newly added attendees and the cancellation emails for removed attendees';
$string['takeattendance'] = 'Take attendance';
$string['takeattendance_label'] = '{$a}\'s attendance';
$string['takeattendance_tick'] = 'Select {$a}';
$string['takeattendance_tickall'] = 'Select all attendees';
$string['template'] = 'Template';
$string['templateadminrequest'] = 'Booking admin request';
$string['templateallreservationcancel'] = 'All reservations cancelled';
$string['templatecancellation'] = 'Cancellation';
$string['templateconfirmation'] = 'Booking request confirmation';
$string['templatecontainsoldplaceholders'] = 'This template contains a deprecated placeholder';
$string['templatedecline'] = 'Booking request declined';
$string['templatefacilitatorassigned'] = 'Facilitator assigned';
$string['templatefacilitatorcancel'] = 'Session cancellation (facilitator)';
$string['templatefacilitatortimechange'] = 'Session time changed (facilitator)';
$string['templatefacilitatorunassigned'] = 'Facilitator unassigned';
$string['templatemanagerrequest'] = 'Booking manager request';
$string['templatereminder'] = 'Reminder';
$string['templatereservationcancel'] = 'Reservation cancelled';
$string['templaterolerequest'] = 'Booking role request';
$string['templatesoldplaceholders'] = 'Some templates contain deprecated placeholders. Please review the templates marked with a warning icon and update where necessary.';
$string['templatetimechange'] = 'Time changed';
$string['templatetrainercancel'] = 'Trainer cancelled';
$string['templatetrainerconfirm'] = 'Trainer confirmed';
$string['templatetrainerunassign'] = 'Trainer unassigned learner';
$string['templatewaitlist'] = 'Waitlisted';
$string['tenantmemberisolationmode'] = 'Tenant isolation enabled. Members cannot attend events outside their tenant domain.';
$string['thirdpartyemailaddress'] = 'Third-party email address(es)';
$string['thirdpartywaitlist'] = 'Notify third-party about wait-listed events';
$string['thissession'] = 'This event';
$string['time'] = 'Time';
$string['timeandtimezone'] = 'Time and Time Zone';
$string['timecancelled'] = 'Time Cancelled';
$string['timedue'] = 'Registration deadline';
$string['timefinish'] = 'Finish time';
$string['timerequested'] = 'Time Requested';
$string['timesignedup'] = 'Time Signed Up';
$string['timestampbyuser'] = '{$a->time} by {$a->user}';
$string['timestart'] = 'Start time';
$string['timezoneformat'] = 'Timezone: {$a}';
$string['timezoneupgradeinfomessage'] = 'WARNING : This upgrade to seminar adds the ability to specify the timezone in which a seminar event will occur.<br /><br />It is <b>strongly</b> recommended that you check the event timezones, start times and end times for all upcoming seminar events that were created prior to this upgrade.';
$string['title'] = 'Title';
$string['tutor'] = 'Tutor';
$string['type'] = 'Type';
$string['unapprovedrequests'] = 'Unapproved Requests';
$string['unavailable'] = 'Unavailable';
$string['unavailablenotifications'] = 'This seminar has unavailable notifications.<br/><a href=\'{$a->url1}\'>Restore them for this seminar only</a> or go to <a href=\'{$a->url2}\'>Manage notification templates</a> to restore them for all seminars.';
$string['unavailableplugin'] = '(Unavailable)';
$string['unavailabletemplates'] = '{$a} notification templates below are <strong>unavailable</strong> to any seminars created in an older version of this product. Please review and restore where necessary.';
$string['undo'] = 'Undo';
$string['unknowndate'] = '(unknown date)';
$string['unknowntime'] = '(unknown time)';
$string['upcoming'] = 'Upcoming';
$string['upcomingsessions'] = 'Upcoming events';
$string['upcomingsessionsinasset'] = 'Upcoming sessions using this asset';
$string['upcomingsessionsinfacilitator'] = 'Upcoming sessions using this facilitator';
$string['upcomingsessionsinroom'] = 'Upcoming sessions in this room';
$string['upcomingsessionsinroomlist'] = 'A list of upcoming sessions taking place in this room';
$string['upcomingsessionslist'] = 'List of all upcoming events for this seminar activity';
$string['updateactivities'] = 'Update all activities';
$string['updateactivities_help'] = 'When checked any saved content changes will update the corresponding content of all seminar activities which have notifications using this template.

The \'status\' of seminar activity notifications will not be affected.

Seminar activity notifications whose title or content has been customised will not be affected.';
$string['updateactivitieswarning'] = '<b>Warning:</b> When checked any saved content changes will update the corresponding content of all seminar activities which have notifications using this template. The \'status\' of seminar activity notifications will not be affected.';
$string['updateattendeessuccessful'] = 'Successfully updated attendance';
$string['updateattendeesunsuccessful'] = 'An error has occurred, attendance could not be updated';
$string['updatejobassignment'] = 'Update job assignment';
$string['updaterequests'] = 'Update requests';
$string['updatewaitlist'] = 'Update waitlist';
$string['upgradefixstatusapprovedlimbousersdescription'] = 'Learners with an invalid seminar signup status were detected.
The following learners were removed from events:<br>{$a}';
$string['upgradefixstatusapprovedlimbousersdetail'] = '{$a->user} was removed from seminar {$a->f2f}';
$string['upgradeprocessinggrades'] = 'Processing seminar grades, this may take a while if there are many events...';
$string['uploadattendance'] = 'Upload event attendance';
$string['uploadattendance_help'] = 'Preparing a file for upload: Use .CSV text file with a heading row and one or more data rows.

All rows must have the following columns:

* **\'username\'** OR **\'idnumber\'** OR **\'email\'** OR **\'signupid\'** (use only one)
* **\'eventattendance\'** - one of the following codes:
 * 4 - Fully attended
 * 3 - Partially attended
 * 2 - Unable to attend
 * 1 - No show

Optional column: **\'eventgrade\'** - a number between 0 - 100';
$string['uploadattendanceresults'] = 'Upload event attendance and grades results';
$string['uploadattendancereview'] = 'Review and confirm changes ({$a} records)';
$string['uploadattendancestep'] = 'Upload event attendance and grades (step {$a} of 2)';
$string['uploadcsvfile'] = 'Upload CSV file';
$string['uploadfile'] = 'Upload file';
$string['usercalentry'] = 'Show entry on user\'s calendar';
$string['usercancellationnoteheading'] = '{$a} - Cancellation note';
$string['usercancelled'] = 'User cancellation';
$string['usercancelledon'] = 'User cancelled on {$a}';
$string['userdataitemcustomfields'] = 'Sign-up and cancellation custom fields';
$string['userdataitemfacilitator'] = 'Facilitator records';
$string['userdataitemfacilitator_customfields'] = 'Facilitator custom fields';
$string['userdataiteminterest'] = 'Declared interest';
$string['userdataitemroom_virtualmeeting'] = 'Virtual meeting rooms created by the user';
$string['userdataitemsignups'] = 'Attendance records including Sign-up and User cancellation custom fields';
$string['userdatapurgedcancel'] = 'User data has been purged';
$string['userdeletedcancel'] = 'User has been deleted';
$string['userdoesnotexist'] = 'User with {$a->fieldname} "{$a->value}" does not exist';
$string['useriddoesnotexist'] = 'User with ID "{$a}" does not exist';
$string['userjobassignmentheading'] = '{$a} - update selected job assignment';
$string['usernote'] = 'Sign-up note';
$string['usernoteheading'] = '{$a} - update note';
$string['usernoteheadingarchived'] = '{$a} - view note';
$string['usernoteupdated'] = 'Attendee\'s note updated';
$string['usernotsignedup'] = 'Status: not signed up';
$string['useroomcapacity'] = 'Use room capacity';
$string['usersignedup'] = 'Status: signed up';
$string['usersignedupmultiple'] = 'User signed up on {$a} events';
$string['usersignedupon'] = 'User signed up on {$a}';
$string['userstoadd'] = 'Users to add';
$string['userstoaddcomment'] = 'Enter one user per line:';
$string['userstobeadded'] = 'Users to be added';
$string['userstoremove'] = 'Users to remove';
$string['usersuspendedcancel'] = 'User has been suspended';
$string['userwillbewaitlisted'] = 'This event is currently full. Upon successful sign-up, you will be placed on the event\'s waitlist.';
$string['validation:needatleastonedate'] = 'You need to provide at least one date, or else mark the event as wait-listed.';
$string['venue'] = 'Venue';
$string['versioncontrol'] = 'Version control';
$string['viewallassets'] = 'Manage assets';
$string['viewallfacilitators'] = 'Manage facilitators';
$string['viewallrooms'] = 'Manage rooms';
$string['viewallsessions'] = 'View all events';
$string['viewasset'] = 'View asset';
$string['viewattendees'] = 'View attendees';
$string['viewdetails'] = 'View details';
$string['viewfacilitator'] = 'View facilitator';
$string['viewresults'] = 'View results';
$string['viewroom'] = 'View room';
$string['viewsubmissions'] = 'View submissions';
$string['virtual_meeting'] = 'Virtual meeting';
$string['virtual_meeting_add'] = 'Add virtual room link';
$string['virtual_meeting_connect'] = 'Connect';
$string['virtual_meeting_date_locked'] = 'This session uses a virtual room that you do not have control of';
$string['virtual_meeting_disconnect'] = 'Disconnect';
$string['virtual_meeting_failed'] = 'Failed to sync with virtual meeting provider. Please try again.';
$string['virtual_meeting_not_owner'] = 'You are not the owner of the {$a} virtual room';
$string['virtual_meeting_service_provider'] = 'Service provider account';
$string['virtual_meetings'] = 'Virtual meetings';
$string['virtualroom_banner_retry'] = 'Failed to update the virtual room. <a href="{$a}">Please click to assign the room again.</a>';
$string['virtualroom_card_over'] = 'Virtual room is no longer available';
$string['virtualroom_card_preparing'] = 'Updating virtual room';
$string['virtualroom_card_unavailable'] = 'Virtual room is unavailable';
$string['virtualroom_card_wait'] = 'Please wait…';
$string['virtualroom_card_willopen'] = 'Virtual room will open 15 minutes before next session';
$string['virtualroom_creator'] = 'Virtual room creator';
$string['virtualroom_details_seminar'] = 'Seminar';
$string['virtualroom_details_session_time'] = 'Session time';
$string['virtualroom_heading'] = 'Virtual room';
$string['virtualroom_headingx'] = 'Virtual room: {$a}';
$string['visible'] = 'Visible';
$string['wait-list'] = 'Wait-list';
$string['wait-listed'] = 'Wait-listed';
$string['waitlistautoclean'] = 'Clear expired waitlists';
$string['waitlistautoclean_help'] = 'The waitlist for events gets cleared when they start, allowing users to signup to a new event. The "Waitlisted signup expired" notification can be used to inform users about this happening.';
$string['waitlistedmessage'] = 'Wait-listed message';
$string['waitlisteveryone'] = 'Send all bookings to the waiting list';
$string['waitlisteveryone_help'] = 'Everyone who signs up for this event will be added to the waiting list.';
$string['waitlistselectoneormoreusers'] = 'Please select one or more users to update';
$string['warning:meetingmaynotbepreserved'] = 'Editing this session may reset virtual room settings with the external provider. For example, who can present or bypass the lobby. Please check the meeting settings with your provider to ensure they are still correct after editing.';
$string['xerrorsencounteredduringimport'] = '{$a} problem(s) encountered during import.';
$string['xhours'] = '{$a} hour(s)';
$string['xmessagesfailed'] = '{$a} message(s) failed to send';
$string['xmessagessenttoattendees'] = '{$a} message(s) successfully sent to attendees';
$string['xmessagessenttoattendeesandmanagers'] = '{$a} message(s) successfully sent to attendees and their managers';
$string['xminutes'] = '{$a} minute(s)';
$string['xusers'] = '{$a} user(s)';
$string['youarebooked'] = 'You are booked for the following event';
$string['yourbookings'] = 'Your bookings / reservations';
$string['youremailaddress'] = 'Your email address';
$string['youwillbeaddedtothewaitinglist'] = 'Please Note: You will be added to the waiting list for this event';

/**
 * Help Text
 */
$string['allowoverbook_help'] = 'When **Enable waitlist** is checked, learners will be able to sign up for a seminar event even if it is already full.

When a learner signs up for an event that is already full, they will receive an email advising that they have been waitlisted for the event and will be notified when a booking becomes available.';
$string['approvalreqd_help'] = 'When **Approval required** is checked, a learner will need approval from their manager to be permitted to attend a seminar event.';
$string['cancellationinstrmngr'] = '# Notice for manager';
$string['cancellationinstrmngr_help'] = 'When **Send notice to manager** is checked, the text in the **Notice for manager** field is sent to a learner\'s manager advising that they have cancelled a seminar booking.';
$string['cancellationmessage_help'] = 'This message is sent out whenever users cancel their booking for an event.';
$string['confirmationinstrmngr'] = '# Notice for manager';
$string['confirmationinstrmngr_help'] = 'When **Send notice to manager** is checked, the text in the **Notice for manager** field is sent to a manager advising that a staff member has signed up for a seminar event.';
$string['confirmationmessage_help'] = 'This message is sent out whenever users sign up for an event.';
$string['description_help'] = '**Description** is the course description that displays when a learner enrols on a seminar event.

The **Description** also displays in the training calendar.';
$string['details_help'] = 'Details are tracked per event basis.
If text is populated in the details field, the details text will be displayed on the user signup page.
By default, the details text also appears in the confirmation, reminder, waitlist, and cancellation email messages.';
$string['discountcode_help'] = 'Discount code is the code required for the discount cost to be tracked for the training of a staff member.
If the staff member does not enter the discount code, the normal cost appears in the training record.';
$string['discountcodelearner'] = 'Discount Code';
$string['discountcodelearner_help'] = 'If you know the discount code enter it here. If you leave this field blank you will be charged the normal cost for this event.';
$string['discountcost_help'] = 'Discount cost is the amount charged to staff members who have a membership ID.';
$string['duration_help'] = '**Duration** is the total length of the training in hours.
If the training occurs over two or more time periods, the duration is the combined total.
If the session date is known then this value is automatically recalculated when the session is saved.';
$string['emailmanagercancellation'] = '# Send notice to manager';
$string['emailmanagercancellation_help'] = 'When **Send notice to manager** is checked, an email will be sent to the learner\'s manager advising them that the seminar booking has been cancelled.';
$string['emailmanagerconfirmation'] = '# Send notice to manager';
$string['emailmanagerconfirmation_help'] = 'When **Send notice to manager** is checked, a confirmation email will be sent to the learner\'s manager when the learner signs up for a seminar event.';
$string['emailmanagerreminder'] = '# Send notice to manager';
$string['emailmanagerreminder_help'] = 'When **Send notice to manager** is checked, a reminder message will be sent to the learner\'s manager a few days before the start date of the seminar event.';
$string['location_help'] = '**Location** describes the vicinity of the event (city, county, region, etc).

**Location** displays on the course page, **Sign-up page**, the **View all events** page, and in all email notifications.

On the **View all events** page, the listed events can be filtered by location.';
$string['mods_help'] = 'Seminar activities are used to keep track of in-person trainings which require advance booking.

Each activity is offered in one or more identical events. These events can be given over multiple days.

Reminder messages are sent to users and their managers a few days before the event is scheduled to start. Confirmation messages are sent when users sign-up for an event or cancel.';
$string['modulename_help'] = 'The seminar activity module enables a trainer to set up a booking system for one or many in-person/classroom based events.

Each event within a seminar activity can have customised settings around room, start time, finish time, cost, capacity, etc. These can be set to run over multiple days or allow for unscheduled and waitlisted events.

An Activity may be set to require manager approval and trainers can configure automated notifications and event reminders for attendees.

learners can view and sign-up for events with their attendance tracked and recorded within the Grades area.';
$string['multisignupamount'] = 'How many times the user can sign-up?';
$string['multisignupamount_help'] = 'Limits the total number of sign-ups a user can have within the seminar. A value of 1 for this setting disables multiple signups. Note: This setting does not take cancelled sign-ups into consideration.';
$string['multisignupamount_unlimited'] = 'Unlimited';
$string['multisignupfailure_common'] = 'Existing sign-up(s) for this seminar';
$string['multisignupfailure_limitation'] = ', have already reached the maximum of {$a} signup(s)';
$string['multisignupfailure_restriction'] = ', are not in the required attendance state(s)';
$string['multisignuprestrict'] = 'Restrict subsequent sign-ups to';
$string['multisignuprestrict_desc'] = 'Restrict subsequent sign-ups based on the state of previous signups. Enabling any of these state restrictions will limit users to a single concurrent sign-up within a single seminar, as they will not be able to sign-up to another event until their current sign-up has its attendance set to one of the selected states. If none of these restrictions are enabled users can have as many concurrent sign-ups within the seminar as the maximum limitation allows. Note: Cancelled signups are not taken into consideration.';
$string['multisignuprestrict_help'] = 'Restrict subsequent sign-ups based on the state of previous signups. Enabling any of these state restrictions will limit users to a single concurrent sign-up within the seminar, as they will not be able to sign-up to another event until their current sign-up has its attendance set to one of the selected states. If none of these restrictions are enabled users can have as many concurrent sign-ups within the seminar as the maximum limitation allows. Note: Cancelled signups are not taken into consideration.';
$string['normalcost_help'] = 'Normal cost is the amount charged to staff members who do not have a membership ID.';
$string['notificationtype_help'] = 'Notification Type allows the learner to select how they would like to be notified of their booking.

* Email notification and iCalendar appointment.
* Email notification only.
* No Email notification.';
$string['not_attended'] = 'Not attended';
$string['recipients_help'] = 'Use this setting to target learners based on their status.

Booking status:<br>Past events, events in progress, upcoming events.

Attendance status:<br>Fully attended, partially attended, unable to attend, no show.

Other:<br>On waitlist, cancelled, pending requests.';
$string['reminderinstrmngr'] = '# Notice for Manager';
$string['reminderinstrmngr_help'] = 'When **Send notice to manager** is checked, the text in the **Notice for Manager** field is sent to a learner\'s manager advising that they have signed up for a seminar event.';
$string['remindermessage_help'] = 'This message is sent out a few days before an event\'s start date.';
$string['requestapproval'] = 'Request approval';
$string['requestmessage_help'] = 'When **Approval required** is enabled, the **Request message** section is available.

The **Request message** section displays the notices sent to the learner and their manager regarding the approval process for the learner to attend the seminar event.

* **Subject:** Is the subject line that appears on the request approval emails sent to the manager and the learner.
* **Message:** Is the email text sent to the learner advising them that their request to attend the seminar event has been sent to their manager for approval.
* **Notice for manager:** Is the email text sent to the learner\'s manager requesting approval to attend the seminar event.';
$string['room_help'] = '**Room** is the name/number/identifier of the room being used for the training event.

The **Room** displays on the **Sign-up** page, the **View all events** page, and in all email notifications.';
$string['sessionsoncoursepage_help'] = 'This is the number of events for each seminar activity that will be shown on the main course page.';
$string['shortname'] = 'Short Name';
$string['shortname_help'] = '**Short name** is the description of the event that appears on the training calendar when **Show on the calendar** is enabled.';
$string['showoncalendar_help'] = 'When **Site** is selected the seminar activity events will be displayed on the site calendar as a Global Event.  All site users will be able to view these events.

When **Course** is selected all of the seminar activity events will be displayed on the course calendar and as Course Event on the site level calendar and visible to all users enrolled in the course.

When **None** is selected, seminar activity events will only be displayed as User Events on a confirmed attendee\'s calendar, provided the **Show on user\'s calendar** option has been selected.';
$string['suppressemail_help'] = 'Use this option if you want to silently add/remove users from a seminar event. When this option is toggled, the usual email confirmation is not sent to the selected users.';
$string['thirdpartyemailaddress_help'] = '**Third-party email address(es)** is an optional field used to specify the email addresses of third-parties (such as external instructors) who will then receive notifications for this seminar\'s events.

Multiple email addresses must be comma separated. For example: one@example.com,two@example.com.

* For legacy seminar notifications, third-party emails will receive a **manager copy of all active notifications** for this seminar\'s events.
* If you are using the modern notifications system, **you must go to Notifications and create dedicated notifications** for these recipients.';
$string['thirdpartywaitlist_help'] = 'When **Notify third-party about wait-listed events** is selected the third-party(s) will be notified when a learner signs up for a wait-listed event. When

**Notify third-party about wait-listed events** is not enabled third-party(s) will only be notified when a user signs up (or cancels) for a scheduled event.';
$string['timefinish_help'] = 'Finish time is the time when the event ends.';
$string['timestart_help'] = 'Start time is the time when the event begins.';
$string['usercalentry_help'] = 'When active this setting adds a User Event entry to the calendar of an attendee of a seminar event. When turned off this prevents a duplicate event appearing in an event attendee\'s calendar, where you have calendar display settings set to Course or Site.';
$string['useridentifier'] = 'User identifier';
$string['usernote_help'] = 'Any specific requirements that the event organiser might need to know about:

* Dietary requirements.
* Disabilities.';
$string['venue_help'] = '**Venue** is the building the event will be held in.

The **Venue** displays on the **Sign-up** page, the **View all events** page and in all email notifications.';
$string['waitlistedmessage_help'] = 'This message is sent out whenever users sign-up for a wait-listed event.';

/**
 * Totara Messaging strings
 */
$string['approveinstruction'] = 'To approve event registration, press accept';
$string['bookedforsession'] = 'Booked for event {$a}';
$string['cancelledforsession'] = 'Cancelled for event {$a}';
$string['cancelusersession'] = 'Cancelled for {$a->usermsg} event {$a->url}';
$string['nosignupperiodclosedate'] = 'Session start date';
$string['nosignupperiodopendate'] = 'Now';
$string['registrationclosed'] = 'Booking closed';
$string['registrationclosedalert'] = 'The Sign-up period for your selected session has closed, please select another session';
$string['registrationcloses'] = 'Closes';
$string['registrationclosingblurb'] = 'The following people have indicated their interest. You may wish to inform them if you create a new session.';
$string['registrationclosingconfirmation'] = 'Are you sure you want to close the sign-up period for this session?';
$string['registrationdatetime'] = 'Sign-up period date/time';
$string['registrationdetails'] = 'Sign-up period';
$string['registrationerrorstartfinish'] = 'Sign-up period start time must be before sign-up finish time';
$string['registrationfinishsession'] = 'Sign-up period closing time must be on or before session start time';
$string['registrationhoverhintend'] = 'Sign-up period closes: {$a->enddate}, {$a->endtime}';
$string['registrationhoverhintendtz'] = 'Sign-up period closes: {$a->enddate}, {$a->endtime} (time zone: {$a->timezone})';
$string['registrationhoverhintstart'] = 'Sign-up period opens: {$a->startdate}, {$a->starttime}';
$string['registrationhoverhintstarttz'] = 'Sign-up period opens: {$a->startdate}, {$a->starttime} (time zone: {$a->timezone})';
$string['registrationnotopen'] = 'Booking not open';
$string['registrationnotopenalert'] = 'The Sign-up period for your selected session is currently not open, it opens {$a}';
$string['registrationopens'] = 'Opens';
$string['registrationstartsession'] = 'Sign-up period opening time must be before session start time';
$string['registrationtimefinish'] = 'Sign-up closes';
$string['registrationtimefinish_help'] = 'If enabled, learners will not be able to sign up for this session and managers will not be able to approve once this time has passed.';
$string['registrationtimestart'] = 'Sign-up opens';
$string['registrationtimestart_help'] = 'If enabled, learners will not be able to sign up for this session and managers will not be able to approve until this time has arrived.';
$string['rejectinstruction'] = 'To reject event registration, press reject';
$string['requestattendsession'] = 'Request to attend session {$a}';
$string['requestattendsession_message'] = 'Request to attend event {$a->linkname} {$a->status}';
$string['requestattendsession_subject'] = 'Request to attend event {$a->name} {$a->status} by {$a->user}';
$string['requestattendsessionsent'] = 'Request to attend event {$a} sent to manager';
$string['requestuserattendsession'] = 'Request for {$a->usermsg} to attend event {$a->url}';
$string['sessiondate_help'] = 'Session is the date on which the event occurs.';
$string['showallpreviousevents'] = 'Show all previous events';
$string['signupenddateandtimeonlywithouttimezone'] = 'Before {$a->enddate}, {$a->endtime}';
$string['signupendsonly'] = 'Before {$a->enddate}';
$string['signupexpired'] = 'Sending expired sign-up period date notifications to the admin user of that session';
$string['signupperiodheader'] = 'Sign-up period';
$string['signupregistrationclosed'] = 'The sign-up period for your selected session closed {$a->date}, {$a->time} {$a->timezone}.';
$string['signupregistrationnotyetopen'] = 'The sign-up period for your selected session is currently not open, it opens {$a->date}, {$a->time} {$a->timezone}.';
$string['signupstartdateandtimeonlywithouttimezone'] = 'After {$a->startdate}, {$a->starttime}';
$string['signupstartend'] = '{$a->startdate} to {$a->enddate}';
$string['signupstartsonly'] = 'After {$a->startdate}';
$string['waitlistautocleantask'] = 'Clear the waitlist for seminar events after the event has started';
$string['waitlistcancellationconfirm'] = 'Are you sure you want to cancel your place on the waiting list for this event?';
$string['waitlistcancelled'] = 'Your place on the waitlist has been cancelled.';
$string['waitlistedforsession'] = 'Waitlisted for event {$a}';
$string['waitlistfor'] = 'Waitlist for {$a}';
$string['waitliststatus'] = 'You have a place on the waitlist of the following event';
$string['warning:mixedapprovaltypes'] = 'This seminar was previously using mixed approval types, it is currently set to manager approval. Please check all self approval sessions.';

/**
 * Deprecated since Totara 13.0
 */
$string['attendanceinstructions'] = 'Select users who attended the event:';
$string['attendancetime'] = 'Mark attendance at';
$string['attendancetime_any'] = 'Any time (unrestricted)';
$string['attendancetime_end'] = 'Event / session end time';
$string['attendancetime_help'] = 'Unlock attendance marking for trainers 15 minutes prior to event / session start time, end time, or any time (unrestricted).';
$string['attendancetime_start'] = 'Event / session start time';
$string['chooseroom'] = 'Choose a room';
$string['currentstatus'] = 'Current status';
$string['moreinfo'] = 'More info';
$string['publishreuse'] = 'Publish for reuse by other events';
$string['seeattendees'] = 'See attendees';
$string['selectroom'] = 'Select room';
$string['sessionattendance'] = 'Session attendance tracking';
$string['sessionattendance_help'] = 'Track learners attendance on a per session basis as well as a per event basis.';
$string['state_eventhassession_fail'] = 'Event does not have session';
$string['state_multisignup_enabled_fail'] = 'Existing sign-up(s) for this seminar';
$string['state_multisignup_limitation_fail'] = ', have already reached the maximum of {$a} signup(s)';
$string['state_multisignup_restriction_fail'] = ', are not in the required attendance state(s)';

/**
 * Deprecated since Totara 9.0
 */
$string['addmanageremailaddress'] = 'Add manager email address';
$string['addmanageremailinstruction'] = 'You have not previously entered your manager\'s email address. Please enter it below to sign-up for this event. ';
$string['addnewnotice'] = 'Add a new site notice';
$string['addnewnoticelink'] = 'Create a new site notice';
$string['allowsignupnotedefault'] = 'Default &lsquo;Users can enter requests when signing up&rsquo; setting';
$string['allowsignupnotedefault_help'] = 'Whether events in this activity will allow a sign-up note by default, can be overridden in the event settings.';
$string['availablesignupnote'] = 'Users can enter requests when signing up';
$string['availablesignupnote_help'] = 'When **Users can enter requests when signing up** is checked, learners will be able to enter any specific requirements that the event organiser might need to know about:

* Dietary requirements.
* Disabilities.';
$string['bulkaddattendeesfromfile'] = 'Bulk add attendees from file';
$string['bulkaddattendeesfrominput'] = 'Bulk add attendees from text input';
$string['bulkaddheading'] = 'Bulk Add';
$string['calendarfiltersheading'] = 'Seminar calendar filters';
$string['changemanageremailaddress'] = 'Change manager email address';
$string['changemanageremailinstruction'] = 'Please enter the email address for your current manager below.';
$string['conditions'] = 'Conditions';
$string['conditionsexplanation'] = 'All of these criteria must be met for the notice to be shown on the training calendar:';
$string['confirmmanageremailaddress'] = 'Confirm manager email address';
$string['confirmmanageremailaddressquestion'] = 'Is <strong>{$a}</strong> still your manager\'s email address?';
$string['confirmmanageremailinstruction1'] = 'You previously entered the following as your manager\'s email address:';
$string['confirmmanageremailinstruction2'] = 'Is this still your manager\'s email address?';
$string['costheading'] = 'Session Cost';
$string['error:couldnotupdatemanageremail'] = 'Could not update manager email address.';
$string['error:emptymanageremail'] = 'Manager email address empty.';
$string['error:mismatchdatesdetected'] = 'Mismatch in dates detected. Start time and finish time should be provided for each date.';
$string['error:nodatesfound'] = 'No dates found';
$string['error:nomanageremail'] = 'You didn\'t provide an email address for your manager';
$string['error:nopositionselected'] = 'You must have a suitable position assigned to sign up for this seminar event.';
$string['error:nopositionselectedactivity'] = 'You must have a suitable position assigned to sign up for this seminar activity.';
$string['error:nostatetransitionfound'] = 'There is no direct way to change signup status to required state';
$string['eventattendeepositionupdated'] = 'Attendee position updated';
$string['exportheading'] = 'Export';
$string['facetoface:changesignedupjobposition'] = 'Change signed up job position';
$string['forceselectposition'] = 'Prevent signup if no position is selected or can be found';
$string['icalendarheading'] = 'iCalendar Attachments';
$string['manageradded'] = 'Your manager\'s email address has been accepted.';
$string['managerchanged'] = 'Your manager\'s email address has been changed.';
$string['manageremail'] = 'Manager\'s email';
$string['manageremailaddress'] = 'Manager\'s email address';
$string['manageremailformat'] = 'The email address must be of the format \'{$a}\' to be accepted.';
$string['manageremailheading'] = 'Manager Emails';
$string['manageremailinstruction'] = 'In order to sign-up for a training event, a confirmation email must be sent to your email address and copied to your manager\'s email address.';
$string['manageremailinstructionconfirm'] = 'Please confirm that this is your manager\'s email address:';
$string['managerupdated'] = 'Your manager\'s email address has been updated.';
$string['newmanageremailaddress'] = 'Manager\'s email address';
$string['noposition'] = 'User has no positions assigned.';
$string['nositenotices'] = '<p>No site notices are defined.</p>';
$string['noticedeleteconfirm'] = 'Delete site notice \'{$a->name}\'?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'Notice text';
$string['position'] = 'Position';
$string['savewithuserconflicts'] = 'Save with conflict';
$string['savewithuserconflicts_header'] = 'User scheduling conflict detected';
$string['selectedpositionassignment'] = 'Position Assignment on sign up';
$string['selectedpositionname'] = 'Position Name on sign up';
$string['selectedpositiontype'] = 'Position Type on sign up';
$string['selectposition'] = 'Select a position';
$string['selectpositiononsignup'] = 'Select position on signup';
$string['setting:addchangemanageremail'] = 'Ask users for their manager\'s email address.';
$string['setting:addchangemanageremail_caption'] = 'Manager\'s email:';
$string['setting:addchangemanageremaildefault'] = 'Ask users for their manager\'s email address.';
$string['setting:bulkaddsource'] = 'When bulk adding attendees, match to the selected field.';
$string['setting:bulkaddsource_caption'] = 'Bulk add field:';
$string['setting:manageraddressformat'] = 'Suffix which must be present in the email address of the manager in order to be considered valid.';
$string['setting:manageraddressformat_caption'] = 'Required suffix:';
$string['setting:manageraddressformatdefault'] = '';
$string['setting:manageraddressformatreadable'] = 'Short description of the restrictions on a manager\'s email address.  This setting has no effect if the previous one is not set.';
$string['setting:manageraddressformatreadable_caption'] = 'Format example:';
$string['setting:manageraddressformatreadabledefault'] = 'firstname.lastname@company.com';
$string['setting:selectpositiononsignupglobal'] = 'Select position on signup';
$string['setting:selectpositiononsignupglobal_caption'] = 'When enabled a setting will appear in seminar activity settings to force users with multiple positions to choose which capacity they will be signing up on.';
$string['setting:sitenotices'] = 'Notices only appear on the Seminar Calendar found {$a}';
$string['setting:sitenoticeshere'] = 'here';
$string['sitenoticesheading'] = 'Site Notices';
$string['updateposition'] = 'Update position';
$string['userpositionheading'] = '{$a} - update selected position';
$string['userschedulingconflictdetected_body'] = 'Saving this event as it is will cause a scheduling conflict for {$a->userscount} individual/s:
{$a->users}.

Please cancel and go back to change the settings (recommended), or save with conflict.';
$string['userschedulingconflictdetected_title'] = 'User scheduling conflict detected';
$string['waitliststatus'] = 'You have a place on the waitlist of the following session';

/**
 * # Deprecated
 */
$string['approvaloptionsheader'] = 'Approval Options';
$string['cancel'] = 'Cancel';
$string['capacity_help'] = '**Capacity** is the number of seats available in an event.

When a Seminar event reaches capacity the event details do not appear on the course page. The details will appear greyed out on the **View all events** page and the learner cannot enrol on the event.
&nbsp;';
$string['copy'] = 'Copy';
$string['datetimeknownhinttext'] = '';
$string['declareinterestonlyiffull'] = 'Show "Declare Interest" link only if all events are closed';
$string['declareinterestonlyiffull_help'] = 'Only show the declare interest option if there are no events with spaces or waiting lists.';
$string['delete'] = 'Delete';
$string['duration_help'] = '**Duration** is the total length of the training in hours.
If the training occurs over two or more time periods, the duration is the combined total.
If the session date is known then this value is automatically recalculated when the session is saved.';
$string['edit'] = 'Edit';
$string['error:couldnotaddsession'] = 'Could not add event';
$string['error:couldnotupdatesession'] = 'Could not update event';
$string['error:notificationtitletoolong'] = 'The title you have used is too long. The title is typically used as an email subject and should be no more than 78 characters long. Longer titles may be truncated by the users email client.';
$string['facetoface:editsessions'] = 'Add, edit, copy and delete face-to-face events';
$string['facetoface:overbook'] = 'Sign-up to full events.';
$string['gradesheader'] = 'Grade';
$string['missingdefaultnotifications'] = 'There are {$a} missing default notifications.';
$string['missingdefaultsfix'] = 'Click here to restore missing default notifications.';
$string['multiplesessions'] = 'Users can sign-up to multiple events';
$string['multiplesessions_help'] = 'When this option is toggled, users can sign up for multiple events within a seminar, subject to the restrictions and limitations of the settings below.';
$string['multiplesessionsheading'] = 'Multiple events signup settings';
$string['schedule_unit_3'] = '{$a} weeks';
$string['schedule_unit_3_singular'] = '1 week';
$string['scvtextfile_help'] = 'The file should be a CSV text file containing a heading row and one or more data rows. If a row contains multiple columns they should be separated by a comma (,). Every row must have the same number of columns. Below is a list of the heading names you can use:

* **username**: The username of the user to add.
* **idnumber**: The ID number of the user to add.
* **email**: The email address of the user to add.
{$a->customfields}

The following fields must be provided:

* Either username, idnumber, or email (only one)
{$a->requiredcustomfields}';
$string['sessiondatetimeknown'] = 'Session date/time known';
$string['sessiondatetimeknown_help'] = '**If a session\'s date/time is known**

If **Yes** is entered for this setting, the session date and time will be displayed on the course page (if the session is upcoming and available), the **View all sessions page**, the session sign-up page, as well as all email notifications related to the session.

When a staff member signs up for a session with a known date and time:

* The staff member and the staff member\'s manager will be sent a confirmation email (i.e., the one formatted per the **Confirmation message** section of the Seminar activity settings).
* The staff member will be sent a reminder email message (i.e., the one formatted per the **Reminder message** section of the seminar activity settings). The reminder will be sent a number of days before the session, according to the **Days before message is sent** setting also found in the **Reminder message** section of the Seminar activity settings.

**If a session\'s date/time is not known (or wait-listed)**

If **No** is entered for this setting, the text \'wait-listed\' will be displayed on the course page, the **View all sessions page**, the session sign-up page, as well as all email notifications related to the session.

When a staff member signs up for a wait-listed session:

* The staff member will be sent a confirmation email (i.e. the one formatted per the **Wait-listed message** section of the Seminar activity settings).
* The staff member will not be sent a reminder email message.
* The staff member\'s manager will not be sent confirmation and cancellation email messages.';
$string['sessionundercapacity'] = 'Event under minimum bookings for: {$a}';
$string['sessionundercapacity_body'] = 'The following event is under minimum bookings:

Name: {$a->name}
Event start: {$a->starttime}
Capacity: {$a->booked} / {$a->capacity} (minimum: {$a->mincapacity})
{$a->link}';
$string['setting:fromaddress'] = 'What will appear in the From field of email reminders sent by this module, unless "Always send email from the no-reply address" is set.';
$string['setting:fromaddress_caption'] = 'Sender address:';
$string['setting:fromaddressdefault'] = 'totara@example.com';
$string['setting:multiplesessions'] = 'Default value for allowing multiple events signup per user';
$string['setting:multiplesessions_caption'] = 'Multiple events default';
$string['setting:signupapproval_header'] = 'Signup Approvals';
$string['status_session_cancelled'] = 'Event Cancelled';
$string['xhxm'] = '{$a->hours}h {$a->minutes}m';

/**
 * totara_notifications
 */
$string['notification_placeholder_event_all_sessions'] = 'All sessions';
$string['notification_placeholder_event_all_sessions_layout'] = '[#sessions][session:startdate], [session:starttime] - [session:finishdate], [session:finishtime] [session:timezone]
Duration: [session:duration]
[session:rooms]
[session:facilitators][/sessions]';
$string['notification_placeholder_event_attendees_linked'] = 'Attendees (with link)';
$string['notification_placeholder_event_booked'] = 'Booked';
$string['notification_placeholder_event_cancellation'] = 'Event Cancellation: {$a}';
$string['notification_placeholder_event_capacity'] = 'Capacity';
$string['notification_placeholder_event_cost'] = 'Cost';
$string['notification_placeholder_event_details'] = 'Details';
$string['notification_placeholder_event_duration'] = 'Duration';
$string['notification_placeholder_event_event_page_linked'] = 'Event (with link)';
$string['notification_placeholder_event_finish_date'] = 'Finish date';
$string['notification_placeholder_event_finish_time'] = 'Finish time';
$string['notification_placeholder_event_latest_finish_date'] = 'Latest finish date';
$string['notification_placeholder_event_latest_finish_time'] = 'Latest finish time';
$string['notification_placeholder_event_latest_start_date'] = 'Latest start date';
$string['notification_placeholder_event_latest_start_time'] = 'Latest start time';
$string['notification_placeholder_event_minimum_capacity'] = 'Minumum capacity';
$string['notification_placeholder_event_registration_cutoff'] = 'Registration cutoff';
$string['notification_placeholder_event_reminder_period'] = 'Reminder period';
$string['notification_placeholder_event_session_date'] = 'Event date';
$string['notification_placeholder_event_session_role'] = 'Role';
$string['notification_placeholder_event_start_date'] = 'Start date';
$string['notification_placeholder_event_start_time'] = 'Start time';
$string['notification_placeholder_event_self_checkin'] = 'Self check-in';
$string['notification_placeholder_group_event'] = 'Event {$a}';
$string['notification_placeholder_group_facilitator'] = 'Facilitator {$a}';
$string['notification_placeholder_group_signup'] = 'Signup {$a}';
$string['notification_placeholder_group_signup_cancellation'] = 'Signup Cancellation: {$a}';
$string['notification_placeholder_group_trainer'] = 'Trainer {$a}';
$string['notification_placeholder_group_user_signup'] = 'User Signup: {$a}';
$string['notification_placeholder_signup_cost'] = 'Cost';
$string['notification_recipient_approvers'] = 'Approvers';
$string['notification_recipient_event_roles'] = 'Users with event roles';
$string['notification_recipient_facilitator'] = 'Facilitator';
$string['notification_recipient_notifiable_roles'] = 'Notification recipients';
$string['notification_recipient_third_party'] = 'Third party email recipients';
$string['notification_recipient_trainer'] = 'Trainer';
$string['notification_recipient_virtualmeeting_creators'] = 'Virtual meeting creator';

/**
 * Notification booking_cancelled.
 */
$string['notification_booking_cancelled_for_manager_body'] =
    'The booking for [subject:full_name] on the following event has been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_cancelled_for_manager_subject'] =
    'Seminar booking for [subject:full_name] was cancelled for [activity:name] on [event:start_date]';
$string['notification_booking_cancelled_for_manager_title'] = 'Booking cancelled';
$string['notification_booking_cancelled_for_subject_body'] =
    'Your booking on the following seminar event has been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_cancelled_for_subject_subject'] =
    'Your seminar booking has been cancelled for [activity:name] on [event:start_date]';
$string['notification_booking_cancelled_for_subject_title'] = 'Booking cancelled';
$string['notification_booking_cancelled_title'] = 'Booking cancelled';

/**
 * Notification booking_confirmed.
 */
$string['notification_booking_confirmed_for_manager_body'] =
    'A booking for [subject:full_name] on the following seminar event was confirmed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_confirmed_for_manager_subject'] =
    'A booking for [subject:full_name] was confirmed for [activity:name] on [event:start_date]';
$string['notification_booking_confirmed_for_manager_title'] = 'Booking confirmed';
$string['notification_booking_confirmed_for_subject_body'] =
    'Your booking on the following seminar event was confirmed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]

To re-schedule your booking you need to cancel this booking and then re-book a new event. To cancel your booking, go to [event:event_page_link] and then select \'Cancel\'.';
$string['notification_booking_confirmed_for_subject_subject'] =
    'Your booking was confirmed for [activity:name] on [event:start_date]';
$string['notification_booking_confirmed_for_subject_title'] = 'Booking confirmed';
$string['notification_booking_confirmed_title'] = 'Booking confirmed';

/**
 * Notification booking_details_changed.
 */
$string['notification_booking_details_changed_for_subject_body'] =
    'A seminar event you are booked on, been waitlisted on, or have requested has changed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_details_changed_for_subject_subject'] =
    'Your seminar event has changed for [activity:name] on [event:start_date]';
$string['notification_booking_details_changed_for_subject_title'] = 'Booking details changed';
$string['notification_booking_details_changed_title'] = 'Booking details changed';

/**
 * Notification booking_event_cancelled.
 */
$string['notification_booking_event_cancelled_for_manager_body'] =
    'The following seminar event that [subject:full_name] was booked on has been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_event_cancelled_for_manager_subject'] =
    'Seminar event for [subject:full_name] was cancelled for [activity:name] on [event:start_date]';
$string['notification_booking_event_cancelled_for_manager_title'] = 'Booking cancelled';
$string['notification_booking_event_cancelled_for_subject_body'] =
    'The following seminar event has been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_event_cancelled_for_subject_subject'] =
    'Your seminar event has been cancelled for [activity:name] on [event:start_date]';
$string['notification_booking_event_cancelled_for_subject_title'] = 'Booking cancelled';
$string['notification_booking_event_cancelled_title'] = 'Booking cancelled due to event being cancelled';

/**
 * Notification booking event_end_date.
 */
$string['notification_booking_event_end_date_title'] = 'Booking end date';

/**
 * Notification booking event_start_date.
 */
$string['notification_booking_event_start_date_for_manager_body'] =
    'This is a reminder that [subject:full_name] is booked on the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_event_start_date_for_manager_subject'] =
    'Reminder: [subject:full_name] is booked for [activity:name] on [event:start_date]';
$string['notification_booking_event_start_date_for_manager_title'] = 'Booking reminder';
$string['notification_booking_event_start_date_for_subject_body'] =
    'This is a reminder that you are booked on the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]

To re-schedule your booking you need to cancel this booking and then re-book a new event. To cancel your booking, go to [event:event_page_link] and then select \'Cancel\'.';
$string['notification_booking_event_start_date_for_subject_subject'] =
    'Reminder: You are booked for [activity:name] on [event:start_date]';
$string['notification_booking_event_start_date_for_subject_title'] = 'Booking reminder';
$string['notification_booking_event_start_date_title'] = 'Booking start date';

/**
 * Notification booking_request_created.
 */
$string['notification_booking_request_created_for_approvers_body'] =
    '[subject:full_name] has requested to be booked onto the following seminar event and you are assigned as an approver.

Please review this request before registration closes on [event:registration_cutoff]

Follow the link below to approve the request:
[event:attendees_link]

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_created_for_approvers_subject'] =
    'Approve booking of [subject:full_name] for [activity:name] on [event:start_time]';
$string['notification_booking_request_created_for_approvers_title'] = 'Booking request created';
$string['notification_booking_request_created_for_subject_body'] =
    'You have requested to be booked onto the following seminar event. Your booking is pending approval.

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_created_for_subject_subject'] =
    'You have requested to be booked for [activity:name] on [event:start_time]';
$string['notification_booking_request_created_for_subject_title'] = 'Booking request created';
$string['notification_booking_request_created_title'] = 'Booking request created';

/**
 * Notification booking_request_declined.
 */
$string['notification_booking_request_declined_for_manager_body'] =
    'A booking request for [subject:full_name] on the following seminar event was declined:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_declined_for_manager_subject'] =
    'A booking request for [subject:full_name] was declined for [activity:name] on [event:start_date]';
$string['notification_booking_request_declined_for_manager_title'] = 'Booking request declined';
$string['notification_booking_request_declined_for_subject_body'] =
    'Your booking request on the following seminar event was declined:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_declined_for_subject_subject'] =
    'Your booking request was declined for [activity:name] on [event:start_date]';
$string['notification_booking_request_declined_for_subject_title'] = 'Booking request declined';
$string['notification_booking_request_declined_title'] = 'Booking request declined';

/**
 * Notification booking_request_expired.
 */
$string['notification_booking_request_expired_for_manager_body'] =
    'A pending booking request made by [subject:full_name] for the following seminar event has expired, because the registration period has closed.

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_expired_for_manager_subject'] =
    'A booking request by [subject:full_name] has expired for [activity:name] on [event:start_date]';
$string['notification_booking_request_expired_for_manager_title'] = 'Booking request expired';
$string['notification_booking_request_expired_for_subject_body'] =
    'Your pending booking request for the following seminar event has expired, because the registration period has closed. Please request a booking on a different event.

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_booking_request_expired_for_subject_subject'] =
    'Your booking request has expired for [activity:name] on [event:start_date]';
$string['notification_booking_request_expired_for_subject_title'] = 'Booking request expired';
$string['notification_booking_request_expired_title'] = 'Booking request expired';

/**
 * Notification event booking closed
 */
$string['notification_event_booking_closed_for_notifiable_roles_body'] =
    'The registration period for the following seminar event has been closed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]
Details:
[event:all_sessions]';
$string['notification_event_booking_closed_for_notifiable_roles_subject'] =
    'Registration period closed for [activity:name] on [event:start_date]';
$string['notification_event_booking_closed_for_notifiable_roles_title'] = 'Registration closed';
$string['notification_event_booking_closed_title'] = 'Registration closed';

/**
 * Notification event_cancelled
 */
$string['notification_event_cancelled_for_event_roles_body'] =
    'The following seminar event was cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_event_cancelled_for_event_roles_subject'] =
    'Your seminar event was cancelled for [activity:name] on [event:start_date]';
$string['notification_event_cancelled_for_event_roles_title'] = 'Event cancelled';
$string['notification_event_cancelled_title'] = 'Event cancelled';

/**
 * Notification event_under_minimum_bookings.
 */
$string['notification_event_under_minimum_bookings_for_notifiable_roles_body'] =
    'The following seminar event is under minimum bookings:

***EVENT UNDER CAPACITY***

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Capacity: [event:booked] / [event:capacity] (minimum: [event:minimum_capacity])

Details:
[event:all_sessions]';
$string['notification_event_under_minimum_bookings_for_notifiable_roles_subject'] =
    'Event under minimum bookings for [activity:name] on [event:start_date]';
$string['notification_event_under_minimum_bookings_for_notifiable_roles_title'] = 'Event under minimum bookings';
$string['notification_event_under_minimum_bookings_title'] = 'Event under minimum bookings';

/**
 * Notification facilitator_assigned.
 */
$string['notification_facilitator_assigned_for_facilitator_body'] =
    'You are now assigned as facilitator in the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_facilitator_assigned_for_facilitator_subject'] =
    'You have been assigned as facilitator for [activity:name] on [event:start_date]';
$string['notification_facilitator_assigned_for_facilitator_title'] = 'Facilitator assigned';
$string['notification_facilitator_assigned_title'] = 'Facilitator assigned';

/**
 * Notification facilitator_event_cancelled.
 */
$string['notification_facilitator_event_cancelled_for_facilitator_body'] =
    'A seminar event you are assigned to facilitate has been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_facilitator_event_cancelled_for_facilitator_subject'] =
    'Your seminar event has been cancelled for [activity:name] on [event:start_date]';
$string['notification_facilitator_event_cancelled_for_facilitator_title'] = 'Facilitator event cancelled';
$string['notification_facilitator_event_cancelled_title'] = 'Facilitator event cancelled';

/**
 * Notification facilitator_sessions_cancelled.
 */
$string['notification_facilitator_sessions_cancelled_for_facilitator_body'] =
    'One or more sessions you were assigned to facilitate have been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details (updated):
[event:all_sessions]';
$string['notification_facilitator_sessions_cancelled_for_facilitator_subject'] =
    'Sessions you facilitate have been cancelled for [activity:name] on [event:start_date]';
$string['notification_facilitator_sessions_cancelled_for_facilitator_title'] = 'Facilitator sessions cancelled';
$string['notification_facilitator_sessions_cancelled_title'] = 'Facilitator sessions cancelled';

/**
 * Notification facilitator_sessions_details_changed
 */
$string['notification_facilitator_sessions_datetime_changed_title'] = 'Facilitator sessions date/time changed';
$string['notification_facilitator_sessions_details_changed_for_facilitator_body'] =
    'A seminar event you are assigned to facilitate has changed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_facilitator_sessions_details_changed_for_facilitator_subject'] =
    'Your seminar event has changed for [activity:name] on [event:start_date]';
$string['notification_facilitator_sessions_details_changed_for_facilitator_title'] = 'Sessions changed';
$string['notification_facilitator_sessions_details_changed_title'] = 'Facilitator sessions details changed';

/**
 * Notification facilitator_unassigned.
 */
$string['notification_facilitator_unassigned_for_facilitator_body'] =
    'You are no longer assigned as facilitator in one or more sessions of the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_facilitator_unassigned_for_facilitator_subject'] =
    'You have been unassigned as facilitator of one or more sessions for [activity:name] on [event:start_date]';
$string['notification_facilitator_unassigned_for_facilitator_title'] = 'Facilitator unassigned';
$string['notification_facilitator_unassigned_title'] = 'Facilitator unassigned';

/**
 * Notification logs
 */
$string['notification_log_booking_cancelled'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_confirmed'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_details_changed'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_event_cancelled'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_event_end_date'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_event_start_date'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_request_created'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_request_declined'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_booking_request_expired'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_event_booking_closed'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_event_cancelled'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_event_reservations_cancelled'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_event_reservations_expired'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_event_under_minimum_bookings'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_facilitator_assigned'] = '{$a->resolver_title}: Facilitaror "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_facilitator_event_cancelled'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_facilitator_sessions_cancelled'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_facilitator_sessions_details_changed'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_facilitator_unassigned'] = '{$a->resolver_title}: Facilitaror "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_manager_reservations_cancelled'] = '{$a->resolver_title}: Manager "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_manager_reservations_expired'] = '{$a->resolver_title}: Manager "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_signup_expired'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_signup_waitlisted'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_trainer_assigned'] = '{$a->resolver_title}: Trainer {$a->user}, Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_trainer_sessions_details_changed'] = '{$a->resolver_title}: Course "{$a->course}, Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_trainer_unassigned'] = '{$a->resolver_title}: User "{$a->user}", Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';
$string['notification_log_virtual_meeting_creation_failed'] = '{$a->resolver_title}: Course "{$a->course}", Event "{$a->activity}" starting on {$a->date}';

/**
 * Notification manager_reservation_cancelled.
 */
$string['notification_manager_reservations_cancelled_for_subject_body'] =
    'Your unallocated reservations for the following seminar event have been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_manager_reservations_cancelled_for_subject_subject'] =
    'Reservations cancelled for [activity:name] on [event:start_date]';
$string['notification_manager_reservations_cancelled_for_subject_title'] = 'Manager reservations cancelled';
$string['notification_manager_reservations_cancelled_title'] = 'Manager reservations cancelled';

/**
 * Notification manager_reservation_expired.
 */
$string['notification_manager_reservations_expired_for_subject_body'] =
    'Your unallocated reservations for the following seminar event have expired, as the event will be starting soon:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_manager_reservations_expired_for_subject_subject'] =
    'Reservations expired for [activity:name] on [event:start_date]';
$string['notification_manager_reservations_expired_for_subject_title'] = 'Manager reservations expired';
$string['notification_manager_reservations_expired_title'] = 'Manager reservations expired';

/**
 * Notification signup_expired.
 */
$string['notification_signup_expired_for_subject_body'] =
    'Your wait-listed signup for the following seminar has been cancelled due to the event starting:

***WAITLIST CANCELLED***

Course: [course:full_name]
Seminar: [activity:name]

Details:
[event:all_sessions]';
$string['notification_signup_expired_for_subject_subject'] =
    'Waitlist expired for [activity:name]';
$string['notification_signup_expired_for_subject_title'] = 'Waitlisted signup expired';
$string['notification_signup_expired_title'] = 'Waitlisted signup expired';

/**
 * Notification signup_waitlisted.
 */
$string['notification_signup_waitlisted_for_subject_body'] =
    'You have been added to the waitlist for:

Course: [course:full_name]
Seminar: [activity:name]

Details:
[event:all_sessions]

***Please note this is not a seminar booking confirmation***

By wait-listing you have registered your interest in this seminar and will be contacted directly when events become available.

To remove yourself from this waitlist please return to this seminar and click Cancel waitlist. Please note there is no waitlist removal confirmation email.';
$string['notification_signup_waitlisted_for_subject_subject'] =
    'You have been added to the waitlist for [activity:name]';
$string['notification_signup_waitlisted_for_subject_title'] = 'Wait-list signup created';
$string['notification_signup_waitlisted_title'] = 'Wait-list signup created';

/**
 * Notification trainer_assigned.
 */
$string['notification_trainer_assigned_for_trainer_body'] =
    'You are now assigned as a trainer on the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_trainer_assigned_for_trainer_subject'] =
    'You have been assigned as trainer for [activity:name] on [event:start_date]';
$string['notification_trainer_assigned_for_trainer_title'] = 'Trainer assigned';
$string['notification_trainer_assigned_title'] = 'Trainer assigned';

/**
 * Notification trainer_sessions_details_changed
 */
$string['notification_trainer_sessions_details_changed_for_trainer_body'] =
    'A seminar event you are assigned to has changed:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_trainer_sessions_details_changed_for_trainer_subject'] =
    'Your seminar event has changed for [activity:name] on [event:start_date]';
$string['notification_trainer_sessions_details_changed_for_trainer_title'] = 'Sessions changed';
$string['notification_trainer_sessions_details_changed_title'] = 'Trainer sessions details changed';

/**
 * Notification trainer_unassigned.
 */
$string['notification_trainer_unassigned_for_trainer_body'] =
    'You are no longer assigned as a trainer on the following seminar event:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_trainer_unassigned_for_trainer_subject'] =
    'You have been unassigned as trainer from [activity:name] on [event:start_date]';
$string['notification_trainer_unassigned_for_trainer_title'] = 'Trainer unassigned';
$string['notification_trainer_unassigned_title'] = 'Trainer unassigned';

/**
 * Notification virtual_meeting_creation_failed.
 */
$string['notification_virtual_meeting_creation_failed_for_creators_body'] =
    'The system failed to create virtual meetings for the following event. Please try again by deleting and recreating these virtual rooms in the event. If the error persists check your connection to the virtual meeting service provider or contact site administrators:

***VIRTUAL MEETING CREATION FAILED***

ourse: [course:full_name]
Seminar: [activity:name]

Details:
[event:all_sessions]';
$string['notification_virtual_meeting_creation_failed_for_creators_subject'] =
    'Virtual meeting creation failure for [activity:name] on [event:start_date]';
$string['notification_virtual_meeting_creation_failed_for_creators_title'] = 'Virtual meeting creation failed';
$string['notification_virtual_meeting_creation_failed_title'] = 'Virtual meeting creation failed';

/**
 * @deprecated since Totara 13.0
 */
$string['error:emailnotfound'] = 'No users were found with the following emails: {$a}';
$string['error:idnumbernotfound'] = 'No users were added because no users match the following user ID numbers: {$a}. Please remove invalid numbers and try again';
$string['error:usernamenotfound'] = 'No users were found with the following usernames: {$a}';
$string['placeholder:aim'] = '[aim]';
$string['placeholder:icq'] = '[icq]';
$string['placeholder:msn'] = '[msn]';
$string['placeholder:yahoo'] = '[yahoo]';

/**
 * @deprecated since Totara 16.0
 */
$string['error:nodatasupplied'] = 'No data supplied';
$string['notificationsin'] = 'Notifications in {$a}';

/**
 * @deprecated since Totara 18.0
 */
$string['virtual_meeting_service_provider_help'] = 'Once you connect your service provider account and save this virtual room, the session will appear as a scheduled meeting under your authorised service provider account.';

/**
 * @depreacted since Totara 19.0
 */
$string['notification_event_reservations_cancelled_for_managers_body'] =
    'Your unallocated reservations for the following seminar event have been cancelled:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_event_reservations_cancelled_for_managers_subject'] =
    'Reservations cancelled for [activity:name] on [event:start_date]';
$string['notification_event_reservations_cancelled_for_managers_title'] = 'Reservations cancelledXXX';
$string['notification_event_reservations_cancelled_title'] = 'Reservations cancelledXXX';
$string['notification_event_reservations_expired_for_managers_body'] =
    'Your unallocated reservations for the following seminar event have expired, as the event will be starting soon:

Course: [course:full_name]
Seminar: [activity:name]
Event start date: [event:start_date]

Details:
[event:all_sessions]';
$string['notification_event_reservations_expired_for_managers_subject'] =
    'Reservations expired for [activity:name] on [event:start_date]';
$string['notification_event_reservations_expired_for_managers_title'] = 'Reservations expired';
$string['notification_event_reservations_expired_title'] = 'Reservations expired';
$string['notification_recipient_reservation_managers'] = 'Reservation managers';
