<?php
/**
 * This file is part of Totara Perform
 *
 * Copyright (C) 2024 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Murali Nair <murali.nair@totara.com>
 * @package perform_goal
 */

namespace perform_goal\formatter;

use core\webapi\formatter\formatter;
use core\webapi\formatter\field\date_field_formatter;
use core\json_editor\helper\document_helper;

/**
 * Provides formatting for fields for a perform_goal_task_resource model (e.g.
 * for UI views).
 */
class goal_task_resource_formatter extends formatter {
    public const CREATION_DATE = 'created_at';
    public const ID = 'id';
    public const RESOURCE_ID = 'resource_id';
    public const RESOURCE_TYPE = 'resource_type';
    public const RESOURCE_CUSTOM_DATA = 'resource_custom_data';
    public const TASK_ID = 'task_id';

    /**
     * {@inheritdoc}
     */
    protected function get_map(): array {
        return [
            self::CREATION_DATE => date_field_formatter::class,
            self::ID => null,
            self::RESOURCE_ID => null,
            self::RESOURCE_TYPE => null,
            self::TASK_ID => null,
            self::RESOURCE_CUSTOM_DATA => null,
        ];
    }

    /**
     * {@inheritdoc}
     */
    protected function get_field(string $field) {
        switch ($field) {
            case self::RESOURCE_CUSTOM_DATA:
                if (!$this->object->type->authorized()) {
                    return null;
                }
                return document_helper::json_encode_document($this->object->resource_custom_data);

            case self::RESOURCE_ID:
                return $this->object->type->resource_id();

            case self::RESOURCE_TYPE:
                return $this->object->type->code();

            default:
                return parent::get_field($field);
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function has_field(string $field): bool {
        return array_key_exists($field, $this->get_map());
    }
}