<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Tests of the upgrade to the new Moodle question engine for attempts at
 * multianswer questions.
 *
 * @package    qtype
 * @subpackage multianswer
 * @copyright  2011 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->dirroot . '/question/engine/upgrade/tests/helper.php');


/**
 * Testing the upgrade of multianswer question attempts.
 *
 * @copyright  2011 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class qtype_multianswer_upgradelibnewqe_test extends question_attempt_upgrader_test_base {
    public function test_multianswer_adaptivenopenalty_qsession104() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '16',
            'uniqueid' => '16',
            'quiz' => '5',
            'userid' => '4',
            'attempt' => '1',
            'sumgrades' => '6.00000',
            'timestart' => '1306425691',
            'timefinish' => '1306425746',
            'timemodified' => '1306425746',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '28',
            'category' => '2',
            'parent' => '0',
            'name' => 'Very simple cloze',
            'questiontext' => '<p>An answer {#1}.</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+XQLcXi',
            'version' => 'tjh238.vledev2.open.ac.uk+110526154631+T8hPiI',
            'hidden' => '0',
            'timecreated' => '1306424791',
            'timemodified' => '1306424791',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '1.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '29',
                        'category' => '2',
                        'parent' => '28',
                        'name' => 'Very simple cloze',
                        'questiontext' => '{1:SHORTANSWER:=frog#Yay!}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+j3BYTL',
                        'version' => 'tjh238.vledev2.open.ac.uk+110526154631+lxNwQv',
                        'hidden' => '0',
                        'timecreated' => '1306424791',
                        'timemodified' => '1306424791',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                52 => (object) array(
                                    'id' => '52',
                                    'question' => '29',
                                    'answer' => 'frog',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Yay!',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                ),
            ),
            'defaultmark' => '1.0000000',
        );
        $qsession = (object) array(
            'id' => '104',
            'attemptid' => '16',
            'questionid' => '28',
            'newest' => '285',
            'newgraded' => '285',
            'sumpenalty' => '0.1000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            281 => (object) array(
                'id' => '281',
                'attempt' => '16',
                'question' => '28',
                'seq_number' => '0',
                'answer' => '1-',
                'timestamp' => '1306425691',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            283 => (object) array(
                'id' => '283',
                'attempt' => '16',
                'question' => '28',
                'seq_number' => '1',
                'answer' => '1-frog',
                'timestamp' => '1306425739',
                'event' => '2',
                'grade' => '0.0000000',
                'raw_grade' => '1.0000000',
                'penalty' => '0.1000000',
            ),
            285 => (object) array(
                'id' => '285',
                'attempt' => '16',
                'question' => '28',
                'seq_number' => '2',
                'answer' => '1-frog',
                'timestamp' => '1306425739',
                'event' => '6',
                'grade' => '1.0000000',
                'raw_grade' => '1.0000000',
                'penalty' => '0.1000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => 28,
            'variant' => 1,
            'maxmark' => 1.0000000,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'An answer _____.',
            'rightanswer' => 'part 1: frog',
            'responsesummary' => 'part 1: frog',
            'timemodified' => 1306425739,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1306425691,
                    'userid' => 4,
                    'data' => array(),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1306425739,
                    'userid' => 4,
                    'data' => array('sub1_answer' => 'frog'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'gradedright',
                    'fraction' => 1.0,
                    'timecreated' => 1306425739,
                    'userid' => 4,
                    'data' => array('sub1_answer' => 'frog', '-finish' => '1',
                            '-_try' => '1', '-_rawfraction' => 1.0),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multianswer_adaptivenopenalty_qsession106() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '17',
            'uniqueid' => '17',
            'quiz' => '5',
            'userid' => '4',
            'attempt' => '2',
            'sumgrades' => '0.00000',
            'timestart' => '1306425757',
            'timefinish' => '1306425762',
            'timemodified' => '1306425762',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '28',
            'category' => '2',
            'parent' => '0',
            'name' => 'Very simple cloze',
            'questiontext' => '<p>An answer {#1}.</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+XQLcXi',
            'version' => 'tjh238.vledev2.open.ac.uk+110526154631+T8hPiI',
            'hidden' => '0',
            'timecreated' => '1306424791',
            'timemodified' => '1306424791',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '1.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '29',
                        'category' => '2',
                        'parent' => '28',
                        'name' => 'Very simple cloze',
                        'questiontext' => '{1:SHORTANSWER:=frog#Yay!}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+j3BYTL',
                        'version' => 'tjh238.vledev2.open.ac.uk+110526154631+lxNwQv',
                        'hidden' => '0',
                        'timecreated' => '1306424791',
                        'timemodified' => '1306424791',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                52 => (object) array(
                                    'id' => '52',
                                    'question' => '29',
                                    'answer' => 'frog',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Yay!',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                ),
            ),
            'defaultmark' => '1.0000000',
        );
        $qsession = (object) array(
            'id' => '106',
            'attemptid' => '17',
            'questionid' => '28',
            'newest' => '289',
            'newgraded' => '289',
            'sumpenalty' => '0.1000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            287 => (object) array(
                'id' => '287',
                'attempt' => '17',
                'question' => '28',
                'seq_number' => '0',
                'answer' => '1-',
                'timestamp' => '1306425757',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            289 => (object) array(
                'id' => '289',
                'attempt' => '17',
                'question' => '28',
                'seq_number' => '1',
                'answer' => '1-',
                'timestamp' => '1306425757',
                'event' => '6',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.1000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => 28,
            'variant' => 1,
            'maxmark' => 1.0000000,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'An answer _____.',
            'rightanswer' => 'part 1: frog',
            'responsesummary' => 'part 1: ',
            'timemodified' => 1306425757,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1306425757,
                    'userid' => 4,
                    'data' => array(),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedwrong',
                    'fraction' => 0.0,
                    'timecreated' => 1306425757,
                    'userid' => 4,
                    'data' => array('-finish' => '1', '-_try' => '1', '-_rawfraction' => 0.0),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multianswer_adaptivenopenalty_qsession108() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '18',
            'uniqueid' => '18',
            'quiz' => '5',
            'userid' => '3',
            'attempt' => '1',
            'sumgrades' => '10.40000',
            'timestart' => '1306425784',
            'timefinish' => '1306425931',
            'timemodified' => '1306425931',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '28',
            'category' => '2',
            'parent' => '0',
            'name' => 'Very simple cloze',
            'questiontext' => '<p>An answer {#1}.</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+XQLcXi',
            'version' => 'tjh238.vledev2.open.ac.uk+110526154631+T8hPiI',
            'hidden' => '0',
            'timecreated' => '1306424791',
            'timemodified' => '1306424791',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '1.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '29',
                        'category' => '2',
                        'parent' => '28',
                        'name' => 'Very simple cloze',
                        'questiontext' => '{1:SHORTANSWER:=frog#Yay!}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110526154631+j3BYTL',
                        'version' => 'tjh238.vledev2.open.ac.uk+110526154631+lxNwQv',
                        'hidden' => '0',
                        'timecreated' => '1306424791',
                        'timemodified' => '1306424791',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                52 => (object) array(
                                    'id' => '52',
                                    'question' => '29',
                                    'answer' => 'frog',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Yay!',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                ),
            ),
            'defaultmark' => '1.0000000',
        );
        $qsession = (object) array(
            'id' => '108',
            'attemptid' => '18',
            'questionid' => '28',
            'newest' => '298',
            'newgraded' => '298',
            'sumpenalty' => '0.2000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            291 => (object) array(
                'id' => '291',
                'attempt' => '18',
                'question' => '28',
                'seq_number' => '0',
                'answer' => '1-',
                'timestamp' => '1306425784',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            293 => (object) array(
                'id' => '293',
                'attempt' => '18',
                'question' => '28',
                'seq_number' => '1',
                'answer' => '1-ds&#0044;&#0045;afg',
                'timestamp' => '1306425801',
                'event' => '2',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.1000000',
            ),
            297 => (object) array(
                'id' => '297',
                'attempt' => '18',
                'question' => '28',
                'seq_number' => '2',
                'answer' => '1-frog',
                'timestamp' => '1306425917',
                'event' => '3',
                'grade' => '1.0000000',
                'raw_grade' => '1.0000000',
                'penalty' => '0.1000000',
            ),
            298 => (object) array(
                'id' => '298',
                'attempt' => '18',
                'question' => '28',
                'seq_number' => '3',
                'answer' => '1-frog',
                'timestamp' => '1306425917',
                'event' => '6',
                'grade' => '1.0000000',
                'raw_grade' => '1.0000000',
                'penalty' => '0.1000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => 28,
            'variant' => 1,
            'maxmark' => 1.0000000,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'An answer _____.',
            'rightanswer' => 'part 1: frog',
            'responsesummary' => 'part 1: frog',
            'timemodified' => 1306425917,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1306425784,
                    'userid' => 3,
                    'data' => array(),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1306425801,
                    'userid' => 3,
                    'data' => array('sub1_answer' => 'ds,-afg'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'complete',
                    'fraction' => 1,
                    'timecreated' => 1306425917,
                    'userid' => 3,
                    'data' => array('sub1_answer' => 'frog', '-_try' => 1,
                            '-_rawfraction' => 1.0, '-submit' => 1),
                ),
                3 => (object) array(
                    'sequencenumber' => 3,
                    'state' => 'gradedright',
                    'fraction' => 1,
                    'timecreated' => 1306425917,
                    'userid' => 3,
                    'data' => array('sub1_answer' => 'frog', '-_try' => 1,
                            '-_rawfraction' => 1.0, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multianswer_adaptivenopenalty_qsession105() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '16',
            'uniqueid' => '16',
            'quiz' => '5',
            'userid' => '4',
            'attempt' => '1',
            'sumgrades' => '6.00000',
            'timestart' => '1306425691',
            'timefinish' => '1306425746',
            'timemodified' => '1306425746',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '19',
            'category' => '2',
            'parent' => '0',
            'name' => 'Cloze',
            'questiontext' => '<p>This question consists of some text with an answer embedded right  here {#1}</p>
        <p>and right after that you will have to deal with this short answer  {#2}</p>
        <p>and finally we have a floating point number  {#3}.</p>
        <p>The  multichoice question can also be shown in the vertical  display of the standard moodle multiple choice. {#4}</p>
        <p>Or in an horizontal display that is included here in a table {#5}</p>
        <p>A shortanswer question where case must match. Write moodle in  upper case letters {#6}</p>
        <p>Note that addresses like www.moodle.org and smileys :-) all work as normal:</p>
        <p>a) How good is this? {#7}</p>
        <p>b) What grade would you give it? {#8}</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110525164438+iwiint',
            'version' => 'tjh238.vledev2.open.ac.uk+110525164441+AAjnIy',
            'hidden' => '0',
            'timecreated' => '1306341878',
            'timemodified' => '1306341879',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '13.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '20',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:MULTICHOICE:Wrong answer#Feedback for this wrong answer~Another  wrong answer#Feedback for the other wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164439+cAuJ4r',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164439+5bnnys',
                        'hidden' => '0',
                        'timecreated' => '1306341879',
                        'timemodified' => '1306341879',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '3',
                            'question' => '20',
                            'layout' => '0',
                            'answers' => array(
                                29 => (object) array(
                                    'id' => '29',
                                    'question' => '20',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                30 => (object) array(
                                    'id' => '30',
                                    'question' => '20',
                                    'answer' => 'Another  wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                31 => (object) array(
                                    'id' => '31',
                                    'question' => '20',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                32 => (object) array(
                                    'id' => '32',
                                    'question' => '20',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    2 => (object) array(
                        'id' => '21',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER:Wrong answer#Feedback for this wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+EN6wCk',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164440+bQzatI',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                33 => (object) array(
                                    'id' => '33',
                                    'question' => '21',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                34 => (object) array(
                                    'id' => '34',
                                    'question' => '21',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                35 => (object) array(
                                    'id' => '35',
                                    'question' => '21',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    3 => (object) array(
                        'id' => '22',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:NUMERICAL:=23.8:0.1#Feedback for correct answer  23.8~%50%23.8:2#Feedback for half credit answer in the nearby region of  the correct answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+Xr29c2',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+QTwsGM',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                36 => (object) array(
                                    'id' => '36',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer  23.8',
                                    'feedbackformat' => '1',
                                    'tolerance' => '0.1',
                                ),
                                37 => (object) array(
                                    'id' => '37',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer in the nearby region of  the correct answer',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    4 => (object) array(
                        'id' => '23',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCV:1. Wrong answer#Feedback for this wrong answer~2. Another wrong  answer#Feedback for the other wrong answer~=3. Correct answer#Feedback  for correct answer~%50%4. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+7R55HA',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+uCMoQc',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '4',
                            'question' => '23',
                            'layout' => '1',
                            'answers' => array(
                                38 => (object) array(
                                    'id' => '38',
                                    'question' => '23',
                                    'answer' => '1. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                39 => (object) array(
                                    'id' => '39',
                                    'question' => '23',
                                    'answer' => '2. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                40 => (object) array(
                                    'id' => '40',
                                    'question' => '23',
                                    'answer' => '3. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                41 => (object) array(
                                    'id' => '41',
                                    'question' => '23',
                                    'answer' => '4. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    5 => (object) array(
                        'id' => '24',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCH:a. Wrong answer#Feedback for this wrong answer~b. Another wrong  answer#Feedback for the other wrong answer~=c. Correct answer#Feedback  for correct answer~%50%d. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+QGvRpd',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+03GsSs',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '5',
                            'question' => '24',
                            'layout' => '2',
                            'answers' => array(
                                42 => (object) array(
                                    'id' => '42',
                                    'question' => '24',
                                    'answer' => 'a. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                43 => (object) array(
                                    'id' => '43',
                                    'question' => '24',
                                    'answer' => 'b. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                44 => (object) array(
                                    'id' => '44',
                                    'question' => '24',
                                    'answer' => 'c. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                45 => (object) array(
                                    'id' => '45',
                                    'question' => '24',
                                    'answer' => 'd. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    6 => (object) array(
                        'id' => '25',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER_C:moodle#Feedback for moodle in lower  case ~=MOODLE#Feedback for MOODLE in upper case ~%50%Moodle#Feedback for  only first letter in upper case}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+n9ETJC',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+Bvqo6c',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                46 => (object) array(
                                    'id' => '46',
                                    'question' => '25',
                                    'answer' => 'moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for moodle in lower  case',
                                    'feedbackformat' => '1',
                                ),
                                47 => (object) array(
                                    'id' => '47',
                                    'question' => '25',
                                    'answer' => 'MOODLE',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for MOODLE in upper case',
                                    'feedbackformat' => '1',
                                ),
                                48 => (object) array(
                                    'id' => '48',
                                    'question' => '25',
                                    'answer' => 'Moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  only first letter in upper case',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '1',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    7 => (object) array(
                        'id' => '26',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{:MULTICHOICE:=Yes#Correct~No#We have a different opinion}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+0YjnZ7',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+1giLRX',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '6',
                            'question' => '26',
                            'layout' => '0',
                            'answers' => array(
                                49 => (object) array(
                                    'id' => '49',
                                    'question' => '26',
                                    'answer' => 'Yes',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Correct',
                                    'feedbackformat' => '1',
                                ),
                                50 => (object) array(
                                    'id' => '50',
                                    'question' => '26',
                                    'answer' => 'No',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'We have a different opinion',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    8 => (object) array(
                        'id' => '27',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{3:NUMERICAL:=3:2}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '3.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+glbCBN',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+xWusxR',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                51 => (object) array(
                                    'id' => '51',
                                    'question' => '27',
                                    'answer' => '3',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => '',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '3.0000000',
                    ),
                ),
            ),
            'defaultmark' => '13.0000000',
        );
        $qsession = (object) array(
            'id' => '105',
            'attemptid' => '16',
            'questionid' => '19',
            'newest' => '286',
            'newgraded' => '286',
            'sumpenalty' => '2.6000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            282 => (object) array(
                'id' => '282',
                'attempt' => '16',
                'question' => '19',
                'seq_number' => '0',
                'answer' => '1-,2-,3-,4-,5-,6-,7-,8-',
                'timestamp' => '1306425691',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            284 => (object) array(
                'id' => '284',
                'attempt' => '16',
                'question' => '19',
                'seq_number' => '1',
                'answer' => '1-31,2-dsf,3-sadf,4-39,5-44,6-MOODLE,7-49,8-100%',
                'timestamp' => '1306425739',
                'event' => '3',
                'grade' => '5.0000000',
                'raw_grade' => '5.0000000',
                'penalty' => '1.3000000',
            ),
            286 => (object) array(
                'id' => '286',
                'attempt' => '16',
                'question' => '19',
                'seq_number' => '2',
                'answer' => '1-31,2-dsf,3-sadf,4-39,5-44,6-MOODLE,7-49,8-100%',
                'timestamp' => '1306425739',
                'event' => '6',
                'grade' => '5.0000000',
                'raw_grade' => '5.0000000',
                'penalty' => '1.3000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => '19',
            'variant' => 1,
            'maxmark' => '13.0000000',
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'This question consists of some text with an answer embedded right here {Wrong answer; Another wrong answer; Correct answer; Answer that gives half the credit}

and right after that you will have to deal with this short answer _____

and finally we have a floating point number _____.

The multichoice question can also be shown in the vertical display of the standard moodle multiple choice. {1. Wrong answer; 2. Another wrong answer; 3. Correct answer; 4. Answer that gives half the credit}

Or in an horizontal display that is included here in a table {a. Wrong answer; b. Another wrong answer; c. Correct answer; d. Answer that gives half the credit}

A shortanswer question where case must match. Write moodle in upper case letters _____

Note that addresses like www.moodle.org and smileys :-) all work as normal:

a) How good is this? {Yes; No}

b) What grade would you give it? _____',
            'rightanswer' => 'part 1: Correct answer; part 2: Correct answer; part 3: 23.8; part 4: 3. Correct answer; part 5: c. Correct answer; part 6: MOODLE; part 7: Yes; part 8: 3',
            'responsesummary' => 'part 1: Correct answer; part 2: dsf; part 3: sadf; part 4: 2. Another wrong answer; part 5: c. Correct answer; part 6: MOODLE; part 7: Yes; part 8: 100%',
            'timemodified' => '1306425739',
            'steps' => array(
                0 => (object) array(
                    'data' => array('_sub1_order' => '29,30,31,32',
                        '_sub3_separators' => '.$,', '_sub4_order' => '38,39,40,41',
                        '_sub5_order' => '42,43,44,45', '_sub7_order' => '49,50',
                        '_sub8_separators' => '.$,'),
                    'fraction' => null,
                    'timecreated' => 1306425691,
                    'userid' => 4,
                    'state' => 'todo',
                    'sequencenumber' => 0,
                ),
                1 => (object) array(
                    'data' => array('sub1_answer' => 2, 'sub2_answer' => 'dsf',
                        'sub3_answer' => 'sadf', 'sub4_answer' => 1,
                        'sub5_answer' => 2, 'sub6_answer' => 'MOODLE',
                        'sub7_answer' => 0, 'sub8_answer' => '100%', '-_try' => 1,
                        '-_rawfraction' => 0.38461538461538466, '-submit' => 1),
                    'fraction' => 0.38461538461538466,
                    'timecreated' => '1306425739',
                    'userid' => '4',
                    'state' => 'todo',
                    'sequencenumber' => 1,
                ),
                2 => (object) array(
                    'data' => array('sub1_answer' => 2, 'sub2_answer' => 'dsf',
                        'sub3_answer' => 'sadf', 'sub4_answer' => 1,
                        'sub5_answer' => 2, 'sub6_answer' => 'MOODLE',
                        'sub7_answer' => 0, 'sub8_answer' => '100%', '-finish' => 1,
                        '-_try' => 1, '-_rawfraction' => 0.38461538461538466),
                    'fraction' => 0.38461538461538466,
                    'timecreated' => '1306425739',
                    'userid' => '4',
                    'state' => 'gradedpartial',
                    'sequencenumber' => 2,
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multianswer_adaptivenopenalty_qsession107() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '17',
            'uniqueid' => '17',
            'quiz' => '5',
            'userid' => '4',
            'attempt' => '2',
            'sumgrades' => '0.00000',
            'timestart' => '1306425757',
            'timefinish' => '1306425762',
            'timemodified' => '1306425762',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '19',
            'category' => '2',
            'parent' => '0',
            'name' => 'Cloze',
            'questiontext' => '<p>This question consists of some text with an answer embedded right  here {#1}</p>
        <p>and right after that you will have to deal with this short answer  {#2}</p>
        <p>and finally we have a floating point number  {#3}.</p>
        <p>The  multichoice question can also be shown in the vertical  display of the standard moodle multiple choice. {#4}</p>
        <p>Or in an horizontal display that is included here in a table {#5}</p>
        <p>A shortanswer question where case must match. Write moodle in  upper case letters {#6}</p>
        <p>Note that addresses like www.moodle.org and smileys :-) all work as normal:</p>
        <p>a) How good is this? {#7}</p>
        <p>b) What grade would you give it? {#8}</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110525164438+iwiint',
            'version' => 'tjh238.vledev2.open.ac.uk+110525164441+AAjnIy',
            'hidden' => '0',
            'timecreated' => '1306341878',
            'timemodified' => '1306341879',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '13.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '20',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:MULTICHOICE:Wrong answer#Feedback for this wrong answer~Another  wrong answer#Feedback for the other wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164439+cAuJ4r',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164439+5bnnys',
                        'hidden' => '0',
                        'timecreated' => '1306341879',
                        'timemodified' => '1306341879',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '3',
                            'question' => '20',
                            'layout' => '0',
                            'answers' => array(
                                29 => (object) array(
                                    'id' => '29',
                                    'question' => '20',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                30 => (object) array(
                                    'id' => '30',
                                    'question' => '20',
                                    'answer' => 'Another  wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                31 => (object) array(
                                    'id' => '31',
                                    'question' => '20',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                32 => (object) array(
                                    'id' => '32',
                                    'question' => '20',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    2 => (object) array(
                        'id' => '21',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER:Wrong answer#Feedback for this wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+EN6wCk',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164440+bQzatI',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                33 => (object) array(
                                    'id' => '33',
                                    'question' => '21',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                34 => (object) array(
                                    'id' => '34',
                                    'question' => '21',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                35 => (object) array(
                                    'id' => '35',
                                    'question' => '21',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    3 => (object) array(
                        'id' => '22',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:NUMERICAL:=23.8:0.1#Feedback for correct answer  23.8~%50%23.8:2#Feedback for half credit answer in the nearby region of  the correct answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+Xr29c2',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+QTwsGM',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                36 => (object) array(
                                    'id' => '36',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer  23.8',
                                    'feedbackformat' => '1',
                                    'tolerance' => '0.1',
                                ),
                                37 => (object) array(
                                    'id' => '37',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer in the nearby region of  the correct answer',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    4 => (object) array(
                        'id' => '23',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCV:1. Wrong answer#Feedback for this wrong answer~2. Another wrong  answer#Feedback for the other wrong answer~=3. Correct answer#Feedback  for correct answer~%50%4. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+7R55HA',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+uCMoQc',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '4',
                            'question' => '23',
                            'layout' => '1',
                            'answers' => array(
                                38 => (object) array(
                                    'id' => '38',
                                    'question' => '23',
                                    'answer' => '1. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                39 => (object) array(
                                    'id' => '39',
                                    'question' => '23',
                                    'answer' => '2. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                40 => (object) array(
                                    'id' => '40',
                                    'question' => '23',
                                    'answer' => '3. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                41 => (object) array(
                                    'id' => '41',
                                    'question' => '23',
                                    'answer' => '4. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    5 => (object) array(
                        'id' => '24',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCH:a. Wrong answer#Feedback for this wrong answer~b. Another wrong  answer#Feedback for the other wrong answer~=c. Correct answer#Feedback  for correct answer~%50%d. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+QGvRpd',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+03GsSs',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '5',
                            'question' => '24',
                            'layout' => '2',
                            'answers' => array(
                                42 => (object) array(
                                    'id' => '42',
                                    'question' => '24',
                                    'answer' => 'a. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                43 => (object) array(
                                    'id' => '43',
                                    'question' => '24',
                                    'answer' => 'b. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                44 => (object) array(
                                    'id' => '44',
                                    'question' => '24',
                                    'answer' => 'c. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                45 => (object) array(
                                    'id' => '45',
                                    'question' => '24',
                                    'answer' => 'd. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    6 => (object) array(
                        'id' => '25',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER_C:moodle#Feedback for moodle in lower  case ~=MOODLE#Feedback for MOODLE in upper case ~%50%Moodle#Feedback for  only first letter in upper case}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+n9ETJC',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+Bvqo6c',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                46 => (object) array(
                                    'id' => '46',
                                    'question' => '25',
                                    'answer' => 'moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for moodle in lower  case',
                                    'feedbackformat' => '1',
                                ),
                                47 => (object) array(
                                    'id' => '47',
                                    'question' => '25',
                                    'answer' => 'MOODLE',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for MOODLE in upper case',
                                    'feedbackformat' => '1',
                                ),
                                48 => (object) array(
                                    'id' => '48',
                                    'question' => '25',
                                    'answer' => 'Moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  only first letter in upper case',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '1',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    7 => (object) array(
                        'id' => '26',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{:MULTICHOICE:=Yes#Correct~No#We have a different opinion}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+0YjnZ7',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+1giLRX',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '6',
                            'question' => '26',
                            'layout' => '0',
                            'answers' => array(
                                49 => (object) array(
                                    'id' => '49',
                                    'question' => '26',
                                    'answer' => 'Yes',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Correct',
                                    'feedbackformat' => '1',
                                ),
                                50 => (object) array(
                                    'id' => '50',
                                    'question' => '26',
                                    'answer' => 'No',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'We have a different opinion',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    8 => (object) array(
                        'id' => '27',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{3:NUMERICAL:=3:2}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '3.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+glbCBN',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+xWusxR',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                51 => (object) array(
                                    'id' => '51',
                                    'question' => '27',
                                    'answer' => '3',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => '',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '3.0000000',
                    ),
                ),
            ),
            'defaultmark' => '13.0000000',
        );
        $qsession = (object) array(
            'id' => '107',
            'attemptid' => '17',
            'questionid' => '19',
            'newest' => '290',
            'newgraded' => '290',
            'sumpenalty' => '1.3000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            288 => (object) array(
                'id' => '288',
                'attempt' => '17',
                'question' => '19',
                'seq_number' => '0',
                'answer' => '1-,2-,3-,4-,5-,6-,7-,8-',
                'timestamp' => '1306425757',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            290 => (object) array(
                'id' => '290',
                'attempt' => '17',
                'question' => '19',
                'seq_number' => '1',
                'answer' => '1-,2-,3-,4-,5-,6-,7-,8-',
                'timestamp' => '1306425757',
                'event' => '6',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '1.3000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => 19,
            'variant' => 1,
            'maxmark' => 13.0000000,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'This question consists of some text with an answer embedded right here {Wrong answer; Another wrong answer; Correct answer; Answer that gives half the credit}

and right after that you will have to deal with this short answer _____

and finally we have a floating point number _____.

The multichoice question can also be shown in the vertical display of the standard moodle multiple choice. {1. Wrong answer; 2. Another wrong answer; 3. Correct answer; 4. Answer that gives half the credit}

Or in an horizontal display that is included here in a table {a. Wrong answer; b. Another wrong answer; c. Correct answer; d. Answer that gives half the credit}

A shortanswer question where case must match. Write moodle in upper case letters _____

Note that addresses like www.moodle.org and smileys :-) all work as normal:

a) How good is this? {Yes; No}

b) What grade would you give it? _____',
            'rightanswer' => 'part 1: Correct answer; part 2: Correct answer; part 3: 23.8; part 4: 3. Correct answer; part 5: c. Correct answer; part 6: MOODLE; part 7: Yes; part 8: 3',
            'responsesummary' => 'part 1: ; part 2: ; part 3: ; part 4: ; part 5: ; part 6: ; part 7: ; part 8: ',
            'timemodified' => 1306425757,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1306425757,
                    'userid' => 4,
                    'data' => array('_sub1_order' => '29,30,31,32',
                            '_sub3_separators' => '.$,', '_sub4_order' => '38,39,40,41',
                            '_sub5_order' => '42,43,44,45', '_sub7_order' => '49,50',
                            '_sub8_separators' => '.$,'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedwrong',
                    'fraction' => 0.0,
                    'timecreated' => 1306425757,
                    'userid' => 4,
                    'data' => array('-finish' => '1', '-_try' => '1', '-_rawfraction' => 0.0),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multianswer_adaptivenopenalty_qsession109() {
        $quiz = (object) array(
            'id' => '5',
            'course' => '2',
            'name' => 'Multianswer quiz',
            'intro' => '',
            'introformat' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questiondecimalpoints' => '-1',
            'review' => '4459503',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '14.00000',
            'grade' => '10.00000',
            'timecreated' => '0',
            'timemodified' => '1306424728',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'showuserpicture' => '0',
            'showblocks' => '0',
            'preferredbehaviour' => 'adaptivenopenalty',
        );
        $attempt = (object) array(
            'id' => '18',
            'uniqueid' => '18',
            'quiz' => '5',
            'userid' => '3',
            'attempt' => '1',
            'sumgrades' => '10.40000',
            'timestart' => '1306425784',
            'timefinish' => '1306425931',
            'timemodified' => '1306425931',
            'layout' => '28,19,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '19',
            'category' => '2',
            'parent' => '0',
            'name' => 'Cloze',
            'questiontext' => '<p>This question consists of some text with an answer embedded right  here {#1}</p>
        <p>and right after that you will have to deal with this short answer  {#2}</p>
        <p>and finally we have a floating point number  {#3}.</p>
        <p>The  multichoice question can also be shown in the vertical  display of the standard moodle multiple choice. {#4}</p>
        <p>Or in an horizontal display that is included here in a table {#5}</p>
        <p>A shortanswer question where case must match. Write moodle in  upper case letters {#6}</p>
        <p>Note that addresses like www.moodle.org and smileys :-) all work as normal:</p>
        <p>a) How good is this? {#7}</p>
        <p>b) What grade would you give it? {#8}</p>',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'penalty' => '0.1000000',
            'qtype' => 'multianswer',
            'length' => '1',
            'stamp' => 'tjh238.vledev2.open.ac.uk+110525164438+iwiint',
            'version' => 'tjh238.vledev2.open.ac.uk+110525164441+AAjnIy',
            'hidden' => '0',
            'timecreated' => '1306341878',
            'timemodified' => '1306341879',
            'createdby' => '2',
            'modifiedby' => '2',
            'maxmark' => '13.0000000',
            'options' => (object) array(
                'questions' => array(
                    1 => (object) array(
                        'id' => '20',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:MULTICHOICE:Wrong answer#Feedback for this wrong answer~Another  wrong answer#Feedback for the other wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164439+cAuJ4r',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164439+5bnnys',
                        'hidden' => '0',
                        'timecreated' => '1306341879',
                        'timemodified' => '1306341879',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '3',
                            'question' => '20',
                            'layout' => '0',
                            'answers' => array(
                                29 => (object) array(
                                    'id' => '29',
                                    'question' => '20',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                30 => (object) array(
                                    'id' => '30',
                                    'question' => '20',
                                    'answer' => 'Another  wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                31 => (object) array(
                                    'id' => '31',
                                    'question' => '20',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                32 => (object) array(
                                    'id' => '32',
                                    'question' => '20',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    2 => (object) array(
                        'id' => '21',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER:Wrong answer#Feedback for this wrong answer~=Correct  answer#Feedback for correct answer~%50%Answer that gives half the  credit#Feedback for half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+EN6wCk',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164440+bQzatI',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                33 => (object) array(
                                    'id' => '33',
                                    'question' => '21',
                                    'answer' => 'Wrong answer',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                34 => (object) array(
                                    'id' => '34',
                                    'question' => '21',
                                    'answer' => 'Correct  answer',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                35 => (object) array(
                                    'id' => '35',
                                    'question' => '21',
                                    'answer' => 'Answer that gives half the  credit',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    3 => (object) array(
                        'id' => '22',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:NUMERICAL:=23.8:0.1#Feedback for correct answer  23.8~%50%23.8:2#Feedback for half credit answer in the nearby region of  the correct answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164440+Xr29c2',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+QTwsGM',
                        'hidden' => '0',
                        'timecreated' => '1306341880',
                        'timemodified' => '1306341880',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                36 => (object) array(
                                    'id' => '36',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for correct answer  23.8',
                                    'feedbackformat' => '1',
                                    'tolerance' => '0.1',
                                ),
                                37 => (object) array(
                                    'id' => '37',
                                    'question' => '22',
                                    'answer' => '23.8',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for half credit answer in the nearby region of  the correct answer',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    4 => (object) array(
                        'id' => '23',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCV:1. Wrong answer#Feedback for this wrong answer~2. Another wrong  answer#Feedback for the other wrong answer~=3. Correct answer#Feedback  for correct answer~%50%4. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+7R55HA',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+uCMoQc',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '4',
                            'question' => '23',
                            'layout' => '1',
                            'answers' => array(
                                38 => (object) array(
                                    'id' => '38',
                                    'question' => '23',
                                    'answer' => '1. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                39 => (object) array(
                                    'id' => '39',
                                    'question' => '23',
                                    'answer' => '2. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                40 => (object) array(
                                    'id' => '40',
                                    'question' => '23',
                                    'answer' => '3. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                41 => (object) array(
                                    'id' => '41',
                                    'question' => '23',
                                    'answer' => '4. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    5 => (object) array(
                        'id' => '24',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{2:MCH:a. Wrong answer#Feedback for this wrong answer~b. Another wrong  answer#Feedback for the other wrong answer~=c. Correct answer#Feedback  for correct answer~%50%d. Answer that gives half the credit#Feedback for  half credit answer}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '2.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+QGvRpd',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+03GsSs',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '5',
                            'question' => '24',
                            'layout' => '2',
                            'answers' => array(
                                42 => (object) array(
                                    'id' => '42',
                                    'question' => '24',
                                    'answer' => 'a. Wrong answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for this wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                43 => (object) array(
                                    'id' => '43',
                                    'question' => '24',
                                    'answer' => 'b. Another wrong  answer',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for the other wrong answer',
                                    'feedbackformat' => '1',
                                ),
                                44 => (object) array(
                                    'id' => '44',
                                    'question' => '24',
                                    'answer' => 'c. Correct answer',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback  for correct answer',
                                    'feedbackformat' => '1',
                                ),
                                45 => (object) array(
                                    'id' => '45',
                                    'question' => '24',
                                    'answer' => 'd. Answer that gives half the credit',
                                    'answerformat' => '1',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  half credit answer',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '2.0000000',
                    ),
                    6 => (object) array(
                        'id' => '25',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{1:SHORTANSWER_C:moodle#Feedback for moodle in lower  case ~=MOODLE#Feedback for MOODLE in upper case ~%50%Moodle#Feedback for  only first letter in upper case}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'shortanswer',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+n9ETJC',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+Bvqo6c',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                46 => (object) array(
                                    'id' => '46',
                                    'question' => '25',
                                    'answer' => 'moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'Feedback for moodle in lower  case',
                                    'feedbackformat' => '1',
                                ),
                                47 => (object) array(
                                    'id' => '47',
                                    'question' => '25',
                                    'answer' => 'MOODLE',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Feedback for MOODLE in upper case',
                                    'feedbackformat' => '1',
                                ),
                                48 => (object) array(
                                    'id' => '48',
                                    'question' => '25',
                                    'answer' => 'Moodle',
                                    'answerformat' => '0',
                                    'fraction' => '0.5000000',
                                    'feedback' => 'Feedback for  only first letter in upper case',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'usecase' => '1',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    7 => (object) array(
                        'id' => '26',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{:MULTICHOICE:=Yes#Correct~No#We have a different opinion}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '1.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'multichoice',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+0YjnZ7',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+1giLRX',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'id' => '6',
                            'question' => '26',
                            'layout' => '0',
                            'answers' => array(
                                49 => (object) array(
                                    'id' => '49',
                                    'question' => '26',
                                    'answer' => 'Yes',
                                    'answerformat' => '1',
                                    'fraction' => '1.0000000',
                                    'feedback' => 'Correct',
                                    'feedbackformat' => '1',
                                ),
                                50 => (object) array(
                                    'id' => '50',
                                    'question' => '26',
                                    'answer' => 'No',
                                    'answerformat' => '1',
                                    'fraction' => '0.0000000',
                                    'feedback' => 'We have a different opinion',
                                    'feedbackformat' => '1',
                                ),
                            ),
                            'single' => '1',
                            'shuffleanswers' => '1',
                            'correctfeedback' => '',
                            'correctfeedbackformat' => '1',
                            'partiallycorrectfeedback' => '',
                            'partiallycorrectfeedbackformat' => '1',
                            'incorrectfeedback' => '',
                            'incorrectfeedbackformat' => '1',
                            'answernumbering' => '0',
                        ),
                        'maxgrade' => '1.0000000',
                    ),
                    8 => (object) array(
                        'id' => '27',
                        'category' => '2',
                        'parent' => '19',
                        'name' => 'Cloze',
                        'questiontext' => '{3:NUMERICAL:=3:2}',
                        'questiontextformat' => '0',
                        'generalfeedback' => '',
                        'generalfeedbackformat' => '1',
                        'defaultgrade' => '3.0000000',
                        'penalty' => '0.0000000',
                        'qtype' => 'numerical',
                        'length' => '1',
                        'stamp' => 'tjh238.vledev2.open.ac.uk+110525164441+glbCBN',
                        'version' => 'tjh238.vledev2.open.ac.uk+110525164441+xWusxR',
                        'hidden' => '0',
                        'timecreated' => '1306341881',
                        'timemodified' => '1306341881',
                        'createdby' => '2',
                        'modifiedby' => '2',
                        'options' => (object) array(
                            'answers' => array(
                                51 => (object) array(
                                    'id' => '51',
                                    'question' => '27',
                                    'answer' => '3',
                                    'answerformat' => '0',
                                    'fraction' => '1.0000000',
                                    'feedback' => '',
                                    'feedbackformat' => '1',
                                    'tolerance' => '2',
                                ),
                            ),
                            'units' => array(
                            ),
                            'unitgradingtype' => '0',
                            'unitpenalty' => '1.0000000',
                            'showunits' => '3',
                            'unitsleft' => '0',
                            'instructions' => '',
                            'instructionsformat' => '1',
                        ),
                        'maxgrade' => '3.0000000',
                    ),
                ),
            ),
            'defaultmark' => '13.0000000',
        );
        $qsession = (object) array(
            'id' => '109',
            'attemptid' => '18',
            'questionid' => '19',
            'newest' => '299',
            'newgraded' => '299',
            'sumpenalty' => '5.2000000',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '0',
        );
        $qstates = array(
            292 => (object) array(
                'id' => '292',
                'attempt' => '18',
                'question' => '19',
                'seq_number' => '0',
                'answer' => '1-,2-,3-,4-,5-,6-,7-,8-',
                'timestamp' => '1306425784',
                'event' => '0',
                'grade' => '0.0000000',
                'raw_grade' => '0.0000000',
                'penalty' => '0.0000000',
            ),
            294 => (object) array(
                'id' => '294',
                'attempt' => '18',
                'question' => '19',
                'seq_number' => '1',
                'answer' => '1-32,2-asdgf,3-saedf,4-39,5-43,6-sadf,7-,8-',
                'timestamp' => '1306425801',
                'event' => '3',
                'grade' => '0.5000000',
                'raw_grade' => '0.5000000',
                'penalty' => '1.3000000',
            ),
            295 => (object) array(
                'id' => '295',
                'attempt' => '18',
                'question' => '19',
                'seq_number' => '2',
                'answer' => '1-31,2-asdgf,3-28.3,4-40,5-44,6-MOODLE,7-49,8-13',
                'timestamp' => '1306425836',
                'event' => '3',
                'grade' => '5.7000000',
                'raw_grade' => '7.0000000',
                'penalty' => '1.3000000',
            ),
            296 => (object) array(
                'id' => '296',
                'attempt' => '18',
                'question' => '19',
                'seq_number' => '3',
                'answer' => '1-31,2-Correct answer,3-23.8,4-40,5-44,6-MOODLE,7-49,8-3',
                'timestamp' => '1306425886',
                'event' => '3',
                'grade' => '9.4000000',
                'raw_grade' => '12.0000000',
                'penalty' => '1.3000000',
            ),
            299 => (object) array(
                'id' => '299',
                'attempt' => '18',
                'question' => '19',
                'seq_number' => '4',
                'answer' => '1-31,2-Correct answer,3-23.8,4-40,5-44,6-MOODLE,7-49,8-3',
                'timestamp' => '1306425886',
                'event' => '6',
                'grade' => '9.4000000',
                'raw_grade' => '12.0000000',
                'penalty' => '1.3000000',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'adaptivenopenalty',
            'questionid' => '19',
            'variant' => 1,
            'maxmark' => '13.0000000',
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'This question consists of some text with an answer embedded right here {Wrong answer; Another wrong answer; Correct answer; Answer that gives half the credit}

and right after that you will have to deal with this short answer _____

and finally we have a floating point number _____.

The multichoice question can also be shown in the vertical display of the standard moodle multiple choice. {1. Wrong answer; 2. Another wrong answer; 3. Correct answer; 4. Answer that gives half the credit}

Or in an horizontal display that is included here in a table {a. Wrong answer; b. Another wrong answer; c. Correct answer; d. Answer that gives half the credit}

A shortanswer question where case must match. Write moodle in upper case letters _____

Note that addresses like www.moodle.org and smileys :-) all work as normal:

a) How good is this? {Yes; No}

b) What grade would you give it? _____',
            'rightanswer' => 'part 1: Correct answer; part 2: Correct answer; part 3: 23.8; part 4: 3. Correct answer; part 5: c. Correct answer; part 6: MOODLE; part 7: Yes; part 8: 3',
            'responsesummary' => 'part 1: Correct answer; part 2: Correct answer; part 3: 23.8; part 4: 3. Correct answer; part 5: c. Correct answer; part 6: MOODLE; part 7: Yes; part 8: 3',
            'timemodified' => '1306425886',
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1306425784,
                    'userid' => 3,
                    'data' => array('_sub1_order' => '29,30,31,32',
                            '_sub3_separators' => '.$,', '_sub4_order' => '38,39,40,41',
                            '_sub5_order' => '42,43,44,45', '_sub7_order' => '49,50',
                            '_sub8_separators' => '.$,'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'todo',
                    'fraction' => 0.038461538461538464,
                    'timecreated' => '1306425801',
                    'userid' => '3',
                    'data' => array('sub1_answer' => '3', 'sub2_answer' => 'asdgf',
                            'sub3_answer' => 'saedf', 'sub4_answer' => '1',
                            'sub5_answer' => '1', 'sub6_answer' => 'sadf',
                            '-_try' => '1',
                            '-_rawfraction' => '0.038461538461538464', '-submit' => '1'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'todo',
                    'fraction' => 0.43846153846153845,
                    'timecreated' => 1306425836,
                    'userid' => 3,
                    'data' => array('sub1_answer' => '2', 'sub2_answer' => 'asdgf',
                            'sub3_answer' => '28.3', 'sub4_answer' => '2',
                            'sub5_answer' => '2', 'sub6_answer' => 'MOODLE',
                            'sub7_answer' => '0', 'sub8_answer' => '13', '-_try' => 2,
                            '-_rawfraction' => 0.53846153846153845, '-submit' => 1),
                ),
                3 => (object) array(
                    'sequencenumber' => 3,
                    'state' => 'todo',
                    'fraction' => 0.72307692307692311,
                    'timecreated' => 1306425886,
                    'userid' => 3,
                    'data' => array('sub1_answer' => '2', 'sub2_answer' => 'Correct answer',
                            'sub3_answer' => '23.8', 'sub4_answer' => '2',
                            'sub5_answer' => '2', 'sub6_answer' => 'MOODLE',
                            'sub7_answer' => '0', 'sub8_answer' => '3', '-_try' => 3,
                            '-_rawfraction' => 0.92307692307692311, '-submit' => 1),
                ),
                4 => (object) array(
                    'sequencenumber' => 4,
                    'state' => 'gradedpartial',
                    'fraction' => 0.72307692307692311,
                    'timecreated' => 1306425886,
                    'userid' => 3,
                    'data' => array('sub1_answer' => '2', 'sub2_answer' => 'Correct answer',
                            'sub3_answer' => '23.8', 'sub4_answer' => '2',
                            'sub5_answer' => '2', 'sub6_answer' => 'MOODLE',
                            'sub7_answer' => '0', 'sub8_answer' => '3', '-_try' => 3,
                            '-_rawfraction' => 0.92307692307692311, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }
}
