@core @theme @theme_inspire @javascript
Feature: Inpsire theme settings basic validations
  Theme settings should work as expected
  As a user
  I need to confirm that I can navigate to theme settings and see all the different elements

  Background:
    Given I log in as "admin"
    And I am on site homepage
    And I navigate to "Inspire" node in "Site administration > Appearance > Themes"

  Scenario: Confirm inpsire brand tab has all the required elements
    When I click on "Navigation and brand" "link"
    Then I should see "Logo" in the ".tui-tabContent" "css_element"
    And the URL for image nested in ".tui-form .tui-formRow:nth-child(1)" should match "/theme\/image.php\/inspire\/totara_core\/[0-9]+\/logo/"
    And I should see "Logomark" in the ".tui-tabContent" "css_element"
    And the URL for image nested in ".tui-form .tui-formRow:nth-child(2)" should match "/theme\/image.php\/inspire\/totara_core\/[0-9]+\/sitelogomark/"
    And I should see "Logo alternative text" in the ".tui-tabContent" "css_element"
    And I should see "Favicon" in the ".tui-tabContent" "css_element"
    And the URL for image nested in ".tui-form .tui-formRow:nth-child(4)" should match "/theme\/image.php\/inspire\/theme\/[0-9]+\/favicon/"

  Scenario: Confirm inpsire colours tab has all the required elements
    When I click on "UI colours" "link"
    Then the field "Primary" matches value "#0074be"
    Then the field "Accent" matches value "#455465"
    And the field "Page text" matches value "#262626"

  Scenario: Confirm Inspire images tab has all the required elements
    When I click on "Images" "link"
    And the field "Display login page image" matches value "1"
    And the URL for image nested in "[data-testid=login-bg-image]" should match "/theme\/image.php\/inspire\/totara_core\/[0-9]+\/default_login_background/"
    And the URL for image nested in "[data-testid=course-default-image]" should match "/theme\/image.php\/inspire\/core\/[0-9]+\/course_defaultimage/"
    And the URL for image nested in "[data-testid=program-default-image]" should match "/theme\/image.php\/inspire\/totara_program\/[0-9]+\/defaultimage/"
    And the URL for image nested in "[data-testid=certification-default-image]" should match "/theme\/image.php\/inspire\/totara_certification\/[0-9]+\/defaultimage/"
    And the URL for image nested in "[data-testid=engage-resource-default-image]" should match "/theme\/image.php\/inspire\/engage_article\/[0-9]+\/default/"
    And the URL for image nested in "[data-testid=workspace-default-image]" should match "/theme\/image.php\/inspire\/container_workspace\/[0-9]+\/default_space/"

  Scenario: Confirm inspire custom tab has all the required elements
    When I click on "Custom" "link"
    Then I should see "Custom footer" in the ".tui-tabContent:nth-of-type(4)" "css_element"
    And I should see "Custom CSS" in the ".tui-tabContent:nth-of-type(4)" "css_element"
    And I click on "Email notifications" "button"
    And I should see "HTML header" in the ".tui-tabContent:nth-of-type(4)" "css_element"
    And I should see "HTML footer" in the ".tui-tabContent:nth-of-type(4)" "css_element"
    And I should see "Plain-text footer" in the ".tui-tabContent:nth-of-type(4)" "css_element"

  Scenario: Confirm that when entering custom text in the inspire footer that it displays
    When I click on "Custom" "link"
    And I set the field "Custom footer" to "Behat Test 123"
    And I click on "Save Custom Settings" "button"
    And I reload the page
    Then I should see "Behat Test 123" in the ".footnote" "css_element"

  Scenario: Confirm that the email notifications settings on the custom tab save
    When I click on "Custom" "link"
    And I click on "Email notifications" "button"
    And the following fields match these values:
      | HTML header       |  |
      | HTML footer       |  |
      | Plain-text footer |  |

    And I set the following fields to these values:
      | HTML header       | Header html       |
      | HTML footer       | Footer html       |
      | Plain-text footer | Footer plain-text |

    And I click on "Save Custom Settings" "button"
    And I reload the page
    And I click on "Custom" "link"
    And I click on "Email notifications" "button"

    And the following fields match these values:
      | HTML header       | Header html       |
      | HTML footer       | Footer html       |
      | Plain-text footer | Footer plain-text |

    # Confirm that email gets sent
    When I reset the email sink
    And I click on "Test email notification" "button"
    Then the following emails should have been sent:
      | To                 | Subject        | Body              |
      | moodle@example.com | This is a test | Body of the email |

  Scenario: Confirm that when entering custom HTML in the inspire footer that it renders correctly.
    When I click on "Custom" "link"
    And I set the field "Custom footer" to "<div id='behat_test_123'>Behat Test 123</div>"
    And I click on "Save Custom Settings" "button"
    And I reload the page
    Then I should see "Behat Test 123" in the "#behat_test_123" "css_element"

  # XSS test - which it should strip out the bad <script> tag content.
  Scenario: Custom HTML with XSS protection in the inspire footer.
    When I click on "Custom" "link"
    And I set the field "Custom footer" to "<div id='bomba_test_this'>Makag latatag, normalin</div><script id='42_meaning_of_every_thing'>alert('hi there');</script>"
    And I click on "Save Custom Settings" "button"
    And I reload the page
    Then I should see "Makag latatag, normalin" in the "#bomba_test_this" "css_element"