<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author  Kian Nguyen <kian.nguyen@totaralearning.com>
 * @package contentmarketplace_linkedin
 */

namespace contentmarketplace_linkedin\repository;

use coding_exception;
use contentmarketplace_linkedin\entity\classification_relationship;
use core\orm\entity\entity;
use core\orm\entity\repository;

class classification_relationship_repository extends repository {
    /**
     * @param classification_relationship $entity
     * @return classification_relationship
     */
    public function save_entity(entity $entity): entity {
        if ($entity->child_id === $entity->parent_id) {
            // Prevent the same classification id.
            throw new coding_exception(
                "Cannot create a relationship record of the same classification id"
            );
        }

        return parent::save_entity($entity);
    }
}