<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2014 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Valerii Kuznetsov <valerii.kuznetsov@totaralms.com>
 * @package totara_core
 */

defined('MOODLE_INTERNAL') || die();

class totara_core_event_myreport_test extends \core_phpunit\testcase {

    public function test_myreport_viewed_event() {

        $context = context_system::instance();

        // Trigger event.
        $event = \totara_core\event\myreport_viewed::create();
        $event->trigger();
        $data = $event->get_data();

        $this->assertEquals($context, $event->get_context());
        $this->assertSame('r', $data['crud']);
        $this->assertSame(\core\event\base::LEVEL_OTHER, $data['edulevel']);
        $this->assertEventContextNotUsed($event);
    }
}