<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @author Simon Coggins <simon.coggins@totaralms.com>
 * @package totara
 * @subpackage totara_customfield
 */

$string['actiondoesnotexist'] = 'The action specified does not exist.';
$string['availableevdiencecustomfields'] = 'Available Evidence Custom Fields';
$string['cachedef_areamap'] = 'Custom field area mapping';
$string['commonsettings'] = 'Common settings';
$string['competencytypescustomfields'] = 'Competency types custom fields';
$string['confirmfielddeletionnodata'] = 'Are you sure you want to delete this field?';
$string['confirmfielddeletionplural'] = 'There are {$a} records for this field which will be deleted. <br />Do you still wish to delete this field?';
$string['confirmfielddeletionsingle'] = 'There is 1 record for this field which will be deleted. <br />Do you still wish to delete this field?';
$string['coursecustomfields'] = 'Course custom fields';
$string['createnewcustomfield'] = 'Create a new custom field';
$string['createnewfield'] = 'Create a new &quot;{$a}&quot; custom field';
$string['customfield'] = 'Custom field';
$string['customfieldcolumnstextarea'] = 'Columns (text area)';
$string['customfieldcolumnstextarea_help'] = '**Columns** sets the width of text area custom field.

If a text editor plug-in is applied to the text area, the width will be determined by the plugin and changing this value may have no effect.';
$string['customfielddefaultdatacheckbox'] = 'Checked by default (Checkbox)';
$string['customfielddefaultdatacheckbox_help'] = 'When set to **Yes** the **Custom field** checkbox will be checked by default.

When set to **No** the **Custom field** checkbox will not be checked by default.';
$string['customfielddefaultdatamenu'] = 'Default value (menu of choices)';
$string['customfielddefaultdatamenu_help'] = 'Set the default value that will appear in the dropdown box. The default value must appear in the menu options above.

Leave blank if there is no default entry required.';
$string['customfielddefaultdatatext'] = 'Default value (Text input)';
$string['customfielddefaultdatatext_help'] = 'Default value is the text that will appear in the text field by default.

Leave this field blank if no default text is required.';
$string['customfielddefaultdatatextarea'] = 'Custom Field default data';
$string['customfielddefaultdatatextarea_help'] = 'Default value is the text that will appear in the text area by default.

Leave this field blank if no default text is required.';
$string['customfielddefaultdataurl'] = 'Default URL';
$string['customfielddefaultdataurl_help'] = 'Default link text to be shown. If empty the URL will be displayed.';
$string['customfielddefaultdataurltarget'] = 'Open in a new window';
$string['customfielddefaultdataurltext'] = 'Default text';
$string['customfielddefaultdataurltext_help'] = 'Default link text to be displayed. If empty the URL will be used.';
$string['customfieldfieldsizetext'] = 'Display size (Text input)';
$string['customfieldfieldsizetext_help'] = 'Display size sets the number of characters that will be displayed in the text field.';
$string['customfieldforceunique'] = 'Custom Field unique';
$string['customfieldforceunique_help'] = 'When set to **Yes** the custom field will only accept a unique value. If a duplicate value is used in this field the system will not allow the item to be saved.

When set to **No** the custom field will accept any value in the field.';
$string['customfieldfullname'] = 'Custom Field full name';
$string['customfieldfullname_help'] = 'Custom field full name is the complete title of the custom field.';
$string['customfieldhidden'] = 'Custom Field hidden';
$string['customfieldhidden_help'] = 'When set to **Yes** the custom field will not be visible on the settings page or elsewhere where it would have been shown. When **No** the custom field will be visible.';
$string['customfieldlocked'] = 'Custom Field locked';
$string['customfieldlocked_help'] = 'When set to **Yes** the custom field will only display the information given when the field was set up. The field cannot be edited for existing records and it is not locked when creating a record.';
$string['customfieldmaxlengthtext'] = 'Maximum length (Text Input)';
$string['customfieldmaxlengthtext_help'] = 'Maximum length sets the maximum number of characters the text field will accept.';
$string['customfieldmenuoptions'] = 'Menu options (Menu of choices)';
$string['customfieldmenuoptions_help'] = 'Enter the menu options that will appear in the dropdown box.

Only enter one option per line.';
$string['customfieldmultiselectoptions'] = 'Menu options (and icons)';
$string['customfieldmultiselectoptions_help'] = 'Enter the multi-select options (and icons) that will appear in the dropdown box.';
$string['customfieldrequired'] = 'This field is required';
$string['customfieldrequired_help'] = 'If set to **Yes**, it will be a compulsory field when creating new items

If set to **No**, it will be an optional field when creating new items.';
$string['customfieldrowstextarea'] = 'Rows (text area)';
$string['customfieldrowstextarea_help'] = '**Rows** sets the height of the text area custom field (the number of lines).

If a text editor plugin is applied to the text area, the height will be determined by the plugin and changing this value may have no effect.';
$string['customfields'] = 'Custom fields';
$string['customfieldshortname'] = 'Custom Field short name';
$string['customfieldshortname_help'] = 'Custom field short name is the abbreviated name of the custom field and can be used for display purposes.

Custom fields will appear as options on the edit item screen for items.

NOTE: The custom field short name can only contain alphanumeric characters (letters and numbers).';
$string['customfieldshortnamereadonly'] = 'Reserved Custom Field short name';
$string['customfieldshortnamereadonly_help'] = 'Custom field short name is the abbreviated name of the custom field and can be used for display purposes.

Custom fields will appear as options on the edit item screen for items.

A reserved custom field short name is already in use in the system. It cannot be deleted, but it can be hidden.';
$string['customfieldshortnamereserved'] = 'Custom Field is reserved';
$string['customfieldshortnamereserved_help'] = 'This custom field makes use of a reserved custom field. The type cannot be edited, and the field can\'t be deleted, but it can be hidden';
$string['customfieldtextdateformat'] = 'd/m/Y';
$string['customfieldtypecheckbox'] = 'Checkbox';
$string['customfieldtypedatetime'] = 'Date/time';
$string['customfieldtypedecimal'] = 'Decimal input';
$string['customfieldtypefile'] = 'File';
$string['customfieldtypeinteger'] = 'Integer input';
$string['customfieldtypelocation'] = 'Location';
$string['customfieldtypelocation_address'] = 'Address';
$string['customfieldtypelocation_addressdefault'] = 'Default Address';
$string['customfieldtypelocation_addresslookup'] = 'Map Location';
$string['customfieldtypelocation_addresslookupdefault'] = 'Default Map Location';
$string['customfieldtypelocation_display'] = 'Display';
$string['customfieldtypelocation_displayaddress'] = 'Address';
$string['customfieldtypelocation_displayboth'] = 'Map & Address';
$string['customfieldtypelocation_displaydefault'] = 'Default Display';
$string['customfieldtypelocation_displaymap'] = 'Map';
$string['customfieldtypelocation_mapsize'] = 'Map size';
$string['customfieldtypelocation_mapsizedefault'] = 'Default Map size';
$string['customfieldtypelocation_mapview'] = 'Map View';
$string['customfieldtypelocation_mapviewdefault'] = 'Default Map View';
$string['customfieldtypelocation_or'] = 'or';
$string['customfieldtypelocation_searchbutton'] = 'Search';
$string['customfieldtypelocation_setmap'] = 'Set map location';
$string['customfieldtypelocation_setmap_help'] = 'You can set the map location using the address above (if provided) or search for an address, town or city.

If you want to refine the location of the pin, you can do so by clicking on it while holding the mouse button, moving the pin and then releasing the mouse button.';
$string['customfieldtypelocation_sizelarge'] = 'Large';
$string['customfieldtypelocation_sizemedium'] = 'Medium';
$string['customfieldtypelocation_sizesmall'] = 'Small';
$string['customfieldtypelocation_useaddress'] = 'Use Address';
$string['customfieldtypelocation_viewhybrid'] = 'Map & Satellite (hybrid)';
$string['customfieldtypelocation_viewmap'] = 'Map';
$string['customfieldtypelocation_viewsatellite'] = 'Satellite';
$string['customfieldtypemenu'] = 'Menu of choices';
$string['customfieldtypemultiselect'] = 'Multi-select';
$string['customfieldtypetext'] = 'Text input';
$string['customfieldtypetextarea'] = 'Text area';
$string['customfieldtypeurl'] = 'URL';
$string['customfieldtypeurltarget'] = 'Open in new window';
$string['customfieldtypeurltext'] = 'Text';
$string['customfieldurl'] = 'URL';
$string['customfieldurl_help'] = 'The URL is split into three inputs.

* **URL**: Must start with **http://**, **https://**, or **/**.
* **Text**: Optional link text. If left empty, the URL will be displayed.
* **Open in new window or tab**.';
$string['customfieldurlformaterror'] = 'The URL needs to start with http://, https:// or /';
$string['customfieldvaluenumber_error'] = 'The value of \'{$a}\' field must be between or equal to the minimum value and maximum value';
$string['decimal_points'] = 'Decimal points';
$string['decimal_points_error'] = 'Only a number can be entered';
$string['decimal_points_help'] = 'The number of decimal points that the input field will accept.';
$string['defaultchecked'] = 'Checked by default';
$string['defaultdata'] = 'Default value';
$string['defaultdata_between_error'] = 'The default number must be between or equal to the minimum and maximum numbers.';
$string['defaultdata_error'] = 'Only a number can be entered';
$string['defaultdata_help'] = 'Default value is the number that will appear in the input field by default.';
$string['defaultmake'] = 'Make selected by default';
$string['defaultselected'] = 'Selected by default';
$string['deletefield'] = 'Deleting a field';
$string['description'] = 'Description of the field';
$string['description_help'] = 'A text description of this custom field.';
$string['editfield'] = 'Editing custom field: {$a}';
$string['endyear'] = 'End year';
$string['error:abstractmethod'] = 'This abstract method must be overridden';
$string['error:invaliddateformat'] = 'The \'{$a->field}\' date/time custom field contains an invalid date (\'{$a->data}\').';
$string['error:invaliddatenotunqiue'] = 'The \'{$a->field}\' date/time custom field contains a non-unique date (\'{$a->data}\').';
$string['error:invaliddatetooearly'] = 'The \'{$a->field}\' date/time custom field contains a date (\'{$a->data}\') earlier than {$a->year}.';
$string['error:invaliddatetoolate'] = 'The \'{$a->field}\' date/time custom field contains a date (\'{$a->data}\') later than {$a->year}.';
$string['error:novalue'] = 'Invalid CSV file format - "{$a}" custom field does not exist';
$string['error:updatecustomfield'] = 'Error updating custom field!';
$string['eventcreated'] = 'Customfield created';
$string['eventdeleted'] = 'Customfield deleted';
$string['eventupdated'] = 'Customfield updated';
$string['evidencecustomfields'] = 'Evidence custom fields';
$string['fieldcolumns'] = 'Columns';
$string['fieldispassword'] = 'Is this a password field?';
$string['fieldmaxlength'] = 'Maximum length';
$string['fieldrows'] = 'Rows';
$string['fieldsize'] = 'Display size';
$string['forceunique'] = 'Should the data be unique?';
$string['gmaptosnotice_apikey'] = 'Please check that your site adheres to the <a href="https://developers.google.com/maps/terms" target="_blank">Google Maps JavaScript API Terms Of Service</a> before changing the view to include a map.';
$string['gmaptosnotice_nokey'] = 'Please check that your site adheres to the <a href="https://developers.google.com/maps/terms" target="_blank">Google Maps JavaScript API Terms Of Service</a> before changing the view to include a map.

We strongly recommend your get a Google Maps JavaScript API Key or Client ID and set it within Totara.';
$string['locationnotfound'] = 'Location not found';
$string['locked'] = 'Is this field locked?';
$string['max_number'] = 'Maximum value';
$string['max_number_error'] = 'Only a number can be entered';
$string['max_number_help'] = 'The highest number that the input field will accept.';
$string['menudefaultnotinoptions'] = 'The default value is not one of the options';
$string['menunooptions'] = 'No menu options supplied';
$string['menunotuniqueoptions'] = 'Menu options should be unique';
$string['menuoptions'] = 'Menu options (one per line)';
$string['menutoofewoptions'] = 'You must provide at least 2 options';
$string['min_max_number_error'] = 'Maximum number must be larger than the minimum number.';
$string['min_number'] = 'Minimum value';
$string['min_number_error'] = 'Only a number can be entered';
$string['min_number_help'] = 'The lowest number that the input field will accept.';
$string['multiselectcolumnicon'] = '{$a} (icons)';
$string['multiselectcolumntext'] = '{$a} (text)';
$string['multiselectdeleteunlink'] = 'Deleting menu option from custom field settings will not remove it from the records where it is currently selected';
$string['multiselectoptions'] = 'Menu options (and icons)';
$string['nocustomfieldsdefined'] = 'No fields have been defined';
$string['nofileselected'] = 'No file selected';
$string['notset'] = 'Not set';
$string['optionxtext'] = 'Option {$a} text';
$string['organisationtypescustomfields'] = 'Organisation types custom fields';
$string['pluginname'] = 'Customfields';
$string['positiontypescustomfields'] = 'Position types custom fields';
$string['programcertcustomfields'] = 'Program and Certification custom fields';
$string['readonlyemptyfield'] = '-';
$string['regexpattern'] = 'Regular expression validation';
$string['regexpattern_help'] = 'A regular expression that will be used to ensure entered text is in the expected format. For example **/^[0-9]{3}$/** will ensure the text consists of exactly three numbers.

This validation is performed only when submitting forms with custom fields, current data is not affected after validation is changed.

For more information on regular expressions please refer to the PHP PCRE regular expression documentation.';
$string['regexpatterndelimitererror'] = 'A delimiter or modifier was used that is not permitted. Permitted delimiters: forward slash (/) only. Permitted modifiers: PCRE_CASELESS (i) only.';
$string['regexpatternerror'] = 'The regular expression you have entered is not valid. Information on regular expression syntax and patterns can be found in the PHP PCRE regular expression documentation.';
$string['regexpatternmessage'] = 'Description of regular expression validation format';
$string['regexpatternmessage_help'] = 'Add description message explaining required format to users.';
$string['regexvalidationfailed'] = 'The value you have entered for {$a} does not match the required format.';
$string['returntoframework'] = 'Return to Framework';
$string['shortname'] = 'Short name (must be unique)';
$string['shortnamenotunique'] = 'This short name is already in use';
$string['shortnamereserved'] = 'Short name (reserved)';
$string['specificsettings'] = 'Specific settings';
$string['startyear'] = 'Start year';
$string['startyearafterend'] = 'The start year can\'t occur after the end year';
$string['step_decimal'] = 'Step';
$string['step_decimal_help'] = 'For example, if step="0.5", the numbers could be -1.0, -0.5, 0, 0.5, 1.0, 1.5, and so on.';
$string['step_number'] = 'Step';
$string['step_number_error'] = 'Only a non zero number can be entered';
$string['step_number_help'] = 'For example, if step="3", the numbers could be -3, 0, 3, 6, and so on.';
$string['undelete'] = 'Undelete';
$string['user_value_error'] = 'Only a number can be entered';
$string['user_value_max_error'] = 'The value of \'{$a->field}\' field must be less than or equal to {$a->max} (maximum value)';
$string['user_value_min_error'] = 'The value of \'{$a->field}\' field must be greater than or equal to {$a->min} (minimum value)';
$string['user_value_step_error'] = 'The value must be a multiple of {$a->step} starting from {$a->default}';
$string['visible'] = 'Hidden on the settings page?';
$string['wanttime'] = 'Include time?';

/**
 * # Deprecated since Totara 12
 */
$string['requiredandlockednotallowed'] = 'The combination of required and locked is not allowed. Please, change one of them';
