<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralearning.com>
 * @package flavour_engage
 */

namespace flavour_engage;

use perform_goal\settings_helper;
use totara_core\advanced_feature;
use totara_flavour\flavour_without_perform;

defined('MOODLE_INTERNAL') || die();

/**
 * Engage flavour definition
 */
class definition extends flavour_without_perform {

    /**
     * @inheritDoc
     */
    public function get_component() {
        return 'flavour_engage';
    }

    /**
     * @inheritDoc
     */
    protected function load_default_settings() {
        return [
            '' => [
                // Enable Engage only features
                'enableengage_resources' => advanced_feature::ENABLED,
                'enablecontainer_workspace' => advanced_feature::ENABLED,
                'enabletotara_msteams' => advanced_feature::ENABLED,
                'enableml_recommender' => advanced_feature::ENABLED,
            ],

            'perform_goal' => [
                'goals_choice' => settings_helper::NO_GOALS,
            ],
        ];
    }

    /**
     * @inheritDoc
     */
    protected function load_enforced_settings() {
        $enforced_settings = [
            '' => [
                // Disable Perform only features
                // Non-legacy features
                'enableperformance_activities' => advanced_feature::DISABLED,
                'enableperform_goals' => advanced_feature::DISABLED,
                'enablecompetency_assignment' => advanced_feature::DISABLED,
                'enablegoals' => advanced_feature::DISABLED,
                // Legacy features
                'enableappraisals' => advanced_feature::DISABLED,
                'enablefeedback360' => advanced_feature::DISABLED,
                // Disable Learn only features
                // Non-legacy features
                'enableoutcomes' => 0,
                'enableportfolios' => 0,
                'enablecompletion' => 0,
                'completiondefault' => 0,
                'enableavailability' => 0,
                'enablecourserpl' => 0,
                'enablemodulerpl' => [],
                'enableplagiarism' => 0,
                'enablecontentmarketplaces' => 0,
                'enableprogramextensionrequests' => 0,
                'enablelearningplans' => advanced_feature::DISABLED,
                'enableprograms' => advanced_feature::DISABLED,
                'enablecertifications' => advanced_feature::DISABLED,
                'enablerecordoflearning' => advanced_feature::DISABLED,
                'enableprogramcompletioneditor' => 0,
            ],
        ];

        return array_merge_recursive($enforced_settings, parent::load_enforced_settings());
    }
}
