@totara @totara_hierarchy @totara_hierarchy_organisation @totara_customfield @javascript
Feature: Test organisation type changes in hierarchies

  Scenario: Change type of organisation in a hierarchy
    Given I am on a totara site
    And the following "users" exist:
      | username  | firstname | lastname  | email                 |
      | manager   | Site      | Manager   | manager@example.com   |
    And the following "role assigns" exist:
      | user      | role      | contextlevel | reference |
      | manager   | manager   | System       |           |

    And the following hierarchy types exist:
      | hierarchy    | idnumber | fullname            |
      | organisation | orgtype1 | Organisation type 1 |
      | organisation | orgtype2 | Organisation type 2 |

    And the following hierarchy type custom fields exist:
      | hierarchy    | typeidnumber | type | fullname         | shortname | value |
      | organisation | orgtype1     | text | Custom field 1_1 | CF1_1     |       |
      | organisation | orgtype1     | text | Custom field 1_2 | CF1_2     |       |
      | organisation | orgtype2     | text | Custom field 2_1 | CF2_1     |       |

    And the following "goal" frameworks exist:
      | fullname             | idnumber | description           |
      | Goal framework       | FW001    | Framework description |
    And the following "goal" hierarchy exists:
      | framework | fullname         | idnumber | description             |
      | FW001     | GoalOne          | GOAL001  | This is a goal          |

    And I log in as "manager"
    And I navigate to "Manage organisations" node in "Site administration > Organisations"
    And I press "Add new organisation framework"
    And I set the following fields to these values:
      | Name | My organisation frameworkd 1 |
    And I press "Save changes"
    And I follow "My organisation frameworkd 1"
    And I press "Add new organisation"
    And I set the following fields to these values:
      | Name | My organisation 1 |
      | Type | Organisation type 1     |
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I click on "Edit" "link" in the "My organisation 1" "table_row"
    And I set the following fields to these values:
      | Custom field 1_1 | Some text 1 |
      | Custom field 1_2 | Some text 2 |
    And I press "Save changes"
    # Check that a notification about a task to be processed displays.
    And I press "Add Goal"
    And I click on "GoalOne" "link" in the "Assign goals" "totaradialogue"
    And I press "Save"
    And I should see "An update request is being processed, and changes will be applied by the system as soon as possible." in the "//div[contains(@class, 'alert-warning')]/div[@class='alert-message']" "xpath_element"
    And I press "Return to organisation framework"
    And I press "Add new organisation"
    And I set the following fields to these values:
      | Name | My organisation 2 |
      | Type | Organisation type 1     |
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I click on "Edit" "link" in the "My organisation 2" "table_row"
    And I set the following fields to these values:
      | Custom field 1_1 | Some text 3 |
      | Custom field 1_2 | Some text 4 |
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I press "Add new organisation"
    And I set the following fields to these values:
      | Name | My organisation 3 |
      | Type | Organisation type 1     |
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I click on "Edit" "link" in the "My organisation 3" "table_row"
    And I set the following fields to these values:
      | Custom field 1_1 | Some text 5 |
      | Custom field 1_2 | Some text 6 |
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I should see "Type: Organisation type 1" in the "My organisation 1" "table_row"
    And I should see "Type: Organisation type 1" in the "My organisation 2" "table_row"
    And I should see "Type: Organisation type 1" in the "My organisation 3" "table_row"

    # Change type of single item
    When I click on "Edit" "link" in the "My organisation 1" "table_row"
    And I press "Change type"
    And I click on "Choose" "button" in the "Organisation type 2" "table_row"
    And I set the following fields to these values:
      | Data in Custom field 1_1 (Text input): | Transfer to Custom field 2_1 (Text input) |
      | Data in Custom field 1_2 (Text input): | Delete this data                          |
    And I press "Reclassify items and transfer/delete data"
    Then the field "Custom field 2_1" matches value "Some text 1"
    And I press "Save changes"
    And I press "Return to organisation framework"
    And I should see "Type: Organisation type 2" in the "My organisation 1" "table_row"
    And I should see "Type: Organisation type 1" in the "My organisation 2" "table_row"
    And I should see "Type: Organisation type 1" in the "My organisation 3" "table_row"

    # Bulk change types
    When I navigate to "Manage types" node in "Site administration > Organisations"
    And I set the following fields to these values:
      | Reclassify of all items from the type: | Organisation type 1 |
    And I click on "Choose" "button" in the "Organisation type 2" "table_row"
    And I set the following fields to these values:
      | Data in Custom field 1_1 (Text input): | Transfer to Custom field 2_1 (Text input) |
      | Data in Custom field 1_2 (Text input): | Delete this data                          |
    When I press "Reclassify items and transfer/delete data"
    And I navigate to "Manage organisations" node in "Site administration > Organisations"
    And I follow "My organisation frameworkd 1"
    And I should see "Type: Organisation type 2" in the "My organisation 1" "table_row"
    And I should see "Type: Organisation type 2" in the "My organisation 2" "table_row"
    And I should see "Type: Organisation type 2" in the "My organisation 3" "table_row"
