<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Tatsuhiro Kirihara <tatsuhiro.kirihara@totaralearning.com>
 * @package totara_msteams
 */

use totara_msteams\botfw\activity;
use totara_msteams\botfw\router\null_router;
use totara_msteams\botfw\router\router;

class totara_msteams_botfw_router_null_test extends \core_phpunit\testcase {
    /** @var router */
    private $router;

    public function setUp(): void {
        $this->router = new null_router();
    }

    protected function tearDown(): void {
        $this->router = null;
        parent::tearDown();
    }

    public function test_get_routes() {
        $this->assertCount(0, $this->router->get_routes());
    }

    public function test_find_best_match() {
        $activity = new activity();
        $this->assertNull($this->router->find_best_match($activity));
    }
}
