<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Ciaran Irvine <ciaran.irvine@totaralms.com>
 * @author Alastair Munro <alastair.munro@totaralms.com>
 * @package totara
 * @subpackage plan
 */

/**
 * Local database upgrade script
 *
 * @param   integer $oldversion Current (pre-upgrade) local db version timestamp
 * @return  boolean $result
 */
function xmldb_totara_plan_upgrade($oldversion) {
    global $CFG, $DB;

    require_once($CFG->dirroot . '/totara/plan/db/upgradelib.php');

    $dbman = $DB->get_manager();

    // Totara 13.0 release line.

    if ($oldversion < 2021112200) {
        totara_plan_upgrade_record_of_learning();

        // Plan savepoint reached.
        upgrade_plugin_savepoint(true, 2021112200, 'totara', 'plan');
    }

    if ($oldversion < 2025070801) {
        $table = new xmldb_table('dp_priority_scale_value');
        $field = new xmldb_field('name', XMLDB_TYPE_CHAR, '510', null, null, null, null, 'id');

        if ($dbman->field_exists($table, $field)) {
            $dbman->change_field_precision($table, $field);
        }

        $table = new xmldb_table('dp_objective_scale_value');
        $field = new xmldb_field('name', XMLDB_TYPE_CHAR, '510', null, null, null, null, 'objscaleid');

        if ($dbman->field_exists($table, $field)) {
            $dbman->change_field_precision($table, $field);
        }

        upgrade_plugin_savepoint(true, 2025070801, 'totara', 'plan');
    }

    return true;
}
