<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2019 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralearning.com>
 * @author David Curry <david.curry@totaralearning.com>
 * @package totara_program
 */

namespace totara_program\webapi\resolver\query;

use context_program;
use core\webapi\execution_context;
use core\webapi\middleware\require_login;
use core\webapi\query_resolver;
use totara_core\advanced_feature;
use totara_program\program as program_class;

/**
 * Query to return a program
 */
class program extends query_resolver {

    /**
     *
     * @param array $args
     * @param execution_context $ec
     */
    public static function resolve(array $args, execution_context $ec) {
        global $USER;

        if (advanced_feature::is_disabled('programs')) {
            throw new \coding_exception('Programs have been disabled.');
        }

        $program = new program_class($args['programid']);

        // Don't allow program query to return certifications.
        if (!empty($program->certifid)) {
            throw new \coding_exception('Invalid program.');
        }

        // Don't allow the user to view programs they don't have access to.
        if (!$program->is_viewable($USER)) {
            throw new \coding_exception('Current user can not access this program.');
        }

        $ec->set_relevant_context(context_program::instance($program->id));

        return $program;
    }

    public static function get_middleware(): array {
        return [
            require_login::class
        ];
    }

}
