@totara @totara_reportbuilder @javascript
Feature: Test my reports page

  Background:
    Given I am on a totara site
    And the following "standard_report" exist in "totara_reportbuilder" plugin:
      | fullname             | shortname                   | source | summary                     | hidden |
      | Custom user report 1 | report_custom_user_report_1 | user   | User report 1 abstract text | 0      |
      | Custom user report 2 | report_custom_user_report_2 | user   | User report 2 abstract text | 0      |
      | Custom user report 3 | report_custom_user_report_3 | user   | User report 3 abstract text | 1      |
    And I log in as "admin"

  Scenario: The my reports page displays reports allowing users to navigate to the report
    Given I click on "Reports" in the totara menu
    Then I should see "Custom user report 1"
    And  I should see "Custom user report 2"
    And "Custom user report 1" "text" should appear before "Custom user report 2" "text"
    When I follow "Custom user report 1"
    Then I should see "Custom user report 1"
    And I should see "Results - 2 records"
    When I click on "Reports" in the totara menu
    And I follow "Custom user report 2"
    Then I should see "Custom user report 2"
    And I should see "Results - 2 records"
    When I click on "Reports" in the totara menu
    And I click on "[role=radio][aria-label='List view']" "css_element"
    Then I should see "Custom user report 1"
    And  I should see "Custom user report 2"
    And "Custom user report 1" "text" should appear before "Custom user report 2" "text"
    And I click on "[role=radio][aria-label='Tile view']" "css_element"
    Then I should see "Custom user report 1"
    And  I should see "Custom user report 2"
    And "Custom user report 1" "text" should appear before "Custom user report 2" "text"

  Scenario: Reports can be hidden on the my reports page
    When I click on "Reports" in the totara menu
    Then I should see "Custom user report 1"
    And  I should see "Custom user report 2"
    And  I should not see "Custom user report 3"
    And "Custom user report 1" "text" should appear before "Custom user report 2" "text"

  Scenario: The display of the abstract text can be turned on or off
    Given I click on "Reports" in the totara menu
    Then I should not see "User report 1 abstract text"
    And  I should not see "User report 2 abstract text"
    When I navigate to "General settings" node in "Site administration > Reports"
    And I set the following fields to these values:
      | Show report abstract | 1 |
    And I press "Save changes"
    And I should see "Changes saved"
    And I click on "Reports" in the totara menu
    Then I should see "User report 1 abstract text"
    And  I should see "User report 2 abstract text"

  Scenario: Disabling the create user reports feature
    When I click on "Reports" in the totara menu
    Then I should see "Create report"
    When I navigate to "Manage user reports" node in "Site administration > Reports"
    Then "input[value='Create report']" "css_element" should be visible
    When I disable the "user_reports" advanced feature
    And I click on "Reports" in the totara menu
    Then I should not see "Create report"
    When I navigate to "Manage user reports" node in "Site administration > Reports"
    Then "input[value='Create report']" "css_element" should not be visible

  Scenario: Test a My Reports page with a report that has problematic settings.
    # For an embedded report, edit its settings so that it not hidden in User reports and all records are shown.
    When I navigate to "Manage embedded reports" node in "Site administration > Reports"
    And I set the field "report-name" to "Performance activity participant instances"
    And I press "id_submitgroupstandard_addfilter"
    And I follow "Performance activity participant instances"
    And I click on "id_hidden" "checkbox"
    And I press "Save changes"
    And I switch to "Content" tab
    And I click on "Show all records" "radio"
    And I press "Save changes"
    # Clone the embedded report with the dodgy settings, so we now have a User report based on it.
    And I navigate to "Manage embedded reports" node in "Site administration > Reports"
    And I click on "Clone report" "link"
    And I press "Clone"
    And I click on "Reports" in the totara menu
    # We expect the page not to throw an error, but instead handle the error & display a message.
    And I should see "Some reports contain errors; please contact your administrator"
