<?php
/*
 * This file is part of Totara Talent Experience Platform
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Kunle Odusan <kunle.odusan@totara.com>
 * @package totara_tenant
 */

defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->libdir . '/adminlib.php');

/**
 * Class for enabling isolation mode in multitenancy
 *
 * NOTE: This is not a public API - do not use in plugins or 3rd party code!
 */
final class totara_tenant_admin_setting_isolation extends admin_setting_configcheckbox {
    public function __construct() {
        parent::__construct(
            'tenantsisolated',
            new lang_string('tenantsisolated', 'totara_tenant'),
            new lang_string('tenantsisolated_desc', 'totara_tenant'),
            0
        );
        $this->set_updatedcallback('purge_all_caches');
    }
}
