<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Qingyang Liu <qingyang.liu@totaralearning.com>
 * @package totara_topic
 */

namespace totara_topic\watcher;

use core\hook\phpunit_reset;
use totara_topic\resolver\resolver_factory;

class phpunit_reset_watcher {
    /**
     * @param phpunit_reset $hook
     */
    public static function reset_data(phpunit_reset $hook): void {
        if (class_exists('\totara_topic\resolver\resolver_factory')) {
            resolver_factory::phpunit_clear_resolver();
        }
    }
}