<?php
/**
 * This file is part of Totara TXP
 *
 * Copyright (C) 2022 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralearning.com>
 * @package totara_webapi
 */

namespace totara_webapi\endpoint_type;

class dev extends base {

    /**
     * Override default behaviour for additional checks during development.
     *
     * @return bool
     */
    public function validate_schema(): bool {
        return true;
    }

    /**
     * @inheritDoc
     */
    public function allow_direct_queries(): bool {
        return true;
    }

    /**
     * @inheritDoc
     */
    public function allow_persistent_queries(): bool {
        return false;
    }

    /**
     * @inheritDoc
     */
    public function require_sesskey(): bool {
        return false;
    }

    /**
     * @inheritDoc
     */
    public function use_all_schemas(): bool {
        return true;
    }

}